/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.io.IOException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jsse.BCSNIHostName;
import org.bouncycastle.jsse.BCSNIMatcher;
import org.bouncycastle.jsse.BCSNIServerName;
import org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import org.bouncycastle.tls.AlertDescription;
import org.bouncycastle.tls.AlertLevel;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.ProtocolName;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.ServerName;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCertificate;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class JsseUtils {
    static final Set<BCCryptoPrimitive> TLS_CRYPTO_PRIMITIVES_BC = Collections.unmodifiableSet(EnumSet.of(BCCryptoPrimitive.KEY_AGREEMENT));
    protected static X509Certificate[] EMPTY_CHAIN = new X509Certificate[0];

    JsseUtils() {
    }

    static boolean contains(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    static String[] copyOf(String[] stringArray, int n) {
        String[] stringArray2 = new String[n];
        System.arraycopy(stringArray, 0, stringArray2, 0, Math.min(stringArray.length, n));
        return stringArray2;
    }

    static String[] resize(String[] stringArray, int n) {
        if (n < stringArray.length) {
            stringArray = JsseUtils.copyOf(stringArray, n);
        }
        return stringArray;
    }

    static String getApplicationProtocol(SecurityParameters securityParameters) {
        if (null == securityParameters || !securityParameters.isApplicationProtocolSet()) {
            return null;
        }
        ProtocolName protocolName = securityParameters.getApplicationProtocol();
        if (null == protocolName) {
            return "";
        }
        return protocolName.getUtf8Decoding();
    }

    static String getAuthStringClient(short s) throws IOException {
        switch (s) {
            case 1: {
                return "RSA";
            }
            case 2: {
                return "DSA";
            }
            case 3: {
                return "EC";
            }
        }
        throw new TlsFatalAlert(80);
    }

    public static String getAuthTypeClient(short s) throws IOException {
        switch (s) {
            case 2: {
                return "DSA";
            }
            case 64: {
                return "EC";
            }
            case 1: {
                return "RSA";
            }
        }
        throw new TlsFatalAlert(80);
    }

    public static String getAuthTypeServer(int n) throws IOException {
        switch (n) {
            case 11: {
                return "DH_anon";
            }
            case 3: {
                return "DHE_DSS";
            }
            case 14: {
                return "DHE_PSK";
            }
            case 5: {
                return "DHE_RSA";
            }
            case 20: {
                return "ECDH_anon";
            }
            case 17: {
                return "ECDHE_ECDSA";
            }
            case 24: {
                return "ECDHE_PSK";
            }
            case 19: {
                return "ECDHE_RSA";
            }
            case 1: {
                return "RSA";
            }
            case 15: {
                return "RSA_PSK";
            }
            case 21: {
                return "SRP";
            }
            case 22: {
                return "SRP_DSS";
            }
            case 23: {
                return "SRP_RSA";
            }
        }
        throw new TlsFatalAlert(80);
    }

    public static Certificate getCertificateMessage(TlsCrypto tlsCrypto, X509Certificate[] x509CertificateArray) throws IOException {
        if (x509CertificateArray == null || x509CertificateArray.length < 1) {
            return Certificate.EMPTY_CHAIN;
        }
        TlsCertificate[] tlsCertificateArray = new TlsCertificate[x509CertificateArray.length];
        try {
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                tlsCertificateArray[i] = tlsCrypto.createCertificate(x509CertificateArray[i].getEncoded());
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new TlsFatalAlert(80, (Throwable)certificateEncodingException);
        }
        return new Certificate(tlsCertificateArray);
    }

    public static String getHashAlgorithmName(short s) {
        switch (s) {
            case 1: {
                return "MD5";
            }
            case 2: {
                return "SHA1";
            }
            case 3: {
                return "SHA224";
            }
            case 4: {
                return "SHA256";
            }
            case 5: {
                return "SHA384";
            }
            case 6: {
                return "SHA512";
            }
        }
        return null;
    }

    public static Vector getProtocolNames(String[] stringArray) {
        if (null == stringArray || stringArray.length < 1) {
            return null;
        }
        Vector<ProtocolName> vector = new Vector<ProtocolName>(stringArray.length);
        for (String string : stringArray) {
            vector.addElement(ProtocolName.asUtf8Encoding(string));
        }
        return vector;
    }

    public static List<String> getProtocolNames(Vector vector) {
        if (null == vector || vector.isEmpty()) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            ProtocolName protocolName = (ProtocolName)vector.elementAt(i);
            arrayList.add(protocolName.getUtf8Decoding());
        }
        return arrayList;
    }

    public static String getSignatureAlgorithmName(short s) {
        switch (s) {
            case 2: {
                return "DSA";
            }
            case 3: {
                return "ECDSA";
            }
            case 1: {
                return "RSA";
            }
        }
        return null;
    }

    public static String getSignatureSchemeName(SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        String string;
        short s = signatureAndHashAlgorithm.getHash();
        short s2 = signatureAndHashAlgorithm.getSignature();
        int n = (s & 0xFF) << 8 | s2 & 0xFF;
        switch (n) {
            case 1027: {
                return "SHA256withECDSA";
            }
            case 1283: {
                return "SHA384withECDSA";
            }
            case 1539: {
                return "SHA512withECDSA";
            }
            case 515: {
                return "SHA1withECDSA";
            }
            case 2055: {
                return "ed25519";
            }
            case 2056: {
                return "ed448";
            }
            case 513: {
                return "SHA1withRSA";
            }
            case 1025: {
                return "SHA256withRSA";
            }
            case 1281: {
                return "SHA384withRSA";
            }
            case 1537: {
                return "SHA512withRSA";
            }
            case 2052: 
            case 2053: 
            case 2054: 
            case 2057: 
            case 2058: 
            case 2059: {
                return "RSASSA-PSS";
            }
        }
        String string2 = JsseUtils.getHashAlgorithmName(s);
        if (null != string2 && null != (string = JsseUtils.getSignatureAlgorithmName(s2))) {
            return string2 + "with" + string;
        }
        return null;
    }

    public static String[] getSignatureSchemeNames(Vector vector) {
        if (null == vector) {
            return new String[0];
        }
        int n = vector.size();
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            String string = JsseUtils.getSignatureSchemeName((SignatureAndHashAlgorithm)vector.elementAt(i));
            if (null == string) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static X509Certificate[] getX509CertificateChain(TlsCrypto tlsCrypto, Certificate certificate) {
        if (certificate == null || certificate.isEmpty()) {
            return EMPTY_CHAIN;
        }
        try {
            X509Certificate[] x509CertificateArray = new X509Certificate[certificate.getLength()];
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                x509CertificateArray[i] = JcaTlsCertificate.convert((JcaTlsCrypto)tlsCrypto, certificate.getCertificateAt(i)).getX509Certificate();
            }
            return x509CertificateArray;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static X509Certificate[] getX509CertificateChain(java.security.cert.Certificate[] certificateArray) {
        if (certificateArray == null) {
            return null;
        }
        if (certificateArray instanceof X509Certificate[]) {
            return (X509Certificate[])certificateArray;
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        for (int i = 0; i < certificateArray.length; ++i) {
            java.security.cert.Certificate certificate = certificateArray[i];
            if (!(certificate instanceof X509Certificate)) {
                return null;
            }
            x509CertificateArray[i] = (X509Certificate)certificate;
        }
        return x509CertificateArray;
    }

    public static X500Principal getSubject(TlsCrypto tlsCrypto, Certificate certificate) {
        if (certificate == null || certificate.isEmpty()) {
            return null;
        }
        try {
            return JcaTlsCertificate.convert((JcaTlsCrypto)tlsCrypto, certificate.getCertificateAt(0)).getX509Certificate().getSubjectX500Principal();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    static String getAlertLogMessage(String string, short s, short s2) {
        return string + " " + AlertLevel.getText(s) + " " + AlertDescription.getText(s2) + " alert";
    }

    static Vector getSupportedSignatureAlgorithms(TlsCrypto tlsCrypto) {
        short[] sArray = new short[]{2, 3, 4, 5, 6};
        short[] sArray2 = new short[]{1, 3};
        Vector vector = new Vector();
        for (int i = 0; i < sArray2.length; ++i) {
            for (int j = 0; j < sArray.length; ++j) {
                TlsUtils.addIfSupported(vector, tlsCrypto, new SignatureAndHashAlgorithm(sArray[j], sArray2[i]));
            }
        }
        TlsUtils.addIfSupported(vector, tlsCrypto, new SignatureAndHashAlgorithm(2, 2));
        return vector;
    }

    public static boolean isUsableKeyForServer(int n, PrivateKey privateKey) throws IOException {
        if (privateKey == null) {
            return false;
        }
        String string = privateKey.getAlgorithm();
        switch (n) {
            case 17: {
                return privateKey instanceof ECPrivateKey || "EC".equals(string);
            }
            case 3: 
            case 22: {
                return privateKey instanceof DSAPrivateKey || "DSA".equals(string);
            }
            case 1: 
            case 5: 
            case 15: 
            case 19: 
            case 23: {
                return privateKey instanceof RSAPrivateKey || "RSA".equals(string);
            }
        }
        return false;
    }

    static Set<X500Principal> toX500Principals(X500Name[] x500NameArray) throws IOException {
        if (x500NameArray == null || x500NameArray.length == 0) {
            return Collections.emptySet();
        }
        HashSet<X500Principal> hashSet = new HashSet<X500Principal>(x500NameArray.length);
        for (int i = 0; i < x500NameArray.length; ++i) {
            X500Name x500Name = x500NameArray[i];
            if (x500Name == null) continue;
            hashSet.add(new X500Principal(x500Name.getEncoded("DER")));
        }
        return hashSet;
    }

    static X500Name toX500Name(Principal principal) {
        if (principal == null) {
            return null;
        }
        if (principal instanceof X500Principal) {
            return X500Name.getInstance((Object)((X500Principal)principal).getEncoded());
        }
        return new X500Name(principal.getName());
    }

    static Set<X500Name> toX500Names(Principal[] principalArray) {
        if (principalArray == null || principalArray.length == 0) {
            return Collections.emptySet();
        }
        HashSet<X500Name> hashSet = new HashSet<X500Name>(principalArray.length);
        for (int i = 0; i != principalArray.length; ++i) {
            X500Name x500Name = JsseUtils.toX500Name(principalArray[i]);
            if (x500Name == null) continue;
            hashSet.add(x500Name);
        }
        return hashSet;
    }

    static BCSNIServerName convertSNIServerName(ServerName serverName) {
        short s = serverName.getNameType();
        byte[] byArray = serverName.getNameData();
        switch (s) {
            case 0: {
                return new BCSNIHostName(byArray);
            }
        }
        return new BCUnknownServerName(s, byArray);
    }

    static List<BCSNIServerName> convertSNIServerNames(Vector vector) {
        if (null == vector || vector.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BCSNIServerName> arrayList = new ArrayList<BCSNIServerName>(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            arrayList.add(JsseUtils.convertSNIServerName((ServerName)enumeration.nextElement()));
        }
        return Collections.unmodifiableList(arrayList);
    }

    static BCSNIServerName findMatchingSNIServerName(Vector vector, Collection<BCSNIMatcher> collection) {
        if (!vector.isEmpty()) {
            List<BCSNIServerName> list = JsseUtils.convertSNIServerNames(vector);
            block0: for (BCSNIMatcher bCSNIMatcher : collection) {
                if (null == bCSNIMatcher) continue;
                int n = bCSNIMatcher.getType();
                for (BCSNIServerName bCSNIServerName : list) {
                    if (null == bCSNIServerName || bCSNIServerName.getType() != n) continue;
                    if (!bCSNIMatcher.matches(bCSNIServerName)) continue block0;
                    return bCSNIServerName;
                }
            }
        }
        return null;
    }

    static String stripDoubleQuotes(String string) {
        return JsseUtils.stripOuterChars(string, '\"', '\"');
    }

    static String stripSquareBrackets(String string) {
        return JsseUtils.stripOuterChars(string, '[', ']');
    }

    private static String stripOuterChars(String string, char c, char c2) {
        int n;
        if (string != null && (n = string.length() - 1) > 0 && string.charAt(0) == c && string.charAt(n) == c2) {
            return string.substring(1, n);
        }
        return string;
    }

    static class BCUnknownServerName
    extends BCSNIServerName {
        BCUnknownServerName(int n, byte[] byArray) {
            super(n, byArray);
        }
    }
}

