/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.bouncycastle.jsse.BCX509ExtendedTrustManager;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.provider.CipherSuiteInfo;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.DummyX509KeyManager;
import org.bouncycastle.jsse.provider.DummyX509TrustManager;
import org.bouncycastle.jsse.provider.FipsUtils;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.KeyStoreConfig;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvAlgorithmConstraints;
import org.bouncycastle.jsse.provider.ProvKeyManagerFactorySpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLServerSocketFactory;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.ProvSSLSocketFactory;
import org.bouncycastle.jsse.provider.ProvTrustManagerFactorySpi;
import org.bouncycastle.jsse.provider.SSLEngineUtil;
import org.bouncycastle.jsse.provider.X509KeyManagerUtil;
import org.bouncycastle.jsse.provider.X509TrustManagerUtil;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvSSLContextSpi
extends SSLContextSpi {
    private static final Logger LOG = Logger.getLogger(ProvSSLContextSpi.class.getName());
    private static final String PROPERTY_CLIENT_PROTOCOLS = "jdk.tls.client.protocols";
    private static final String PROPERTY_SERVER_PROTOCOLS = "jdk.tls.server.protocols";
    private static final Map<String, CipherSuiteInfo> SUPPORTED_CIPHERSUITE_MAP = ProvSSLContextSpi.createSupportedCipherSuiteMap();
    private static final Map<String, CipherSuiteInfo> SUPPORTED_CIPHERSUITE_MAP_FIPS = ProvSSLContextSpi.createSupportedCipherSuiteMapFips(SUPPORTED_CIPHERSUITE_MAP);
    private static final Map<String, ProtocolVersion> SUPPORTED_PROTOCOL_MAP = ProvSSLContextSpi.createSupportedProtocolMap();
    private static final Map<String, ProtocolVersion> SUPPORTED_PROTOCOL_MAP_FIPS = ProvSSLContextSpi.createSupportedProtocolMapFips(SUPPORTED_PROTOCOL_MAP);
    private static final List<String> DEFAULT_CIPHERSUITE_LIST = ProvSSLContextSpi.createDefaultCipherSuiteList(SUPPORTED_CIPHERSUITE_MAP.keySet());
    private static final List<String> DEFAULT_CIPHERSUITE_LIST_FIPS = ProvSSLContextSpi.createDefaultCipherSuiteListFips(DEFAULT_CIPHERSUITE_LIST);
    private static final String[] DEFAULT_ENABLED_PROTOCOLS = new String[]{"TLSv1.2", "TLSv1.1", "TLSv1"};
    protected final boolean isInFipsMode;
    protected final TlsCryptoProvider cryptoProvider;
    protected final Map<String, CipherSuiteInfo> supportedCipherSuites;
    protected final Map<String, ProtocolVersion> supportedProtocols;
    protected final String[] defaultCipherSuites;
    protected final String[] defaultProtocolsClient;
    protected final String[] defaultProtocolsServer;
    protected boolean initialized = false;
    private TlsCrypto crypto;
    private X509ExtendedKeyManager x509KeyManager;
    private BCX509ExtendedTrustManager x509TrustManager;
    private ProvSSLSessionContext clientSessionContext;
    private ProvSSLSessionContext serverSessionContext;

    private static void addCipherSuite(Map<String, CipherSuiteInfo> map, String string, int n) {
        CipherSuiteInfo cipherSuiteInfo = CipherSuiteInfo.forCipherSuite(n, string);
        if (null != map.put(string, cipherSuiteInfo)) {
            throw new IllegalStateException("Duplicate names in supported-cipher-suites");
        }
    }

    private static List<String> createDefaultCipherSuiteList(Set<String> set) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256");
        arrayList.add("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384");
        arrayList.add("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256");
        arrayList.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384");
        arrayList.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256");
        arrayList.add("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA");
        arrayList.add("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA");
        arrayList.add("TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA");
        arrayList.add("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA");
        arrayList.add("TLS_RSA_WITH_AES_256_GCM_SHA384");
        arrayList.add("TLS_RSA_WITH_AES_128_GCM_SHA256");
        arrayList.add("TLS_RSA_WITH_AES_256_CBC_SHA256");
        arrayList.add("TLS_RSA_WITH_AES_128_CBC_SHA256");
        arrayList.add("TLS_RSA_WITH_AES_256_CBC_SHA");
        arrayList.add("TLS_RSA_WITH_AES_128_CBC_SHA");
        arrayList.retainAll(set);
        arrayList.trimToSize();
        return Collections.unmodifiableList(arrayList);
    }

    private static List<String> createDefaultCipherSuiteListFips(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>(list);
        FipsUtils.removeNonFipsCipherSuites(arrayList);
        arrayList.trimToSize();
        return Collections.unmodifiableList(arrayList);
    }

    private static Map<String, CipherSuiteInfo> createSupportedCipherSuiteMap() {
        TreeMap<String, CipherSuiteInfo> treeMap = new TreeMap<String, CipherSuiteInfo>();
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA", 19);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", 50);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", 64);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", 162);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", 56);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_AES_256_CBC_SHA256", 106);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", 163);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA", 22);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", 51);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", 103);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_AES_128_CCM", 49310);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_AES_128_CCM_8", 49314);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", 158);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", 57);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", 107);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_AES_256_CCM", 49311);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_AES_256_CCM_8", 49315);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", 159);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256", 52394);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA", 49160);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", 49161);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", 49187);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_AES_128_CCM", 49324);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8", 49326);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", 49195);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", 49162);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", 49188);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_AES_256_CCM", 49325);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8", 49327);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", 49196);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", 52393);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_ECDSA_WITH_NULL_SHA", 49158);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA", 49170);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", 49171);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", 49191);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", 49199);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", 49172);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", 49192);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", 49200);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", 52392);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_ECDHE_RSA_WITH_NULL_SHA", 49168);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_3DES_EDE_CBC_SHA", 10);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_AES_128_CBC_SHA", 47);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_AES_128_CBC_SHA256", 60);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_AES_128_CCM", 49308);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_AES_128_CCM_8", 49312);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_AES_128_GCM_SHA256", 156);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_AES_256_CBC_SHA", 53);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_AES_256_CBC_SHA256", 61);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_AES_256_CCM", 49309);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_AES_256_CCM_8", 49313);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_AES_256_GCM_SHA384", 157);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_NULL_SHA", 2);
        ProvSSLContextSpi.addCipherSuite(treeMap, "TLS_RSA_WITH_NULL_SHA256", 59);
        return Collections.unmodifiableMap(treeMap);
    }

    private static Map<String, CipherSuiteInfo> createSupportedCipherSuiteMapFips(Map<String, CipherSuiteInfo> map) {
        LinkedHashMap<String, CipherSuiteInfo> linkedHashMap = new LinkedHashMap<String, CipherSuiteInfo>(map);
        FipsUtils.removeNonFipsCipherSuites(linkedHashMap.keySet());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    private static Map<String, ProtocolVersion> createSupportedProtocolMap() {
        LinkedHashMap<String, ProtocolVersion> linkedHashMap = new LinkedHashMap<String, ProtocolVersion>();
        linkedHashMap.put("TLSv1.2", ProtocolVersion.TLSv12);
        linkedHashMap.put("TLSv1.1", ProtocolVersion.TLSv11);
        linkedHashMap.put("TLSv1", ProtocolVersion.TLSv10);
        return Collections.unmodifiableMap(linkedHashMap);
    }

    private static Map<String, ProtocolVersion> createSupportedProtocolMapFips(Map<String, ProtocolVersion> map) {
        LinkedHashMap<String, ProtocolVersion> linkedHashMap = new LinkedHashMap<String, ProtocolVersion>(map);
        FipsUtils.removeNonFipsCipherSuites(linkedHashMap.keySet());
        return Collections.unmodifiableMap(linkedHashMap);
    }

    private static String[] getDefaultCipherSuites(boolean bl) {
        List<String> list = bl ? DEFAULT_CIPHERSUITE_LIST_FIPS : DEFAULT_CIPHERSUITE_LIST;
        String[] stringArray = new String[list.size()];
        int n = 0;
        for (String string : list) {
            if (!ProvAlgorithmConstraints.DEFAULT.permits(JsseUtils.TLS_CRYPTO_PRIMITIVES_BC, string, null)) continue;
            stringArray[n++] = string;
        }
        return JsseUtils.resize(stringArray, n);
    }

    private static String[] getDefaultEnabledProtocolCandidates(String[] stringArray, String string) {
        if (stringArray != null) {
            return stringArray;
        }
        String[] stringArray2 = ProvSSLContextSpi.getJdkTlsProtocols(string);
        if (stringArray2 != null) {
            return stringArray2;
        }
        return DEFAULT_ENABLED_PROTOCOLS;
    }

    private static String[] getDefaultEnabledProtocols(Map<String, ProtocolVersion> map, String[] stringArray, String string) {
        String[] stringArray2 = ProvSSLContextSpi.getDefaultEnabledProtocolCandidates(stringArray, string);
        String[] stringArray3 = new String[stringArray2.length];
        int n = 0;
        for (String string2 : stringArray2) {
            if (!map.containsKey(string2) || !ProvAlgorithmConstraints.DEFAULT_TLS_ONLY.permits(JsseUtils.TLS_CRYPTO_PRIMITIVES_BC, string2, null)) continue;
            stringArray3[n++] = string2;
        }
        return JsseUtils.resize(stringArray3, n);
    }

    private static String[] getDefaultEnabledProtocolsClient(Map<String, ProtocolVersion> map, String[] stringArray) {
        return ProvSSLContextSpi.getDefaultEnabledProtocols(map, stringArray, PROPERTY_CLIENT_PROTOCOLS);
    }

    private static String[] getDefaultEnabledProtocolsServer(Map<String, ProtocolVersion> map) {
        return ProvSSLContextSpi.getDefaultEnabledProtocols(map, null, PROPERTY_SERVER_PROTOCOLS);
    }

    private static String[] getJdkTlsProtocols(String string) {
        String[] stringArray = PropertyUtils.getStringArraySystemProperty(string);
        if (null == stringArray) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        for (String string2 : stringArray) {
            if (!SUPPORTED_PROTOCOL_MAP.containsKey(string2)) {
                LOG.warning("'" + string + "' contains unsupported protocol: " + string2);
                continue;
            }
            if (JsseUtils.contains(stringArray2, string2)) continue;
            stringArray2[n++] = string2;
        }
        if (n < 1) {
            LOG.severe("'" + string + "' contained no supported protocol values (ignoring)");
            return null;
        }
        return JsseUtils.resize(stringArray2, n);
    }

    private static String[] getArray(Collection<String> collection) {
        return collection.toArray(new String[collection.size()]);
    }

    private static String[] getKeysArray(Map<String, ?> map) {
        return ProvSSLContextSpi.getArray(map.keySet());
    }

    static CipherSuiteInfo getCipherSuiteInfo(String string) {
        return SUPPORTED_CIPHERSUITE_MAP.get(string);
    }

    static String getCipherSuiteName(int n) {
        if (0 == n) {
            return "SSL_NULL_WITH_NULL_NULL";
        }
        if (TlsUtils.isValidUint16(n)) {
            for (CipherSuiteInfo cipherSuiteInfo : SUPPORTED_CIPHERSUITE_MAP.values()) {
                if (cipherSuiteInfo.getCipherSuite() != n) continue;
                return cipherSuiteInfo.getName();
            }
        }
        return null;
    }

    static KeyManager[] getDefaultKeyManagers() throws Exception {
        KeyStoreConfig keyStoreConfig = ProvKeyManagerFactorySpi.getDefaultKeyStore();
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStoreConfig.keyStore, keyStoreConfig.password);
        return keyManagerFactory.getKeyManagers();
    }

    static TrustManager[] getDefaultTrustManagers() throws Exception {
        KeyStore keyStore = ProvTrustManagerFactorySpi.getDefaultTrustStore();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        return trustManagerFactory.getTrustManagers();
    }

    static String getProtocolVersionName(ProtocolVersion protocolVersion) {
        if (null != protocolVersion) {
            for (Map.Entry<String, ProtocolVersion> entry : SUPPORTED_PROTOCOL_MAP.entrySet()) {
                if (!entry.getValue().equals(protocolVersion)) continue;
                return entry.getKey();
            }
        }
        return "NONE";
    }

    ProvSSLContextSpi(boolean bl, TlsCryptoProvider tlsCryptoProvider, String[] stringArray) {
        this.isInFipsMode = bl;
        this.cryptoProvider = tlsCryptoProvider;
        this.supportedCipherSuites = bl ? SUPPORTED_CIPHERSUITE_MAP_FIPS : SUPPORTED_CIPHERSUITE_MAP;
        this.supportedProtocols = bl ? SUPPORTED_PROTOCOL_MAP_FIPS : SUPPORTED_PROTOCOL_MAP;
        this.defaultCipherSuites = ProvSSLContextSpi.getDefaultCipherSuites(bl);
        this.defaultProtocolsClient = ProvSSLContextSpi.getDefaultEnabledProtocolsClient(this.supportedProtocols, stringArray);
        this.defaultProtocolsServer = ProvSSLContextSpi.getDefaultEnabledProtocolsServer(this.supportedProtocols);
    }

    ProvSSLSessionContext createSSLSessionContext() {
        return new ProvSSLSessionContext(this, this.crypto);
    }

    String[] getDefaultCipherSuites() {
        return (String[])this.defaultCipherSuites.clone();
    }

    ProvSSLParameters getDefaultParameters(boolean bl) {
        return new ProvSSLParameters(this, this.defaultCipherSuites, this.getDefaultProtocols(bl));
    }

    String[] getDefaultProtocols(boolean bl) {
        return bl ? this.getDefaultProtocolsServer() : this.getDefaultProtocolsClient();
    }

    String[] getDefaultProtocolsClient() {
        return this.defaultProtocolsClient;
    }

    String[] getDefaultProtocolsServer() {
        return this.defaultProtocolsServer;
    }

    int[] getActiveCipherSuites(TlsCrypto tlsCrypto, ProvSSLParameters provSSLParameters, ProtocolVersion[] protocolVersionArray) {
        String[] stringArray = provSSLParameters.getCipherSuitesArray();
        BCAlgorithmConstraints bCAlgorithmConstraints = provSSLParameters.getAlgorithmConstraints();
        int[] nArray = new int[stringArray.length];
        int n = 0;
        for (String string : stringArray) {
            CipherSuiteInfo cipherSuiteInfo = this.supportedCipherSuites.get(string);
            if (null == cipherSuiteInfo || !bCAlgorithmConstraints.permits(JsseUtils.TLS_CRYPTO_PRIMITIVES_BC, string, null)) continue;
            nArray[n++] = cipherSuiteInfo.getCipherSuite();
        }
        return TlsUtils.getSupportedCipherSuites(tlsCrypto, nArray, n);
    }

    ProtocolVersion[] getActiveProtocolVersions(ProvSSLParameters provSSLParameters) {
        String[] stringArray = provSSLParameters.getProtocolsArray();
        BCAlgorithmConstraints bCAlgorithmConstraints = provSSLParameters.getAlgorithmConstraints();
        TreeSet<ProtocolVersion> treeSet = new TreeSet<ProtocolVersion>(new Comparator<ProtocolVersion>(){

            @Override
            public int compare(ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2) {
                return protocolVersion.isLaterVersionOf(protocolVersion2) ? -1 : (protocolVersion2.isLaterVersionOf(protocolVersion) ? 1 : 0);
            }
        });
        for (String string : stringArray) {
            ProtocolVersion protocolVersion = this.supportedProtocols.get(string);
            if (null == protocolVersion || !bCAlgorithmConstraints.permits(JsseUtils.TLS_CRYPTO_PRIMITIVES_BC, string, null)) continue;
            treeSet.add(protocolVersion);
        }
        return treeSet.toArray(new ProtocolVersion[treeSet.size()]);
    }

    boolean isDefaultProtocols(String[] stringArray) {
        return stringArray == this.getDefaultProtocolsClient() || stringArray == this.getDefaultProtocolsServer();
    }

    String[] getSupportedCipherSuites() {
        return ProvSSLContextSpi.getKeysArray(this.supportedCipherSuites);
    }

    String[] getSupportedCipherSuites(String[] stringArray) {
        if (null == stringArray) {
            throw new NullPointerException("'cipherSuites' cannot be null");
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (String string : stringArray) {
            if (null == string || string.length() < 1) {
                throw new IllegalArgumentException("'cipherSuites' cannot contain null or empty string elements");
            }
            if (!this.supportedCipherSuites.containsKey(string)) continue;
            arrayList.add(string);
        }
        return ProvSSLContextSpi.getArray(arrayList);
    }

    String[] getSupportedProtocols() {
        return ProvSSLContextSpi.getKeysArray(this.supportedProtocols);
    }

    boolean isFips() {
        return this.isInFipsMode;
    }

    boolean isSupportedProtocols(String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        for (String string : stringArray) {
            if (string != null && this.supportedProtocols.containsKey(string)) continue;
            return false;
        }
        return true;
    }

    void updateDefaultProtocols(ProvSSLParameters provSSLParameters, boolean bl) {
        if (this.isDefaultProtocols(provSSLParameters.getProtocolsArray())) {
            provSSLParameters.setProtocolsArray(this.getDefaultProtocols(bl));
        }
    }

    void validateNegotiatedCipherSuite(ProvSSLParameters provSSLParameters, int n) {
        String string = ProvSSLContextSpi.getCipherSuiteName(n);
        if (null == string || !JsseUtils.contains(provSSLParameters.getCipherSuitesArray(), string) || !provSSLParameters.getAlgorithmConstraints().permits(JsseUtils.TLS_CRYPTO_PRIMITIVES_BC, string, null) || !this.supportedCipherSuites.containsKey(string) || this.isInFipsMode && !FipsUtils.isFipsCipherSuite(string)) {
            throw new IllegalStateException("SSL connection negotiated unsupported ciphersuite: " + n);
        }
    }

    void validateNegotiatedProtocol(ProvSSLParameters provSSLParameters, ProtocolVersion protocolVersion) {
        String string = ProvSSLContextSpi.getProtocolVersionName(protocolVersion);
        if (null == string || !JsseUtils.contains(provSSLParameters.getProtocolsArray(), string) || !provSSLParameters.getAlgorithmConstraints().permits(JsseUtils.TLS_CRYPTO_PRIMITIVES_BC, string, null) || !this.supportedProtocols.containsKey(string) || this.isInFipsMode && !FipsUtils.isFipsProtocol(string)) {
            throw new IllegalStateException("SSL connection negotiated unsupported protocol: " + protocolVersion);
        }
    }

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("SSLContext has not been initialized.");
        }
    }

    @Override
    protected synchronized SSLEngine engineCreateSSLEngine() {
        this.checkInitialized();
        return SSLEngineUtil.create(this, this.createContextData());
    }

    @Override
    protected synchronized SSLEngine engineCreateSSLEngine(String string, int n) {
        this.checkInitialized();
        return SSLEngineUtil.create(this, this.createContextData(), string, n);
    }

    @Override
    protected synchronized SSLSessionContext engineGetClientSessionContext() {
        return this.clientSessionContext;
    }

    @Override
    protected synchronized SSLSessionContext engineGetServerSessionContext() {
        return this.serverSessionContext;
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() {
        this.checkInitialized();
        return new ProvSSLServerSocketFactory(this);
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() {
        this.checkInitialized();
        return new ProvSSLSocketFactory(this);
    }

    @Override
    protected synchronized void engineInit(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
        this.initialized = false;
        this.crypto = this.cryptoProvider.create(secureRandom);
        this.x509KeyManager = this.selectX509KeyManager(keyManagerArray);
        this.x509TrustManager = this.selectX509TrustManager(trustManagerArray);
        this.clientSessionContext = this.createSSLSessionContext();
        this.serverSessionContext = this.createSSLSessionContext();
        this.crypto.getSecureRandom().nextInt();
        this.initialized = true;
    }

    protected ContextData createContextData() {
        return new ContextData(this.crypto, this.x509KeyManager, this.x509TrustManager, this.clientSessionContext, this.serverSessionContext);
    }

    protected X509ExtendedKeyManager selectX509KeyManager(KeyManager[] keyManagerArray) throws KeyManagementException {
        if (keyManagerArray != null) {
            for (KeyManager keyManager : keyManagerArray) {
                if (!(keyManager instanceof X509KeyManager)) continue;
                return X509KeyManagerUtil.importX509KeyManager((X509KeyManager)keyManager);
            }
        }
        return DummyX509KeyManager.INSTANCE;
    }

    protected BCX509ExtendedTrustManager selectX509TrustManager(TrustManager[] trustManagerArray) throws KeyManagementException {
        if (trustManagerArray == null) {
            try {
                TrustManager[] trustManagerArray2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerArray2.init((KeyStore)null);
                trustManagerArray = trustManagerArray2.getTrustManagers();
            }
            catch (Exception exception) {
                LOG.log(Level.WARNING, "Failed to load default trust managers", exception);
            }
        }
        if (trustManagerArray != null) {
            for (TrustManager trustManager : trustManagerArray) {
                if (!(trustManager instanceof X509TrustManager)) continue;
                return X509TrustManagerUtil.importX509TrustManager((X509TrustManager)trustManager);
            }
        }
        return DummyX509TrustManager.INSTANCE;
    }
}

