/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.net.Socket;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jsse.provider.JsseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProvX509KeyManagerSimple
extends X509ExtendedKeyManager {
    private final Map<String, Credential> credentials = new HashMap<String, Credential>();

    ProvX509KeyManagerSimple(KeyStore keyStore, char[] cArray) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (null == keyStore) {
            return;
        }
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.entryInstanceOf(string, KeyStore.PrivateKeyEntry.class)) continue;
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(string, cArray);
            X509Certificate[] x509CertificateArray = JsseUtils.getX509CertificateChain(keyStore.getCertificateChain(string));
            if (x509CertificateArray == null || x509CertificateArray.length <= 0) continue;
            this.credentials.put(string, new Credential(privateKey, x509CertificateArray));
        }
    }

    @Override
    public String chooseClientAlias(String[] stringArray, Principal[] principalArray, Socket socket) {
        return this.chooseAlias(false, stringArray, principalArray);
    }

    @Override
    public String chooseEngineClientAlias(String[] stringArray, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseAlias(false, stringArray, principalArray);
    }

    @Override
    public String chooseEngineServerAlias(String string, Principal[] principalArray, SSLEngine sSLEngine) {
        return this.chooseAlias(true, new String[]{string}, principalArray);
    }

    @Override
    public String chooseServerAlias(String string, Principal[] principalArray, Socket socket) {
        return this.chooseAlias(true, new String[]{string}, principalArray);
    }

    @Override
    public X509Certificate[] getCertificateChain(String string) {
        Credential credential = this.getCredential(string);
        return credential == null ? null : (X509Certificate[])credential.getCertificateChain().clone();
    }

    @Override
    public String[] getClientAliases(String string, Principal[] principalArray) {
        return this.getAliases(false, string, principalArray);
    }

    @Override
    public PrivateKey getPrivateKey(String string) {
        Credential credential = this.getCredential(string);
        return credential == null ? null : credential.getPrivateKey();
    }

    @Override
    public String[] getServerAliases(String string, Principal[] principalArray) {
        return this.getAliases(true, string, principalArray);
    }

    private String chooseAlias(boolean bl, String[] stringArray, Principal[] principalArray) {
        Set<X500Name> set = JsseUtils.toX500Names(principalArray);
        for (String string : stringArray) {
            for (Map.Entry<String, Credential> entry : this.credentials.entrySet()) {
                if (!this.isSuitableCredential(bl, string, set, entry.getValue())) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    private String[] getAliases(boolean bl, String string, Principal[] principalArray) {
        Set<X500Name> set = JsseUtils.toX500Names(principalArray);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, Credential> entry : this.credentials.entrySet()) {
            if (!this.isSuitableCredential(bl, string, set, entry.getValue())) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private Credential getCredential(String string) {
        return string == null ? null : this.credentials.get(string);
    }

    private boolean hasSuitableIssuer(Set<X500Name> set, X509Certificate x509Certificate) {
        return set.contains(JsseUtils.toX500Name(x509Certificate.getIssuerX500Principal()));
    }

    private boolean isSuitableCredential(boolean bl, String string, Set<X500Name> set, Credential credential) {
        X509Certificate[] x509CertificateArray = credential.getCertificateChain();
        if (!this.isSuitableCertificate(bl, string, x509CertificateArray[0])) {
            return false;
        }
        if (set == null || set.isEmpty()) {
            return true;
        }
        int n = x509CertificateArray.length;
        while (--n >= 0) {
            if (!this.hasSuitableIssuer(set, x509CertificateArray[n])) continue;
            return true;
        }
        return false;
    }

    private boolean isSuitableCertificate(boolean bl, String string, X509Certificate x509Certificate) {
        if (string == null || x509Certificate == null) {
            return false;
        }
        PublicKey publicKey = x509Certificate.getPublicKey();
        if (string.equalsIgnoreCase("DHE_RSA") || string.equalsIgnoreCase("ECDHE_RSA") || string.equalsIgnoreCase("SRP_RSA")) {
            return publicKey instanceof RSAPublicKey && ProvX509KeyManagerSimple.isSuitableKeyUsage(128, x509Certificate);
        }
        if (string.equalsIgnoreCase("DHE_DSS") || string.equalsIgnoreCase("SRP_DSS")) {
            return publicKey instanceof DSAPublicKey && ProvX509KeyManagerSimple.isSuitableKeyUsage(128, x509Certificate);
        }
        if (string.equalsIgnoreCase("ECDHE_ECDSA")) {
            return publicKey instanceof ECPublicKey && ProvX509KeyManagerSimple.isSuitableKeyUsage(128, x509Certificate);
        }
        if (string.equalsIgnoreCase("RSA")) {
            int n = bl ? 32 : 128;
            return publicKey instanceof RSAPublicKey && ProvX509KeyManagerSimple.isSuitableKeyUsage(n, x509Certificate);
        }
        if (string.equalsIgnoreCase("DSA")) {
            return !bl && publicKey instanceof DSAPublicKey && ProvX509KeyManagerSimple.isSuitableKeyUsage(128, x509Certificate);
        }
        if (string.equalsIgnoreCase("EC")) {
            return publicKey instanceof ECPublicKey && ProvX509KeyManagerSimple.isSuitableKeyUsage(128, x509Certificate);
        }
        return false;
    }

    static boolean isSuitableKeyUsage(int n, X509Certificate x509Certificate) {
        try {
            boolean[] blArray = x509Certificate.getKeyUsage();
            if (null == blArray) {
                return true;
            }
            int n2 = 0;
            int n3 = Math.min(32, blArray.length);
            for (int i = 0; i < n3; ++i) {
                if (!blArray[i]) continue;
                int n4 = i & 7;
                int n5 = i - n4;
                n2 |= 128 >>> n4 << n5;
            }
            return (n2 & n) == n;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static class Credential {
        private final PrivateKey privateKey;
        private final X509Certificate[] certificateChain;

        Credential(PrivateKey privateKey, X509Certificate[] x509CertificateArray) {
            this.privateKey = privateKey;
            this.certificateChain = x509CertificateArray;
        }

        X509Certificate[] getCertificateChain() {
            return this.certificateChain;
        }

        PrivateKey getPrivateKey() {
            return this.privateKey;
        }
    }
}

