/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.lang.reflect.Method;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import org.bouncycastle.jsse.BCExtendedSSLSession;
import org.bouncycastle.jsse.BCSSLEngine;
import org.bouncycastle.jsse.BCSSLParameters;
import org.bouncycastle.jsse.provider.ContextData;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLEngine;
import org.bouncycastle.jsse.provider.ReflectionUtil;
import org.bouncycastle.jsse.provider.SSLParametersUtil;
import org.bouncycastle.jsse.provider.SSLSessionUtil;

abstract class SSLEngineUtil {
    private static final Method getHandshakeSession;
    private static final Method getSSLParameters;

    SSLEngineUtil() {
    }

    static SSLEngine create(ProvSSLContextSpi provSSLContextSpi, ContextData contextData) {
        return new ProvSSLEngine(provSSLContextSpi, contextData);
    }

    static SSLEngine create(ProvSSLContextSpi provSSLContextSpi, ContextData contextData, String string, int n) {
        return new ProvSSLEngine(provSSLContextSpi, contextData, string, n);
    }

    static BCExtendedSSLSession importHandshakeSession(SSLEngine sSLEngine) {
        if (sSLEngine instanceof BCSSLEngine) {
            return ((BCSSLEngine)((Object)sSLEngine)).getBCHandshakeSession();
        }
        if (null != sSLEngine && null != getHandshakeSession) {
            try {
                SSLSession sSLSession = (SSLSession)ReflectionUtil.invokeGetter(sSLEngine, getHandshakeSession);
                if (null != sSLSession) {
                    return SSLSessionUtil.importSSLSession(sSLSession);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static BCSSLParameters importSSLParameters(SSLEngine sSLEngine) {
        if (sSLEngine instanceof BCSSLEngine) {
            return ((BCSSLEngine)((Object)sSLEngine)).getParameters();
        }
        if (null != sSLEngine && null != getSSLParameters) {
            try {
                SSLParameters sSLParameters = (SSLParameters)ReflectionUtil.invokeGetter(sSLEngine, getSSLParameters);
                if (null != sSLParameters) {
                    return SSLParametersUtil.importSSLParameters(sSLParameters);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        Method[] methodArray = ReflectionUtil.getMethods("javax.net.ssl.SSLEngine");
        getHandshakeSession = ReflectionUtil.findMethod(methodArray, "getHandshakeSession");
        getSSLParameters = ReflectionUtil.findMethod(methodArray, "getSSLParameters");
    }
}

