/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.util.Arrays;

public class Certificate {
    private static final TlsCertificate[] EMPTY_CERTS = new TlsCertificate[0];
    public static final Certificate EMPTY_CHAIN = new Certificate(EMPTY_CERTS);
    protected final byte[] certificateRequestContext;
    protected final TlsCertificate[] certificateList;

    public Certificate(TlsCertificate[] tlsCertificateArray) {
        this(null, tlsCertificateArray);
    }

    Certificate(byte[] byArray, TlsCertificate[] tlsCertificateArray) {
        if (null != byArray && !TlsUtils.isValidUint8(byArray.length)) {
            throw new IllegalArgumentException("'certificateRequestContext' cannot be longer than 255");
        }
        if (null == tlsCertificateArray) {
            throw new NullPointerException("'certificateList' cannot be null");
        }
        this.certificateRequestContext = byArray;
        this.certificateList = tlsCertificateArray;
    }

    public byte[] getCertificateRequestContext() {
        return Arrays.clone((byte[])this.certificateRequestContext);
    }

    public TlsCertificate[] getCertificateList() {
        return this.cloneCertificateList();
    }

    public TlsCertificate getCertificateAt(int n) {
        return this.certificateList[n];
    }

    public int getLength() {
        return this.certificateList.length;
    }

    public boolean isEmpty() {
        return this.certificateList.length == 0;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(null, outputStream, null);
    }

    public void encode(TlsContext tlsContext, OutputStream outputStream, OutputStream outputStream2) throws IOException {
        Object object;
        int n;
        boolean bl;
        if (null != this.certificateRequestContext != (bl = TlsUtils.isTLSv13(tlsContext))) {
            throw new IllegalStateException();
        }
        if (bl) {
            TlsUtils.writeOpaque8(this.certificateRequestContext, outputStream);
        }
        Vector<byte[]> vector = new Vector<byte[]>(this.certificateList.length);
        int n2 = 0;
        for (n = 0; n < this.certificateList.length; ++n) {
            object = this.certificateList[n];
            byte[] byArray = object.getEncoded();
            if (n == 0 && outputStream2 != null) {
                Certificate.calculateEndPointHash(tlsContext, (TlsCertificate)object, byArray, outputStream2);
            }
            vector.addElement(byArray);
            n2 += byArray.length + 3;
            if (!bl) continue;
        }
        TlsUtils.checkUint24(n2);
        TlsUtils.writeUint24(n2, outputStream);
        for (n = 0; n < vector.size(); ++n) {
            object = (byte[])vector.elementAt(n);
            TlsUtils.writeOpaque24((byte[])object, outputStream);
        }
    }

    public static Certificate parse(TlsContext tlsContext, InputStream inputStream) throws IOException {
        return Certificate.parse(tlsContext, inputStream, null);
    }

    public static Certificate parse(TlsContext tlsContext, InputStream inputStream, OutputStream outputStream) throws IOException {
        Object[] objectArray;
        int n;
        boolean bl = TlsUtils.isTLSv13(tlsContext);
        byte[] byArray = null;
        if (bl) {
            byArray = TlsUtils.readOpaque8(inputStream);
        }
        if ((n = TlsUtils.readUint24(inputStream)) == 0) {
            return bl ? new Certificate(byArray, EMPTY_CERTS) : EMPTY_CHAIN;
        }
        byte[] byArray2 = TlsUtils.readFully(n, inputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        Vector<TlsCertificate> vector = new Vector<TlsCertificate>();
        while (byteArrayInputStream.available() > 0) {
            objectArray = TlsUtils.readOpaque24(byteArrayInputStream, 1);
            TlsCertificate tlsCertificate = tlsContext.getCrypto().createCertificate((byte[])objectArray);
            if (vector.isEmpty() && outputStream != null) {
                Certificate.calculateEndPointHash(tlsContext, tlsCertificate, objectArray, outputStream);
            }
            vector.addElement(tlsCertificate);
            if (!bl) continue;
        }
        objectArray = new TlsCertificate[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i] = (byte)((TlsCertificate)vector.elementAt(i));
        }
        return new Certificate(byArray, (TlsCertificate[])objectArray);
    }

    protected static void calculateEndPointHash(TlsContext tlsContext, TlsCertificate tlsCertificate, byte[] byArray, OutputStream outputStream) throws IOException {
        byte[] byArray2 = TlsUtils.calculateEndPointHash(tlsContext, tlsCertificate.getSigAlgOID(), byArray);
        if (byArray2 != null && byArray2.length > 0) {
            outputStream.write(byArray2);
        }
    }

    protected TlsCertificate[] cloneCertificateList() {
        TlsCertificate[] tlsCertificateArray = new TlsCertificate[this.certificateList.length];
        System.arraycopy(this.certificateList, 0, tlsCertificateArray, 0, tlsCertificateArray.length);
        return tlsCertificateArray;
    }
}

