/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.Vector;
import java.util.logging.Logger;
import org.bouncycastle.jsse.provider.FipsUtils;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SupportedGroups {
    private static final Logger LOG = Logger.getLogger(SupportedGroups.class.getName());
    private static final String PROPERTY_NAMED_GROUPS = "jdk.tls.namedGroups";
    private static final boolean provDisableChar2 = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.ec.disableChar2", false) || PropertyUtils.getBooleanSystemProperty("org.bouncycastle.ec.disable_f2m", false);
    private static final int[] provJdkTlsNamedGroups = SupportedGroups.getJdkTlsNamedGroups(provDisableChar2);
    private static final int[] defaultClientNamedGroups = new int[]{29, 23, 24, 25, 256, 257, 258};

    SupportedGroups() {
    }

    private static int getDefaultDH(int n) {
        return n <= 2048 ? 256 : (n <= 3072 ? 257 : (n <= 4096 ? 258 : (n <= 6144 ? 259 : (n <= 8192 ? 260 : -1))));
    }

    private static int getDefaultECDH(int n) {
        return n <= 256 ? 23 : (n <= 384 ? 24 : (n <= 521 ? 25 : -1));
    }

    private static int[] getJdkTlsNamedGroups(boolean bl) {
        String[] stringArray = PropertyUtils.getStringArraySystemProperty(PROPERTY_NAMED_GROUPS);
        if (null == stringArray) {
            return null;
        }
        int[] nArray = new int[stringArray.length];
        int n = 0;
        for (String string : stringArray) {
            int n2 = NamedGroup.getByName(Strings.toLowerCase((String)string));
            if (n2 < 0) {
                LOG.warning("'jdk.tls.namedGroups' contains unrecognised NamedGroup: " + string);
                continue;
            }
            if (bl && NamedGroup.isChar2Curve(n2)) {
                LOG.warning("'jdk.tls.namedGroups' contains disabled characteristic-2 curve: " + string);
                continue;
            }
            nArray[n++] = n2;
        }
        if (n < nArray.length) {
            nArray = Arrays.copyOf((int[])nArray, (int)n);
        }
        if (nArray.length < 1) {
            LOG.severe("'jdk.tls.namedGroups' contained no usable NamedGroup values");
        }
        return nArray;
    }

    static Vector<Integer> getClientSupportedGroups(JcaTlsCrypto jcaTlsCrypto, boolean bl, Vector<Integer> vector) {
        int[] nArray = provJdkTlsNamedGroups != null ? provJdkTlsNamedGroups : defaultClientNamedGroups;
        boolean bl2 = vector.contains(1);
        boolean bl3 = vector.contains(2);
        boolean bl4 = vector.contains(3);
        Vector<Integer> vector2 = new Vector<Integer>();
        for (int n : nArray) {
            if (!(bl2 && NamedGroup.refersToASpecificFiniteField(n) || bl3 && NamedGroup.refersToASpecificCurve(n)) && (!bl4 || !NamedGroup.refersToAnECDSACurve(n)) || bl && !FipsUtils.isFipsNamedGroup(n) || !jcaTlsCrypto.hasNamedGroup(n)) continue;
            vector2.add(n);
        }
        return vector2;
    }

    static int getServerDefaultDH(boolean bl, int n) {
        int[] nArray = provJdkTlsNamedGroups;
        if (nArray == null) {
            return bl ? FipsUtils.getFipsDefaultDH(n) : SupportedGroups.getDefaultDH(n);
        }
        for (int n2 : nArray) {
            if (NamedGroup.getFiniteFieldBits(n2) < n || bl && !FipsUtils.isFipsNamedGroup(n2)) continue;
            return n2;
        }
        return -1;
    }

    static int getServerDefaultECDH(boolean bl, int n) {
        int[] nArray = provJdkTlsNamedGroups;
        if (nArray == null) {
            if (bl) {
                return FipsUtils.getFipsDefaultECDH(n);
            }
            return SupportedGroups.getDefaultECDH(n);
        }
        for (int n2 : nArray) {
            if (NamedGroup.getCurveBits(n2) < n || bl && !FipsUtils.isFipsNamedGroup(n2)) continue;
            return n2;
        }
        return -1;
    }

    static int getServerMaximumNegotiableCurveBits(boolean bl, int[] nArray) {
        int[] nArray2 = provJdkTlsNamedGroups;
        if (nArray == null) {
            if (nArray2 == null) {
                return bl ? FipsUtils.getFipsMaximumCurveBits() : (provDisableChar2 ? NamedGroup.getMaximumPrimeCurveBits() : NamedGroup.getMaximumCurveBits());
            }
            int n = 0;
            for (int i = 0; i < nArray2.length; ++i) {
                int n2 = nArray2[i];
                if (bl && !FipsUtils.isFipsNamedGroup(n2)) continue;
                n = Math.max(n, NamedGroup.getCurveBits(n2));
            }
            return n;
        }
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            if (provDisableChar2 && NamedGroup.isChar2Curve(n3) || nArray2 != null && !Arrays.contains((int[])nArray2, (int)n3) || bl && !FipsUtils.isFipsNamedGroup(n3)) continue;
            n = Math.max(n, NamedGroup.getCurveBits(n3));
        }
        return n;
    }

    static int getServerMaximumNegotiableFiniteFieldBits(boolean bl, int[] nArray) {
        int[] nArray2 = provJdkTlsNamedGroups;
        if (nArray == null) {
            if (nArray2 == null) {
                return bl ? FipsUtils.getFipsMaximumFiniteFieldBits() : NamedGroup.getMaximumFiniteFieldBits();
            }
            int n = 0;
            for (int i = 0; i < nArray2.length; ++i) {
                int n2 = nArray2[i];
                if (bl && !FipsUtils.isFipsNamedGroup(n2)) continue;
                n = Math.max(n, NamedGroup.getFiniteFieldBits(n2));
            }
            return n;
        }
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            if (nArray2 != null && !Arrays.contains((int[])nArray2, (int)n3) || bl && !FipsUtils.isFipsNamedGroup(n3)) continue;
            n = Math.max(n, NamedGroup.getFiniteFieldBits(n3));
        }
        return n;
    }

    static int getServerSelectedCurve(JcaTlsCrypto jcaTlsCrypto, boolean bl, int n, int[] nArray) {
        int[] nArray2 = provJdkTlsNamedGroups;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (provDisableChar2 && NamedGroup.isChar2Curve(n2) || nArray2 != null && !Arrays.contains((int[])nArray2, (int)n2) || NamedGroup.getCurveBits(n2) < n || bl && !FipsUtils.isFipsNamedGroup(n2) || !jcaTlsCrypto.hasNamedGroup(n2)) continue;
            return n2;
        }
        return -1;
    }

    static int getServerSelectedFiniteField(JcaTlsCrypto jcaTlsCrypto, boolean bl, int n, int[] nArray) {
        int[] nArray2 = provJdkTlsNamedGroups;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (nArray2 != null && !Arrays.contains((int[])nArray2, (int)n2) || NamedGroup.getFiniteFieldBits(n2) < n || bl && !FipsUtils.isFipsNamedGroup(n2) || !jcaTlsCrypto.hasNamedGroup(n2)) continue;
            return n2;
        }
        return -1;
    }
}

