/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider.test;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.CountDownLatch;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import junit.framework.TestCase;
import org.bouncycastle.jsse.provider.test.ProviderUtils;
import org.bouncycastle.jsse.provider.test.SSLUtils;
import org.bouncycastle.jsse.provider.test.TestProtocolUtil;
import org.bouncycastle.jsse.provider.test.TestUtils;
import org.junit.Assert;

public class BasicClientAuthTlsTest
extends TestCase {
    private static final String HOST = "localhost";
    private static final int PORT_NO_ACCEPTED = 9019;
    private static final int PORT_NO_REJECTED = 9020;

    protected void setUp() {
        ProviderUtils.setupLowPriority(false);
    }

    public void testClientAuthAccepted() throws Exception {
        char[] keyPass = "keyPassword".toCharArray();
        KeyPair caKeyPair = TestUtils.generateECKeyPair();
        X509Certificate caCert = TestUtils.generateRootCert(caKeyPair);
        KeyStore serverKs = KeyStore.getInstance("JKS");
        serverKs.load(null, null);
        serverKs.setKeyEntry("server", caKeyPair.getPrivate(), keyPass, new X509Certificate[]{caCert});
        KeyStore clientKs = KeyStore.getInstance("JKS");
        clientKs.load(null, null);
        clientKs.setKeyEntry("client", caKeyPair.getPrivate(), keyPass, new X509Certificate[]{caCert});
        TestProtocolUtil.runClientAndServer(new ClientAuthServer(9019, true, serverKs, keyPass, caCert), new ClientAuthAcceptedClient(clientKs, keyPass, caCert));
    }

    public void testClientAuthRejected() throws Exception {
        char[] keyPass = "keyPassword".toCharArray();
        KeyPair caKeyPair = TestUtils.generateECKeyPair();
        X509Certificate caCert = TestUtils.generateRootCert(caKeyPair);
        KeyStore serverKs = KeyStore.getInstance("JKS");
        serverKs.load(null, null);
        serverKs.setKeyEntry("server", caKeyPair.getPrivate(), keyPass, new X509Certificate[]{caCert});
        TestProtocolUtil.runClientAndServer(new ClientAuthServer(9020, false, serverKs, keyPass, caCert), new ClientAuthRejectedClient(caCert));
    }

    public static class ClientAuthAcceptedClient
    implements TestProtocolUtil.BlockingCallable {
        private final KeyStore trustStore = KeyStore.getInstance("JKS");
        private final KeyStore clientStore;
        private final char[] clientKeyPass;
        private final CountDownLatch latch;

        public ClientAuthAcceptedClient(KeyStore clientStore, char[] clientKeyPass, X509Certificate trustAnchor) throws GeneralSecurityException, IOException {
            this.trustStore.load(null, null);
            this.trustStore.setCertificateEntry("server", trustAnchor);
            this.clientStore = clientStore;
            this.clientKeyPass = clientKeyPass;
            this.latch = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Exception call() throws Exception {
            try {
                TrustManagerFactory trustMgrFact = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
                trustMgrFact.init(this.trustStore);
                KeyManagerFactory keyMgrFact = KeyManagerFactory.getInstance("PKIX", "BCJSSE");
                keyMgrFact.init(this.clientStore, this.clientKeyPass);
                SSLContext clientContext = SSLContext.getInstance("TLS", "BCJSSE");
                clientContext.init(keyMgrFact.getKeyManagers(), trustMgrFact.getTrustManagers(), SecureRandom.getInstance("DEFAULT", "BC"));
                SSLSocketFactory fact = clientContext.getSocketFactory();
                SSLSocket cSock = (SSLSocket)fact.createSocket(BasicClientAuthTlsTest.HOST, 9019);
                SSLSession session = cSock.getSession();
                TestCase.assertNotNull((Object)session);
                Assert.assertNotEquals((Object)"SSL_NULL_WITH_NULL_NULL", (Object)session.getCipherSuite());
                TestCase.assertEquals((String)"CN=Test CA Certificate", (String)session.getLocalPrincipal().getName());
                TestCase.assertEquals((String)"CN=Test CA Certificate", (String)session.getPeerPrincipal().getName());
                TestProtocolUtil.doClientProtocol(cSock, "Hello");
            }
            finally {
                this.latch.countDown();
            }
            return null;
        }

        public void await() throws InterruptedException {
            this.latch.await();
        }
    }

    public static class ClientAuthRejectedClient
    implements TestProtocolUtil.BlockingCallable {
        private final KeyStore trustStore = KeyStore.getInstance("JKS");
        private final CountDownLatch latch;

        public ClientAuthRejectedClient(X509Certificate trustAnchor) throws GeneralSecurityException, IOException {
            this.trustStore.load(null, null);
            this.trustStore.setCertificateEntry("server", trustAnchor);
            this.latch = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Exception call() throws Exception {
            try {
                TrustManagerFactory trustMgrFact = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
                trustMgrFact.init(this.trustStore);
                SSLContext clientContext = SSLContext.getInstance("TLS", "BCJSSE");
                clientContext.init(null, trustMgrFact.getTrustManagers(), SecureRandom.getInstance("DEFAULT", "BC"));
                SSLSocketFactory fact = clientContext.getSocketFactory();
                SSLSocket cSock = (SSLSocket)fact.createSocket(BasicClientAuthTlsTest.HOST, 9020);
                SSLSession session = cSock.getSession();
                TestCase.assertNotNull((Object)session);
                Assert.assertNotEquals((Object)"SSL_NULL_WITH_NULL_NULL", (Object)session.getCipherSuite());
                TestCase.assertNull((Object)session.getLocalPrincipal());
                TestCase.assertEquals((String)"CN=Test CA Certificate", (String)session.getPeerPrincipal().getName());
                TestProtocolUtil.doClientProtocol(cSock, "Hello");
            }
            finally {
                this.latch.countDown();
            }
            return null;
        }

        public void await() throws InterruptedException {
            this.latch.await();
        }
    }

    public static class ClientAuthServer
    implements TestProtocolUtil.BlockingCallable {
        private final int port;
        private final boolean needClientAuth;
        private final KeyStore serverStore;
        private final char[] keyPass;
        private final KeyStore trustStore;
        private final CountDownLatch latch;

        ClientAuthServer(int port, boolean needClientAuth, KeyStore serverStore, char[] keyPass, X509Certificate trustAnchor) throws GeneralSecurityException, IOException {
            this.port = port;
            this.needClientAuth = needClientAuth;
            this.serverStore = serverStore;
            this.keyPass = keyPass;
            this.trustStore = KeyStore.getInstance("JKS");
            this.trustStore.load(null, null);
            this.trustStore.setCertificateEntry("client", trustAnchor);
            this.latch = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Exception call() throws Exception {
            try {
                KeyManagerFactory keyMgrFact = KeyManagerFactory.getInstance("PKIX", "BCJSSE");
                keyMgrFact.init(this.serverStore, this.keyPass);
                TrustManagerFactory trustMgrFact = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
                trustMgrFact.init(this.trustStore);
                SSLContext serverContext = SSLContext.getInstance("TLS", "BCJSSE");
                serverContext.init(keyMgrFact.getKeyManagers(), trustMgrFact.getTrustManagers(), SecureRandom.getInstance("DEFAULT", "BC"));
                SSLServerSocketFactory fact = serverContext.getServerSocketFactory();
                SSLServerSocket sSock = (SSLServerSocket)fact.createServerSocket(this.port);
                SSLUtils.enableAll(sSock);
                if (this.needClientAuth) {
                    sSock.setNeedClientAuth(true);
                } else {
                    sSock.setWantClientAuth(true);
                }
                this.latch.countDown();
                SSLSocket sslSock = (SSLSocket)sSock.accept();
                SSLSession session = sslSock.getSession();
                TestCase.assertNotNull((Object)session);
                Assert.assertNotEquals((Object)"SSL_NULL_WITH_NULL_NULL", (Object)session.getCipherSuite());
                TestCase.assertEquals((String)"CN=Test CA Certificate", (String)session.getLocalPrincipal().getName());
                if (this.needClientAuth) {
                    TestCase.assertEquals((String)"CN=Test CA Certificate", (String)session.getPeerPrincipal().getName());
                } else {
                    try {
                        session.getPeerPrincipal();
                        Assert.fail();
                    }
                    catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                        // empty catch block
                    }
                }
                TestProtocolUtil.doServerProtocol(sslSock, "World");
                sslSock.close();
                sSock.close();
            }
            finally {
                this.latch.countDown();
            }
            return null;
        }

        public void await() throws InterruptedException {
            this.latch.await();
        }
    }
}

