/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider.test;

import java.security.KeyPair;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.bouncycastle.jsse.provider.test.CipherSuitesFilter;
import org.bouncycastle.jsse.provider.test.CipherSuitesTestCase;
import org.bouncycastle.jsse.provider.test.CipherSuitesTestConfig;
import org.bouncycastle.jsse.provider.test.ProviderUtils;
import org.bouncycastle.jsse.provider.test.TestUtils;
import org.junit.Assert;

public class CipherSuitesTestSuite
extends TestSuite {
    public CipherSuitesTestSuite() {
        super("CipherSuites");
    }

    public static Test suite() throws Exception {
        return CipherSuitesTestSuite.createSuite(new CipherSuitesTestSuite(), null, false, new CipherSuitesFilter(){

            public boolean isIgnored(String cipherSuite) {
                return cipherSuite.contains("_WITH_NULL_") || cipherSuite.contains("_WITH_3DES_EDE_CBC_");
            }

            public boolean isPermitted(String cipherSuite) {
                return true;
            }
        });
    }

    static Test createSuite(TestSuite testSuite, String category, boolean fips, CipherSuitesFilter filter) throws Exception {
        ProviderUtils.setupHighPriority(fips);
        char[] serverPassword = "serverPassword".toCharArray();
        KeyPair caKeyPairDSA = TestUtils.generateDSAKeyPair();
        KeyPair caKeyPairEC = TestUtils.generateECKeyPair();
        KeyPair caKeyPairRSA = TestUtils.generateRSAKeyPair();
        X509Certificate caCertDSA = TestUtils.generateRootCert(caKeyPairDSA);
        X509Certificate caCertEC = TestUtils.generateRootCert(caKeyPairEC);
        X509Certificate caCertRSA = TestUtils.generateRootCert(caKeyPairRSA);
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        ks.setKeyEntry("serverDSA", caKeyPairDSA.getPrivate(), serverPassword, new X509Certificate[]{caCertDSA});
        ks.setKeyEntry("serverEC", caKeyPairEC.getPrivate(), serverPassword, new X509Certificate[]{caCertEC});
        ks.setKeyEntry("serverRSA", caKeyPairRSA.getPrivate(), serverPassword, new X509Certificate[]{caCertRSA});
        KeyStore ts = KeyStore.getInstance("JKS");
        ts.load(null, null);
        ts.setCertificateEntry("caDSA", caCertDSA);
        ts.setCertificateEntry("caEC", caCertEC);
        ts.setCertificateEntry("caRSA", caCertRSA);
        SSLContext defaultSSLContext = SSLContext.getInstance("Default", "BCJSSE");
        Object[] cipherSuites = defaultSSLContext.getSocketFactory().getSupportedCipherSuites();
        for (int i = 0; i < cipherSuites.length; ++i) {
            if (filter.isPermitted((String)cipherSuites[i])) continue;
            Assert.fail((String)("Cipher suite not permitted in supported cipher suites: " + (String)cipherSuites[i]));
        }
        Arrays.sort(cipherSuites);
        String[] protocols = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
        for (int p = 0; p < protocols.length; ++p) {
            String protocol = protocols[p];
            boolean isTLSv13Protocol = "TLSv1.3".equals(protocol);
            boolean isTLSv12Protocol = "TLSv1.2".equals(protocol);
            for (int t = 0; t < cipherSuites.length; ++t) {
                boolean isTLSv12CipherSuite;
                boolean isTLSv13CipherSuite;
                Object cipherSuite = cipherSuites[t];
                if (filter.isIgnored((String)cipherSuite)) continue;
                boolean bl = isTLSv13CipherSuite = !((String)cipherSuite).contains("_WITH_");
                if (isTLSv13CipherSuite != isTLSv13Protocol) continue;
                boolean bl2 = isTLSv12CipherSuite = !isTLSv13CipherSuite && (((String)cipherSuite).contains("_CHACHA20_POLY1305_") || ((String)cipherSuite).contains("_GCM_") || ((String)cipherSuite).endsWith("_CBC_SHA256") || ((String)cipherSuite).endsWith("_CBC_SHA384") || ((String)cipherSuite).endsWith("_CCM") || ((String)cipherSuite).endsWith("_CCM_8"));
                if (isTLSv12CipherSuite && !isTLSv12Protocol) continue;
                CipherSuitesTestConfig config = new CipherSuitesTestConfig();
                config.category = category;
                config.cipherSuite = cipherSuite;
                config.clientTrustStore = ts;
                config.fips = fips;
                config.protocol = protocol;
                config.serverKeyStore = ks;
                config.serverPassword = serverPassword;
                testSuite.addTest((Test)new CipherSuitesTestCase(config));
            }
        }
        return testSuite;
    }
}

