/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider.test;

import java.security.KeyPair;
import java.security.KeyStore;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyStoreBuilderParameters;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.x500.X500Principal;
import junit.framework.TestCase;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.jsse.BCX509ExtendedKeyManager;
import org.bouncycastle.jsse.BCX509Key;
import org.bouncycastle.jsse.provider.test.ProviderUtils;
import org.bouncycastle.jsse.provider.test.SSLUtils;
import org.bouncycastle.jsse.provider.test.TestUtils;

public class KeyManagerFactoryTest
extends TestCase {
    private static final char[] PASSWORD = "fred".toCharArray();

    protected void setUp() {
        ProviderUtils.setupLowPriority(false);
    }

    public void testBasicEC() throws Exception {
        KeyStore keyStore = this.getEcKeyStore(false);
        String keyType = "ECDHE_ECDSA";
        this.implTestKeyManagerFactory(keyStore, keyType);
    }

    public void testBasicRSA() throws Exception {
        KeyStore keyStore = this.getRsaKeyStore(true);
        String keyType = "KE:RSA";
        this.implTestKeyManagerFactory(keyStore, keyType);
    }

    public void testRSAServer() throws Exception {
        KeyStore ks = this.getRsaKeyStore(true);
        KeyStore trustStore = KeyStore.getInstance("JKS");
        trustStore.load(null, PASSWORD);
        trustStore.setCertificateEntry("server", ks.getCertificate("root"));
        SSLUtils.startServer(ks, PASSWORD, trustStore, false, 8886);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
        trustManagerFactory.init(trustStore);
        SSLContext context = SSLContext.getInstance("TLS", "BCJSSE");
        context.init(null, trustManagerFactory.getTrustManagers(), null);
        SSLSocketFactory f = context.getSocketFactory();
        SSLSocket c = (SSLSocket)f.createSocket("localhost", 8886);
        c.setUseClientMode(true);
        SSLUtils.restrictKeyExchange(c, "RSA");
        c.getOutputStream().write(33);
        c.getInputStream().read();
    }

    public void testRSAServerTrustEE() throws Exception {
        KeyStore ks = this.getRsaKeyStore(true);
        KeyStore trustStore = KeyStore.getInstance("JKS");
        trustStore.load(null, PASSWORD);
        trustStore.setCertificateEntry("server", ks.getCertificate("root"));
        SSLUtils.startServer(ks, PASSWORD, trustStore, false, 8886);
        trustStore = KeyStore.getInstance("JKS");
        trustStore.load(null, PASSWORD);
        trustStore.setCertificateEntry("server", ks.getCertificate("test"));
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
        trustManagerFactory.init(trustStore);
        SSLContext context = SSLContext.getInstance("TLS", "BCJSSE");
        context.init(null, trustManagerFactory.getTrustManagers(), null);
        SSLSocketFactory f = context.getSocketFactory();
        SSLSocket c = (SSLSocket)f.createSocket("localhost", 8886);
        c.setUseClientMode(true);
        SSLUtils.restrictKeyExchange(c, "RSA");
        c.getOutputStream().write(33);
        c.getInputStream().read();
    }

    public void testRSAServerWithClientAuth() throws Exception {
        KeyStore clientKS = this.getRsaKeyStore(false);
        KeyStore serverKS = this.getRsaKeyStore(true);
        KeyStore serverTS = KeyStore.getInstance("JKS");
        serverTS.load(null, PASSWORD);
        serverTS.setCertificateEntry("clientRoot", clientKS.getCertificate("root"));
        SSLUtils.startServer(serverKS, PASSWORD, serverTS, true, 8887);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("PKIX", "BCJSSE");
        keyManagerFactory.init(clientKS, PASSWORD);
        KeyStore clientTS = KeyStore.getInstance("JKS");
        clientTS.load(null, PASSWORD);
        clientTS.setCertificateEntry("serverRoot", serverKS.getCertificate("root"));
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
        trustManagerFactory.init(clientTS);
        SSLContext context = SSLContext.getInstance("TLS", "BCJSSE");
        context.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        SSLSocketFactory f = context.getSocketFactory();
        SSLSocket c = (SSLSocket)f.createSocket("localhost", 8887);
        c.setUseClientMode(true);
        SSLUtils.restrictKeyExchange(c, "RSA");
        c.getOutputStream().write(33);
        c.getInputStream().read();
    }

    private KeyStore getEcKeyStore(boolean agreement) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        KeyPair rPair = TestUtils.generateECKeyPair();
        KeyPair iPair = TestUtils.generateECKeyPair();
        KeyPair ePair = TestUtils.generateECKeyPair();
        X509Certificate rCert = TestUtils.generateRootCert(rPair);
        X509Certificate iCert = TestUtils.generateIntermediateCert(iPair.getPublic(), new X500Name("CN=TLS Test CA"), rPair.getPrivate(), rCert);
        X509Certificate eCert = agreement ? TestUtils.generateEndEntityCertAgree(ePair.getPublic(), new X500Name("CN=TLS Test"), iPair.getPrivate(), iCert) : TestUtils.generateEndEntityCertSign(ePair.getPublic(), new X500Name("CN=TLS Test"), iPair.getPrivate(), iCert);
        ks.load(null, PASSWORD);
        ks.setKeyEntry("test", ePair.getPrivate(), PASSWORD, new Certificate[]{eCert, iCert});
        ks.setCertificateEntry("root", rCert);
        return ks;
    }

    private KeyStore getRsaKeyStore(boolean encryption) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        KeyPair rPair = TestUtils.generateRSAKeyPair();
        KeyPair iPair = TestUtils.generateRSAKeyPair();
        KeyPair ePair = TestUtils.generateRSAKeyPair();
        X509Certificate rCert = TestUtils.generateRootCert(rPair);
        X509Certificate iCert = TestUtils.generateIntermediateCert(iPair.getPublic(), new X500Name("CN=TLS Test CA"), rPair.getPrivate(), rCert);
        X509Certificate eCert = encryption ? TestUtils.generateEndEntityCertEnc(ePair.getPublic(), new X500Name("CN=TLS Test"), iPair.getPrivate(), iCert) : TestUtils.generateEndEntityCertSign(ePair.getPublic(), new X500Name("CN=TLS Test"), iPair.getPrivate(), iCert);
        ks.load(null, PASSWORD);
        ks.setKeyEntry("test", ePair.getPrivate(), PASSWORD, new Certificate[]{eCert, iCert});
        ks.setCertificateEntry("root", rCert);
        return ks;
    }

    private void implTestKeyManager(BCX509ExtendedKeyManager manager, String keyType) throws Exception {
        String alias = manager.chooseServerAlias(keyType, null, null);
        KeyManagerFactoryTest.assertNotNull((Object)alias);
        KeyManagerFactoryTest.assertNotNull((Object)manager.getCertificateChain(alias));
        KeyManagerFactoryTest.assertNotNull((Object)manager.getPrivateKey(alias));
        KeyManagerFactoryTest.assertNotNull((Object)manager.getKeyBC(alias));
        BCX509Key key = manager.chooseServerKeyBC(keyType, null, null);
        KeyManagerFactoryTest.assertNotNull((Object)key);
        alias = manager.chooseServerAlias(keyType, new Principal[]{new X500Principal("CN=TLS Test")}, null);
        KeyManagerFactoryTest.assertNull((Object)alias);
        key = manager.chooseServerKeyBC(keyType, new Principal[]{new X500Principal("CN=TLS Test")}, null);
        KeyManagerFactoryTest.assertNull((Object)key);
        alias = manager.chooseServerAlias(keyType, new Principal[]{new X500Principal("CN=TLS Test CA")}, null);
        KeyManagerFactoryTest.assertNotNull((Object)alias);
        KeyManagerFactoryTest.assertNotNull((Object)manager.getCertificateChain(alias));
        KeyManagerFactoryTest.assertNotNull((Object)manager.getPrivateKey(alias));
        KeyManagerFactoryTest.assertNotNull((Object)manager.getKeyBC(alias));
        key = manager.chooseServerKeyBC(keyType, new Principal[]{new X500Principal("CN=TLS Test CA")}, null);
        KeyManagerFactoryTest.assertNotNull((Object)key);
    }

    private void implTestKeyManagerFactory(KeyManagerFactory kmf, String keyType) throws Exception {
        KeyManager[] keyManagers = kmf.getKeyManagers();
        BCX509ExtendedKeyManager keyManager = (BCX509ExtendedKeyManager)keyManagers[0];
        this.implTestKeyManager(keyManager, keyType);
    }

    private void implTestKeyManagerFactory(KeyStore ks, String keyType) throws Exception {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("PKIX", "BCJSSE");
        kmf.init(ks, PASSWORD);
        this.implTestKeyManagerFactory(kmf, keyType);
        KeyStore.Builder builder = KeyStore.Builder.newInstance(ks, (KeyStore.ProtectionParameter)new KeyStore.PasswordProtection(PASSWORD));
        kmf.init(new KeyStoreBuilderParameters(builder));
        this.implTestKeyManagerFactory(kmf, keyType);
    }
}

