/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider.test;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.CountDownLatch;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import junit.framework.TestCase;
import org.bouncycastle.jsse.provider.test.ProviderUtils;
import org.bouncycastle.jsse.provider.test.SSLUtils;
import org.bouncycastle.jsse.provider.test.TestProtocolUtil;
import org.bouncycastle.jsse.provider.test.TestUtils;

public class PSSCredentialsTest
extends TestCase {
    private static final String HOST = "localhost";
    private static final int PORT_NO_PSS = 9019;

    protected void setUp() {
        ProviderUtils.setupLowPriority(false);
    }

    public void testPSSCredentials() throws Exception {
        char[] keyPass = "keyPassword".toCharArray();
        KeyPair caKeyPair = TestUtils.generatePSSKeyPair();
        X509Certificate caCert = TestUtils.generateRootCert(caKeyPair);
        KeyStore serverKs = PSSCredentialsTest.createKeyStore();
        serverKs.setKeyEntry("server", caKeyPair.getPrivate(), keyPass, new X509Certificate[]{caCert});
        KeyStore clientKs = PSSCredentialsTest.createKeyStore();
        clientKs.setKeyEntry("client", caKeyPair.getPrivate(), keyPass, new X509Certificate[]{caCert});
        TestProtocolUtil.runClientAndServer(new PSSServer(9019, serverKs, keyPass, caCert), new PSSClient(9019, clientKs, keyPass, caCert));
    }

    private static KeyStore createKeyStore() throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        keyStore.load(null, null);
        return keyStore;
    }

    public static class PSSClient
    implements TestProtocolUtil.BlockingCallable {
        private final int port;
        private final KeyStore trustStore;
        private final KeyStore clientStore;
        private final char[] clientKeyPass;
        private final CountDownLatch latch;

        public PSSClient(int port, KeyStore clientStore, char[] clientKeyPass, X509Certificate trustAnchor) throws GeneralSecurityException, IOException {
            this.port = port;
            this.trustStore = PSSCredentialsTest.createKeyStore();
            this.trustStore.setCertificateEntry("server", trustAnchor);
            this.clientStore = clientStore;
            this.clientKeyPass = clientKeyPass;
            this.latch = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Exception call() throws Exception {
            try {
                TrustManagerFactory trustMgrFact = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
                trustMgrFact.init(this.trustStore);
                KeyManagerFactory keyMgrFact = KeyManagerFactory.getInstance("PKIX", "BCJSSE");
                keyMgrFact.init(this.clientStore, this.clientKeyPass);
                SSLContext clientContext = SSLContext.getInstance("TLS", "BCJSSE");
                clientContext.init(keyMgrFact.getKeyManagers(), trustMgrFact.getTrustManagers(), SecureRandom.getInstance("DEFAULT", "BC"));
                SSLSocketFactory fact = clientContext.getSocketFactory();
                SSLSocket cSock = (SSLSocket)fact.createSocket(PSSCredentialsTest.HOST, this.port);
                SSLSession session = cSock.getSession();
                TestCase.assertNotNull((Object)session);
                TestCase.assertFalse((boolean)"SSL_NULL_WITH_NULL_NULL".equals(session.getCipherSuite()));
                TestCase.assertEquals((String)"CN=Test CA Certificate", (String)session.getLocalPrincipal().getName());
                TestCase.assertEquals((String)"CN=Test CA Certificate", (String)session.getPeerPrincipal().getName());
                TestProtocolUtil.doClientProtocol(cSock, "Hello");
            }
            finally {
                this.latch.countDown();
            }
            return null;
        }

        public void await() throws InterruptedException {
            this.latch.await();
        }
    }

    public static class PSSServer
    implements TestProtocolUtil.BlockingCallable {
        private final int port;
        private final KeyStore serverStore;
        private final char[] keyPass;
        private final KeyStore trustStore;
        private final CountDownLatch latch;

        PSSServer(int port, KeyStore serverStore, char[] keyPass, X509Certificate trustAnchor) throws GeneralSecurityException, IOException {
            this.port = port;
            this.serverStore = serverStore;
            this.keyPass = keyPass;
            this.trustStore = PSSCredentialsTest.createKeyStore();
            this.trustStore.setCertificateEntry("client", trustAnchor);
            this.latch = new CountDownLatch(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Exception call() throws Exception {
            try {
                KeyManagerFactory keyMgrFact = KeyManagerFactory.getInstance("PKIX", "BCJSSE");
                keyMgrFact.init(this.serverStore, this.keyPass);
                TrustManagerFactory trustMgrFact = TrustManagerFactory.getInstance("PKIX", "BCJSSE");
                trustMgrFact.init(this.trustStore);
                SSLContext serverContext = SSLContext.getInstance("TLS", "BCJSSE");
                serverContext.init(keyMgrFact.getKeyManagers(), trustMgrFact.getTrustManagers(), SecureRandom.getInstance("DEFAULT", "BC"));
                SSLServerSocketFactory fact = serverContext.getServerSocketFactory();
                SSLServerSocket sSock = (SSLServerSocket)fact.createServerSocket(this.port);
                SSLUtils.enableAll(sSock);
                sSock.setNeedClientAuth(true);
                this.latch.countDown();
                SSLSocket sslSock = (SSLSocket)sSock.accept();
                SSLSession session = sslSock.getSession();
                TestCase.assertNotNull((Object)session);
                TestCase.assertFalse((boolean)"SSL_NULL_WITH_NULL_NULL".equals(session.getCipherSuite()));
                TestCase.assertEquals((String)"CN=Test CA Certificate", (String)session.getLocalPrincipal().getName());
                TestCase.assertEquals((String)"CN=Test CA Certificate", (String)session.getPeerPrincipal().getName());
                TestProtocolUtil.doServerProtocol(sslSock, "World");
                sslSock.close();
                sSock.close();
            }
            finally {
                this.latch.countDown();
            }
            return null;
        }

        public void await() throws InterruptedException {
            this.latch.await();
        }
    }
}

