/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.Callable;
import junit.framework.TestCase;
import org.bouncycastle.util.Strings;

class TestProtocolUtil {
    TestProtocolUtil() {
    }

    public static void runClientAndServer(BlockingCallable server, BlockingCallable client) throws InterruptedException {
        Task serverTask = new Task(server);
        Thread serverThread = new Thread(serverTask);
        serverThread.setDaemon(true);
        serverThread.start();
        server.await();
        Task clientTask = new Task(client);
        Thread clientThread = new Thread(clientTask);
        clientThread.setDaemon(true);
        clientThread.start();
        client.await();
        serverThread.join();
        clientThread.join();
        TestCase.assertNull((Object)serverTask.getResult());
        TestCase.assertNull((Object)clientTask.getResult());
    }

    public static void doClientProtocol(Socket sock, String text) throws IOException {
        OutputStream out = sock.getOutputStream();
        InputStream in = sock.getInputStream();
        TestProtocolUtil.writeMessage(text, out);
        String message = TestProtocolUtil.readMessage(in);
        TestCase.assertEquals((String)"World", (String)message);
    }

    public static void doServerProtocol(Socket sock, String text) throws IOException {
        OutputStream out = sock.getOutputStream();
        InputStream in = sock.getInputStream();
        String message = TestProtocolUtil.readMessage(in);
        TestProtocolUtil.writeMessage(text, out);
        TestCase.assertEquals((String)"Hello", (String)message);
    }

    private static void writeMessage(String text, OutputStream out) throws IOException {
        out.write(Strings.toByteArray((String)text));
        out.write(33);
    }

    private static String readMessage(InputStream in) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = in.read()) != 33) {
            sb.append((char)ch);
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface BlockingCallable
    extends Callable<Exception> {
        public void await() throws InterruptedException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Task
    implements Runnable {
        private final Callable<Exception> callable;
        private Throwable result = null;

        public Task(Callable<Exception> callable) {
            this.callable = callable;
        }

        public Throwable getResult() {
            return this.result;
        }

        @Override
        public void run() {
            try {
                this.result = this.callable.call();
            }
            catch (Throwable t) {
                this.result = t;
            }
        }
    }
}

