/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLSocket;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.RSASSAPSSparams;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificate;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jsse.BCSSLConnection;
import org.bouncycastle.jsse.BCSSLSocket;
import org.bouncycastle.jsse.provider.test.TestOIDs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TestUtils {
    private static AtomicLong serialNumber = new AtomicLong(System.currentTimeMillis());
    private static Map<String, AlgorithmIdentifier> algIDs = TestUtils.createAlgIds();

    TestUtils() {
    }

    private static Map<String, AlgorithmIdentifier> createAlgIds() {
        HashMap<String, AlgorithmIdentifier> algIDs = new HashMap<String, AlgorithmIdentifier>();
        algIDs.put("SHA1withDSA", new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa_with_sha1));
        algIDs.put("SHA224withDSA", new AlgorithmIdentifier(NISTObjectIdentifiers.dsa_with_sha224));
        algIDs.put("SHA256withDSA", new AlgorithmIdentifier(NISTObjectIdentifiers.dsa_with_sha256));
        algIDs.put("SHA1withRSA", new AlgorithmIdentifier(PKCSObjectIdentifiers.sha1WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE));
        algIDs.put("SHA224withRSA", new AlgorithmIdentifier(PKCSObjectIdentifiers.sha224WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE));
        algIDs.put("SHA256withRSA", new AlgorithmIdentifier(PKCSObjectIdentifiers.sha256WithRSAEncryption, (ASN1Encodable)DERNull.INSTANCE));
        algIDs.put("SHA256withRSAandMGF1", new AlgorithmIdentifier(PKCSObjectIdentifiers.id_RSASSA_PSS, (ASN1Encodable)new RSASSAPSSparams(new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256), new AlgorithmIdentifier(PKCSObjectIdentifiers.id_mgf1, (ASN1Encodable)new AlgorithmIdentifier(NISTObjectIdentifiers.id_sha256)), new ASN1Integer(32L), new ASN1Integer(1L))));
        algIDs.put("SHA1withECDSA", new AlgorithmIdentifier(X9ObjectIdentifiers.ecdsa_with_SHA1));
        algIDs.put("SHA224withECDSA", new AlgorithmIdentifier(X9ObjectIdentifiers.ecdsa_with_SHA224));
        algIDs.put("SHA256withECDSA", new AlgorithmIdentifier(X9ObjectIdentifiers.ecdsa_with_SHA256));
        algIDs.put("Ed25519", new AlgorithmIdentifier(TestOIDs.id_Ed25519));
        algIDs.put("Ed448", new AlgorithmIdentifier(TestOIDs.id_Ed448));
        return Collections.unmodifiableMap(algIDs);
    }

    private static AlgorithmIdentifier getAlgID(String sigAlgName) {
        AlgorithmIdentifier algID = algIDs.get(sigAlgName);
        if (null == algID) {
            throw new IllegalArgumentException();
        }
        return algID;
    }

    public static X509Certificate createSelfSignedCert(String dn, String sigName, KeyPair keyPair) throws Exception {
        return TestUtils.createSelfSignedCert(new X500Name(dn), sigName, keyPair);
    }

    public static X509Certificate createSelfSignedCert(X500Name dn, String sigName, KeyPair keyPair) throws Exception {
        AlgorithmIdentifier sigAlgID = TestUtils.getAlgID(sigName);
        V3TBSCertificateGenerator certGen = new V3TBSCertificateGenerator();
        long time = System.currentTimeMillis();
        certGen.setSerialNumber(new ASN1Integer(serialNumber.getAndIncrement()));
        certGen.setIssuer(dn);
        certGen.setSubject(dn);
        certGen.setStartDate(new Time(new Date(time - 5000L)));
        certGen.setEndDate(new Time(new Date(time + 1800000L)));
        certGen.setSignature(sigAlgID);
        certGen.setSubjectPublicKeyInfo(SubjectPublicKeyInfo.getInstance((Object)keyPair.getPublic().getEncoded()));
        certGen.setExtensions(new Extensions(new Extension(Extension.basicConstraints, false, new BasicConstraints(true).getEncoded())));
        TBSCertificate tbsCert = certGen.generateTBSCertificate();
        Signature sig = Signature.getInstance(sigName, "BC");
        sig.initSign(keyPair.getPrivate());
        sig.update(tbsCert.getEncoded("DER"));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)tbsCert);
        v.add((ASN1Encodable)sigAlgID);
        v.add((ASN1Encodable)new DERBitString(sig.sign()));
        return (X509Certificate)CertificateFactory.getInstance("X.509", "BC").generateCertificate(new ByteArrayInputStream(new DERSequence(v).getEncoded("DER")));
    }

    public static X509Certificate createCert(X500Name signerName, PrivateKey signerKey, String dn, String sigName, Extensions extensions, PublicKey pubKey) throws Exception {
        return TestUtils.createCert(signerName, signerKey, new X500Name(dn), sigName, extensions, pubKey);
    }

    public static X509Certificate createCert(X500Name signerName, PrivateKey signerKey, X500Name dn, String sigName, Extensions extensions, PublicKey pubKey) throws Exception {
        V3TBSCertificateGenerator certGen = new V3TBSCertificateGenerator();
        long time = System.currentTimeMillis();
        certGen.setSerialNumber(new ASN1Integer(serialNumber.getAndIncrement()));
        certGen.setIssuer(signerName);
        certGen.setSubject(dn);
        certGen.setStartDate(new Time(new Date(time - 5000L)));
        certGen.setEndDate(new Time(new Date(time + 1800000L)));
        certGen.setSignature(TestUtils.getAlgID(sigName));
        certGen.setSubjectPublicKeyInfo(SubjectPublicKeyInfo.getInstance((Object)pubKey.getEncoded()));
        certGen.setExtensions(extensions);
        TBSCertificate tbsCert = certGen.generateTBSCertificate();
        Signature sig = Signature.getInstance(sigName, "BC");
        sig.initSign(signerKey);
        sig.update(tbsCert.getEncoded("DER"));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)tbsCert);
        v.add((ASN1Encodable)TestUtils.getAlgID(sigName));
        v.add((ASN1Encodable)new DERBitString(sig.sign()));
        return (X509Certificate)CertificateFactory.getInstance("X.509", "BC").generateCertificate(new ByteArrayInputStream(new DERSequence(v).getEncoded("DER")));
    }

    public static KeyPair generateDSAKeyPair() throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("DSA", "BC");
        kpGen.initialize(1024, new SecureRandom());
        return kpGen.generateKeyPair();
    }

    public static KeyPair generateRSAKeyPair() throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA", "BC");
        kpGen.initialize(1024, new SecureRandom());
        return kpGen.generateKeyPair();
    }

    public static KeyPair generatePSSKeyPair() throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSASSA-PSS", "BC");
        kpGen.initialize(1024, new SecureRandom());
        return kpGen.generateKeyPair();
    }

    public static KeyPair generateECKeyPair() throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("EC", "BC");
        kpGen.initialize(256, new SecureRandom());
        return kpGen.generateKeyPair();
    }

    public static KeyPair generateEd25519KeyPair() throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("Ed25519", "BC");
        kpGen.initialize(255, new SecureRandom());
        return kpGen.generateKeyPair();
    }

    public static KeyPair generateEd448KeyPair() throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("Ed448", "BC");
        kpGen.initialize(448, new SecureRandom());
        return kpGen.generateKeyPair();
    }

    public static X509Certificate generateRootCert(KeyPair pair) throws Exception {
        String alg = pair.getPublic().getAlgorithm();
        if (alg.equals("DSA")) {
            return TestUtils.createSelfSignedCert("CN=Test CA Certificate", "SHA256withDSA", pair);
        }
        if (alg.equals("RSA")) {
            return TestUtils.createSelfSignedCert("CN=Test CA Certificate", "SHA256withRSA", pair);
        }
        if (alg.equals("RSASSA-PSS")) {
            return TestUtils.createSelfSignedCert("CN=Test CA Certificate", "SHA256withRSAandMGF1", pair);
        }
        if (alg.equals("EC")) {
            return TestUtils.createSelfSignedCert("CN=Test CA Certificate", "SHA256withECDSA", pair);
        }
        if (alg.equals("Ed25519")) {
            return TestUtils.createSelfSignedCert("CN=Test CA Certificate", "Ed25519", pair);
        }
        if (alg.equals("Ed448")) {
            return TestUtils.createSelfSignedCert("CN=Test CA Certificate", "Ed448", pair);
        }
        throw new IllegalArgumentException();
    }

    public static X509Certificate generateIntermediateCert(PublicKey intKey, X500Name subject, PrivateKey caKey, X509Certificate caCert) throws Exception {
        Certificate caCertLw = Certificate.getInstance((Object)caCert.getEncoded());
        ExtensionsGenerator extGen = new ExtensionsGenerator();
        extGen.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)new AuthorityKeyIdentifier(TestUtils.getDigest(caCertLw.getSubjectPublicKeyInfo()), new GeneralNames(new GeneralName(caCertLw.getIssuer())), caCertLw.getSerialNumber().getValue()));
        extGen.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)new SubjectKeyIdentifier(TestUtils.getDigest(SubjectPublicKeyInfo.getInstance((Object)intKey.getEncoded()))));
        extGen.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(0));
        extGen.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(134));
        if (intKey.getAlgorithm().equals("RSA")) {
            return TestUtils.createCert(caCertLw.getSubject(), caKey, subject, "SHA256withRSA", extGen.generate(), intKey);
        }
        return TestUtils.createCert(caCertLw.getSubject(), caKey, subject, "SHA256withECDSA", extGen.generate(), intKey);
    }

    public static X509Certificate generateEndEntityCertAgree(PublicKey intKey, PrivateKey caKey, X509Certificate caCert) throws Exception {
        return TestUtils.generateEndEntityCertAgree(intKey, new X500Name("CN=Test End Certificate"), caKey, caCert);
    }

    public static X509Certificate generateEndEntityCertEnc(PublicKey intKey, PrivateKey caKey, X509Certificate caCert) throws Exception {
        return TestUtils.generateEndEntityCertEnc(intKey, new X500Name("CN=Test End Certificate"), caKey, caCert);
    }

    public static X509Certificate generateEndEntityCertSign(PublicKey intKey, PrivateKey caKey, X509Certificate caCert) throws Exception {
        return TestUtils.generateEndEntityCertSign(intKey, new X500Name("CN=Test End Certificate"), caKey, caCert);
    }

    public static X509Certificate generateEndEntityCertAgree(PublicKey entityKey, X500Name subject, PrivateKey caKey, X509Certificate caCert) throws Exception {
        return TestUtils.generateEndEntityCert(entityKey, subject, 8, caKey, caCert);
    }

    public static X509Certificate generateEndEntityCertEnc(PublicKey entityKey, X500Name subject, PrivateKey caKey, X509Certificate caCert) throws Exception {
        return TestUtils.generateEndEntityCert(entityKey, subject, 32, caKey, caCert);
    }

    public static X509Certificate generateEndEntityCertSign(PublicKey entityKey, X500Name subject, PrivateKey caKey, X509Certificate caCert) throws Exception {
        return TestUtils.generateEndEntityCert(entityKey, subject, 128, caKey, caCert);
    }

    public static X509Certificate generateEndEntityCert(PublicKey entityKey, X500Name subject, int keyUsage, PrivateKey caKey, X509Certificate caCert) throws Exception {
        Certificate caCertLw = Certificate.getInstance((Object)caCert.getEncoded());
        ExtensionsGenerator extGen = new ExtensionsGenerator();
        extGen.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)new AuthorityKeyIdentifier(TestUtils.getDigest(caCertLw.getSubjectPublicKeyInfo()), new GeneralNames(new GeneralName(caCertLw.getIssuer())), caCertLw.getSerialNumber().getValue()));
        extGen.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)new SubjectKeyIdentifier(TestUtils.getDigest(entityKey.getEncoded())));
        extGen.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(false));
        extGen.addExtension(Extension.keyUsage, true, (ASN1Encodable)new KeyUsage(keyUsage));
        if (entityKey.getAlgorithm().equals("RSA")) {
            return TestUtils.createCert(caCertLw.getSubject(), caKey, subject, "SHA256withRSA", extGen.generate(), entityKey);
        }
        if (entityKey.getAlgorithm().equals("EC")) {
            return TestUtils.createCert(caCertLw.getSubject(), caKey, subject, "SHA256withECDSA", extGen.generate(), entityKey);
        }
        if (entityKey.getAlgorithm().equals("Ed25519")) {
            return TestUtils.createCert(caCertLw.getSubject(), caKey, subject, "Ed25519", extGen.generate(), entityKey);
        }
        if (entityKey.getAlgorithm().equals("Ed448")) {
            return TestUtils.createCert(caCertLw.getSubject(), caKey, subject, "Ed448", extGen.generate(), entityKey);
        }
        throw new IllegalArgumentException();
    }

    public static byte[] getChannelBinding(SSLSocket s, String channelBinding) {
        BCSSLConnection connection;
        if (s instanceof BCSSLSocket && (connection = ((BCSSLSocket)((Object)s)).getConnection()) != null) {
            return connection.getChannelBinding(channelBinding);
        }
        return null;
    }

    public static X509Certificate createExceptionCertificate(boolean exceptionOnEncode) {
        return new ExceptionCertificate(exceptionOnEncode);
    }

    static KeyManagerFactory getSunX509KeyManagerFactory() throws NoSuchAlgorithmException {
        if (Security.getProvider("IBMJSSE2") != null) {
            return KeyManagerFactory.getInstance("IBMX509");
        }
        return KeyManagerFactory.getInstance("SunX509");
    }

    private static byte[] getDigest(SubjectPublicKeyInfo spki) throws IOException, NoSuchAlgorithmException {
        return TestUtils.getDigest(spki.getPublicKeyData().getBytes());
    }

    private static byte[] getDigest(byte[] bytes) throws IOException, NoSuchAlgorithmException {
        MessageDigest calc = MessageDigest.getInstance("SHA1");
        return calc.digest(bytes);
    }

    static boolean hasClass(String name) {
        try {
            Class<?> clazz = TestUtils.class.getClassLoader().loadClass(name);
            return clazz != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static class AtomicLong {
        private long value;

        public AtomicLong(long value) {
            this.value = value;
        }

        public synchronized long getAndIncrement() {
            return this.value++;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExceptionCertificate
    extends X509Certificate {
        private boolean _exceptionOnEncode;

        public ExceptionCertificate(boolean exceptionOnEncode) {
            this._exceptionOnEncode = exceptionOnEncode;
        }

        @Override
        public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
            throw new CertificateNotYetValidException();
        }

        @Override
        public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
            throw new CertificateExpiredException();
        }

        @Override
        public int getVersion() {
            return 0;
        }

        @Override
        public BigInteger getSerialNumber() {
            return null;
        }

        @Override
        public Principal getIssuerDN() {
            return null;
        }

        @Override
        public Principal getSubjectDN() {
            return null;
        }

        @Override
        public Date getNotBefore() {
            return null;
        }

        @Override
        public Date getNotAfter() {
            return null;
        }

        @Override
        public byte[] getTBSCertificate() throws CertificateEncodingException {
            throw new CertificateEncodingException();
        }

        @Override
        public byte[] getSignature() {
            return new byte[0];
        }

        @Override
        public String getSigAlgName() {
            return null;
        }

        @Override
        public String getSigAlgOID() {
            return null;
        }

        @Override
        public byte[] getSigAlgParams() {
            return new byte[0];
        }

        @Override
        public boolean[] getIssuerUniqueID() {
            return new boolean[0];
        }

        @Override
        public boolean[] getSubjectUniqueID() {
            return new boolean[0];
        }

        @Override
        public boolean[] getKeyUsage() {
            return new boolean[0];
        }

        @Override
        public int getBasicConstraints() {
            return 0;
        }

        @Override
        public byte[] getEncoded() throws CertificateEncodingException {
            if (this._exceptionOnEncode) {
                throw new CertificateEncodingException();
            }
            return new byte[0];
        }

        @Override
        public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            throw new CertificateException();
        }

        @Override
        public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
            throw new CertificateException();
        }

        @Override
        public String toString() {
            return null;
        }

        @Override
        public PublicKey getPublicKey() {
            return null;
        }

        @Override
        public boolean hasUnsupportedCriticalExtension() {
            return false;
        }

        @Override
        public Set<String> getCriticalExtensionOIDs() {
            return null;
        }

        @Override
        public Set<String> getNonCriticalExtensionOIDs() {
            return null;
        }

        @Override
        public byte[] getExtensionValue(String oid) {
            return new byte[0];
        }
    }
}

