/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCipher;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsDecodeResult;
import org.bouncycastle.tls.crypto.TlsEncodeResult;
import org.bouncycastle.tls.crypto.TlsHMAC;
import org.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import org.bouncycastle.tls.crypto.impl.TlsSuiteHMac;
import org.bouncycastle.tls.crypto.impl.TlsSuiteMac;

public class TlsBlockCipher
implements TlsCipher {
    protected final TlsCrypto crypto;
    protected final TlsCryptoParameters cryptoParams;
    protected final byte[] randomData;
    protected final boolean encryptThenMAC;
    protected final boolean useExplicitIV;
    protected final boolean acceptExtraPadding;
    protected final boolean useExtraPadding;
    protected final TlsBlockCipherImpl decryptCipher;
    protected final TlsBlockCipherImpl encryptCipher;
    protected final TlsSuiteMac readMac;
    protected final TlsSuiteMac writeMac;

    public TlsBlockCipher(TlsCrypto tlsCrypto, TlsCryptoParameters tlsCryptoParameters, TlsBlockCipherImpl tlsBlockCipherImpl, TlsBlockCipherImpl tlsBlockCipherImpl2, TlsHMAC tlsHMAC, TlsHMAC tlsHMAC2, int n) throws IOException {
        TlsBlockCipherImpl tlsBlockCipherImpl3;
        TlsBlockCipherImpl tlsBlockCipherImpl4;
        SecurityParameters securityParameters = tlsCryptoParameters.getSecurityParametersHandshake();
        ProtocolVersion protocolVersion = securityParameters.getNegotiatedVersion();
        if (TlsImplUtils.isTLSv13(protocolVersion)) {
            throw new TlsFatalAlert(80);
        }
        this.cryptoParams = tlsCryptoParameters;
        this.crypto = tlsCrypto;
        this.randomData = tlsCryptoParameters.getNonceGenerator().generateNonce(256);
        this.encryptThenMAC = securityParameters.isEncryptThenMAC();
        this.useExplicitIV = TlsImplUtils.isTLSv11(protocolVersion);
        this.acceptExtraPadding = !protocolVersion.isSSL();
        this.useExtraPadding = securityParameters.isExtendedPadding() && ProtocolVersion.TLSv10.isEqualOrEarlierVersionOf(protocolVersion) && (this.encryptThenMAC || !securityParameters.isTruncatedHMac());
        this.encryptCipher = tlsBlockCipherImpl;
        this.decryptCipher = tlsBlockCipherImpl2;
        if (tlsCryptoParameters.isServer()) {
            tlsBlockCipherImpl4 = tlsBlockCipherImpl2;
            tlsBlockCipherImpl3 = tlsBlockCipherImpl;
        } else {
            tlsBlockCipherImpl4 = tlsBlockCipherImpl;
            tlsBlockCipherImpl3 = tlsBlockCipherImpl2;
        }
        int n2 = 2 * n + tlsHMAC.getMacLength() + tlsHMAC2.getMacLength();
        if (!this.useExplicitIV) {
            n2 += tlsBlockCipherImpl4.getBlockSize() + tlsBlockCipherImpl3.getBlockSize();
        }
        byte[] byArray = TlsImplUtils.calculateKeyBlock(tlsCryptoParameters, n2);
        int n3 = 0;
        tlsHMAC.setKey(byArray, n3, tlsHMAC.getMacLength());
        tlsHMAC2.setKey(byArray, n3 += tlsHMAC.getMacLength(), tlsHMAC2.getMacLength());
        tlsBlockCipherImpl4.setKey(byArray, n3 += tlsHMAC2.getMacLength(), n);
        tlsBlockCipherImpl3.setKey(byArray, n3 += n, n);
        n3 += n;
        if (!this.useExplicitIV) {
            tlsBlockCipherImpl4.init(byArray, n3, tlsBlockCipherImpl4.getBlockSize());
            tlsBlockCipherImpl3.init(byArray, n3 += tlsBlockCipherImpl4.getBlockSize(), tlsBlockCipherImpl3.getBlockSize());
            n3 += tlsBlockCipherImpl3.getBlockSize();
        }
        if (n3 != n2) {
            throw new TlsFatalAlert(80);
        }
        if (tlsCryptoParameters.isServer()) {
            this.writeMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC2);
            this.readMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC);
        } else {
            this.writeMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC);
            this.readMac = new TlsSuiteHMac(tlsCryptoParameters, tlsHMAC2);
        }
    }

    public int getCiphertextDecodeLimit(int n) {
        int n2 = this.decryptCipher.getBlockSize();
        int n3 = this.readMac.getSize();
        int n4 = 256;
        return this.getCiphertextLength(n2, n3, n4, n);
    }

    public int getCiphertextEncodeLimit(int n, int n2) {
        int n3 = this.encryptCipher.getBlockSize();
        int n4 = this.writeMac.getSize();
        int n5 = this.useExtraPadding ? 256 : n3;
        return this.getCiphertextLength(n3, n4, n5, n);
    }

    public int getPlaintextLimit(int n) {
        int n2 = this.encryptCipher.getBlockSize();
        int n3 = this.writeMac.getSize();
        int n4 = n;
        if (this.encryptThenMAC) {
            n4 -= n3;
            n4 -= n4 % n2;
        } else {
            n4 -= n4 % n2;
            n4 -= n3;
        }
        --n4;
        if (this.useExplicitIV) {
            n4 -= n2;
        }
        return n4;
    }

    public TlsEncodeResult encodePlaintext(long l, short s, ProtocolVersion protocolVersion, int n, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = this.encryptCipher.getBlockSize();
        int n6 = this.writeMac.getSize();
        int n7 = n3;
        if (!this.encryptThenMAC) {
            n7 += n6;
        }
        int n8 = n5 - n7 % n5;
        if (this.useExtraPadding) {
            n4 = (256 - n8) / n5;
            int n9 = this.chooseExtraPadBlocks(this.crypto.getSecureRandom(), n4);
            n8 += n9 * n5;
        }
        n4 = n3 + n6 + n8;
        if (this.useExplicitIV) {
            n4 += n5;
        }
        byte[] byArray2 = new byte[n + n4];
        int n10 = n;
        if (this.useExplicitIV) {
            byte[] byArray3 = this.cryptoParams.getNonceGenerator().generateNonce(n5);
            this.encryptCipher.init(byArray3, 0, n5);
            System.arraycopy(byArray3, 0, byArray2, n10, n5);
            n10 += n5;
        }
        int n11 = n10;
        System.arraycopy(byArray, n2, byArray2, n10, n3);
        n10 += n3;
        if (!this.encryptThenMAC) {
            byte[] byArray4 = this.writeMac.calculateMac(l, s, byArray, n2, n3);
            System.arraycopy(byArray4, 0, byArray2, n10, byArray4.length);
            n10 += byArray4.length;
        }
        byte by = (byte)(n8 - 1);
        for (int i = 0; i < n8; ++i) {
            byArray2[n10++] = by;
        }
        this.encryptCipher.doFinal(byArray2, n11, n10 - n11, byArray2, n11);
        if (this.encryptThenMAC) {
            byte[] byArray5 = this.writeMac.calculateMac(l, s, byArray2, n, n10 - n);
            System.arraycopy(byArray5, 0, byArray2, n10, byArray5.length);
            n10 += byArray5.length;
        }
        if (n10 != byArray2.length) {
            throw new TlsFatalAlert(80);
        }
        return new TlsEncodeResult(byArray2, 0, byArray2.length, s);
    }

    public TlsDecodeResult decodeCiphertext(long l, short s, ProtocolVersion protocolVersion, byte[] byArray, int n, int n2) throws IOException {
        boolean bl;
        int n3 = this.decryptCipher.getBlockSize();
        int n4 = this.readMac.getSize();
        int n5 = n3;
        n5 = this.encryptThenMAC ? (n5 += n4) : Math.max(n5, n4 + 1);
        if (this.useExplicitIV) {
            n5 += n3;
        }
        if (n2 < n5) {
            throw new TlsFatalAlert(50);
        }
        int n6 = n2;
        if (this.encryptThenMAC) {
            n6 -= n4;
        }
        if (n6 % n3 != 0) {
            throw new TlsFatalAlert(21);
        }
        if (this.encryptThenMAC) {
            byte[] byArray2 = this.readMac.calculateMac(l, s, byArray, n, n2 - n4);
            boolean bl2 = bl = !TlsUtils.constantTimeAreEqual(n4, byArray2, 0, byArray, n + n2 - n4);
            if (bl) {
                throw new TlsFatalAlert(20);
            }
        }
        if (this.useExplicitIV) {
            this.decryptCipher.init(byArray, n, n3);
            n += n3;
            n6 -= n3;
        }
        this.decryptCipher.doFinal(byArray, n, n6, byArray, n);
        int n7 = this.checkPaddingConstantTime(byArray, n, n6, n3, this.encryptThenMAC ? 0 : n4);
        bl = n7 == 0;
        int n8 = n6 - n7;
        if (!this.encryptThenMAC) {
            byte[] byArray3 = this.readMac.calculateMacConstantTime(l, s, byArray, n, n8 -= n4, n6 - n4, this.randomData);
            bl |= !TlsUtils.constantTimeAreEqual(n4, byArray3, 0, byArray, n + n8);
        }
        if (bl) {
            throw new TlsFatalAlert(20);
        }
        return new TlsDecodeResult(byArray, n, n8, s);
    }

    public void rekeyDecoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void rekeyEncoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    public boolean usesOpaqueRecordType() {
        return false;
    }

    protected int checkPaddingConstantTime(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5 = n + n2;
        byte by = byArray[n5 - 1];
        int n6 = by & 0xFF;
        int n7 = n6 + 1;
        int n8 = 0;
        int n9 = 0;
        int n10 = Math.min(this.acceptExtraPadding ? 256 : n3, n2 - n4);
        if (n7 > n10) {
            n7 = 0;
        } else {
            int n11 = n5 - n7;
            do {
                n9 = (byte)(n9 | byArray[n11++] ^ by);
            } while (n11 < n5);
            n8 = n7;
            if (n9 != 0) {
                n7 = 0;
            }
        }
        byte[] byArray2 = this.randomData;
        while (n8 < 256) {
            n9 = (byte)(n9 | byArray2[n8++] ^ by);
        }
        byArray2[0] = (byte)(byArray2[0] ^ n9);
        return n7;
    }

    protected int chooseExtraPadBlocks(SecureRandom secureRandom, int n) {
        int n2 = secureRandom.nextInt();
        int n3 = this.lowestBitSet(n2);
        return Math.min(n3, n);
    }

    protected int getCiphertextLength(int n, int n2, int n3, int n4) {
        int n5 = n4;
        if (this.useExplicitIV) {
            n5 += n;
        }
        n5 += n3;
        if (this.encryptThenMAC) {
            n5 -= n5 % n;
            n5 += n2;
        } else {
            n5 += n2;
            n5 -= n5 % n;
        }
        return n5;
    }

    protected int lowestBitSet(int n) {
        if (n == 0) {
            return 32;
        }
        int n2 = 0;
        while ((n & 1) == 0) {
            ++n2;
            n >>= 1;
        }
        return n2;
    }
}

