/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.test;

import java.security.SecureRandom;
import junit.framework.TestCase;
import org.bouncycastle.tls.DTLSClientProtocol;
import org.bouncycastle.tls.DTLSServerProtocol;
import org.bouncycastle.tls.DTLSTransport;
import org.bouncycastle.tls.DatagramTransport;
import org.bouncycastle.tls.test.LoggingDatagramTransport;
import org.bouncycastle.tls.test.MockDTLSClient;
import org.bouncycastle.tls.test.MockDTLSServer;
import org.bouncycastle.tls.test.MockDatagramAssociation;
import org.bouncycastle.tls.test.UnreliableDatagramTransport;
import org.bouncycastle.util.Arrays;

public class DTLSProtocolTest
extends TestCase {
    public void testClientServer() throws Exception {
        SecureRandom secureRandom = new SecureRandom();
        DTLSClientProtocol clientProtocol = new DTLSClientProtocol();
        DTLSServerProtocol serverProtocol = new DTLSServerProtocol();
        MockDatagramAssociation network = new MockDatagramAssociation(1500);
        ServerThread serverThread = new ServerThread(serverProtocol, network.getServer());
        serverThread.start();
        DatagramTransport clientTransport = network.getClient();
        clientTransport = new UnreliableDatagramTransport(clientTransport, secureRandom, 0, 0);
        clientTransport = new LoggingDatagramTransport(clientTransport, System.out);
        MockDTLSClient client = new MockDTLSClient(null);
        DTLSTransport dtlsClient = clientProtocol.connect(client, clientTransport);
        for (int i = 1; i <= 10; ++i) {
            byte[] data = new byte[i];
            Arrays.fill((byte[])data, (byte)((byte)i));
            dtlsClient.send(data, 0, data.length);
        }
        byte[] buf = new byte[dtlsClient.getReceiveLimit()];
        while (dtlsClient.receive(buf, 0, buf.length, 100) >= 0) {
        }
        dtlsClient.close();
        serverThread.shutdown();
    }

    static class ServerThread
    extends Thread {
        private final DTLSServerProtocol serverProtocol;
        private final DatagramTransport serverTransport;
        private volatile boolean isShutdown = false;

        ServerThread(DTLSServerProtocol serverProtocol, DatagramTransport serverTransport) {
            this.serverProtocol = serverProtocol;
            this.serverTransport = serverTransport;
        }

        public void run() {
            try {
                MockDTLSServer server = new MockDTLSServer();
                DTLSTransport dtlsServer = this.serverProtocol.accept(server, this.serverTransport);
                byte[] buf = new byte[dtlsServer.getReceiveLimit()];
                while (!this.isShutdown) {
                    int length = dtlsServer.receive(buf, 0, buf.length, 1000);
                    if (length < 0) continue;
                    dtlsServer.send(buf, 0, length);
                }
                dtlsServer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        void shutdown() throws InterruptedException {
            if (!this.isShutdown) {
                this.isShutdown = true;
                this.join();
            }
        }
    }
}

