/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.test;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketTimeoutException;
import java.security.SecureRandom;
import org.bouncycastle.tls.DTLSRequest;
import org.bouncycastle.tls.DTLSServerProtocol;
import org.bouncycastle.tls.DTLSTransport;
import org.bouncycastle.tls.DTLSVerifier;
import org.bouncycastle.tls.DatagramSender;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.UDPTransport;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.test.MockDTLSServer;

public class DTLSServerTest {
    public static void main(String[] args) throws Exception {
        int port = 5556;
        int mtu = 1500;
        DTLSVerifier verifier = new DTLSVerifier(new BcTlsCrypto(new SecureRandom()));
        DTLSRequest request = null;
        byte[] data = new byte[1500];
        final DatagramPacket packet = new DatagramPacket(data, 1500);
        final DatagramSocket socket = new DatagramSocket(port);
        do {
            socket.receive(packet);
        } while (null == (request = verifier.verifyRequest(packet.getAddress().getAddress(), data, 0, packet.getLength(), new DatagramSender(){

            public int getSendLimit() throws IOException {
                return 1472;
            }

            public void send(byte[] buf, int off, int len) throws IOException {
                if (len > this.getSendLimit()) {
                    throw new TlsFatalAlert(80);
                }
                socket.send(new DatagramPacket(buf, off, len, packet.getAddress(), packet.getPort()));
            }
        })));
        System.out.println("Accepting connection from " + packet.getAddress().getHostAddress() + ":" + packet.getPort());
        socket.connect(packet.getAddress(), packet.getPort());
        UDPTransport transport = new UDPTransport(socket, 1500);
        MockDTLSServer server = new MockDTLSServer();
        DTLSServerProtocol serverProtocol = new DTLSServerProtocol();
        DTLSTransport dtlsServer = serverProtocol.accept(server, transport, request);
        byte[] buf = new byte[dtlsServer.getReceiveLimit()];
        while (!socket.isClosed()) {
            try {
                int length = dtlsServer.receive(buf, 0, buf.length, 60000);
                if (length < 0) continue;
                System.out.write(buf, 0, length);
                dtlsServer.send(buf, 0, length);
            }
            catch (SocketTimeoutException socketTimeoutException) {}
        }
        dtlsServer.close();
    }
}

