/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.test;

import java.io.IOException;
import java.io.PrintStream;
import java.security.SecureRandom;
import java.util.Vector;
import org.bouncycastle.tls.AlertDescription;
import org.bouncycastle.tls.AlertLevel;
import org.bouncycastle.tls.PSKTlsServer;
import org.bouncycastle.tls.ProtocolName;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsPSKIdentityManager;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.test.TlsTestUtils;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

class MockPSKTlsServer
extends PSKTlsServer {
    MockPSKTlsServer() {
        super(new BcTlsCrypto(new SecureRandom()), new MyIdentityManager());
    }

    protected Vector getProtocolNames() {
        Vector<ProtocolName> protocolNames = new Vector<ProtocolName>();
        protocolNames.addElement(ProtocolName.HTTP_2_TLS);
        protocolNames.addElement(ProtocolName.HTTP_1_1);
        return protocolNames;
    }

    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("TLS-PSK server raised alert: " + AlertLevel.getText(alertLevel) + ", " + AlertDescription.getText(alertDescription));
        if (message != null) {
            out.println("> " + message);
        }
        if (cause != null) {
            cause.printStackTrace(out);
        }
    }

    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("TLS-PSK server received alert: " + AlertLevel.getText(alertLevel) + ", " + AlertDescription.getText(alertDescription));
    }

    public ProtocolVersion getServerVersion() throws IOException {
        ProtocolVersion serverVersion = super.getServerVersion();
        System.out.println("TLS-PSK server negotiated " + serverVersion);
        return serverVersion;
    }

    public void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        ProtocolName protocolName = this.context.getSecurityParametersConnection().getApplicationProtocol();
        if (protocolName != null) {
            System.out.println("Server ALPN: " + protocolName.getUtf8Decoding());
        }
        byte[] tlsServerEndPoint = this.context.exportChannelBinding(0);
        System.out.println("Server 'tls-server-end-point': " + this.hex(tlsServerEndPoint));
        byte[] tlsUnique = this.context.exportChannelBinding(1);
        System.out.println("Server 'tls-unique': " + this.hex(tlsUnique));
        byte[] pskIdentity = this.context.getSecurityParametersConnection().getPSKIdentity();
        if (pskIdentity != null) {
            String name = Strings.fromUTF8ByteArray((byte[])pskIdentity);
            System.out.println("TLS-PSK server completed handshake for PSK identity: " + name);
        }
    }

    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() throws IOException {
        return TlsTestUtils.loadEncryptionCredentials(this.context, new String[]{"x509-server-rsa-enc.pem", "x509-ca-rsa.pem"}, "x509-server-key-rsa-enc.pem");
    }

    protected String hex(byte[] data) {
        return data == null ? "(null)" : Hex.toHexString((byte[])data);
    }

    protected ProtocolVersion[] getSupportedVersions() {
        return ProtocolVersion.TLSv12.only();
    }

    static class MyIdentityManager
    implements TlsPSKIdentityManager {
        MyIdentityManager() {
        }

        public byte[] getHint() {
            return Strings.toUTF8ByteArray((String)"hint");
        }

        public byte[] getPSK(byte[] identity) {
            String name;
            if (identity != null && (name = Strings.fromUTF8ByteArray((byte[])identity)).equals("client")) {
                return Strings.toUTF8ByteArray((String)"TLS_TEST_PSK");
            }
            return null;
        }
    }
}

