/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.test;

import java.io.IOException;
import java.io.PrintStream;
import java.security.SecureRandom;
import java.util.Vector;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.tls.AlertDescription;
import org.bouncycastle.tls.AlertLevel;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsServer;
import org.bouncycastle.tls.ProtocolName;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.test.TlsTestUtils;
import org.bouncycastle.util.encoders.Hex;

class MockTlsServer
extends DefaultTlsServer {
    MockTlsServer() {
        super(new BcTlsCrypto(new SecureRandom()));
    }

    protected Vector getProtocolNames() {
        Vector<ProtocolName> protocolNames = new Vector<ProtocolName>();
        protocolNames.addElement(ProtocolName.HTTP_2_TLS);
        protocolNames.addElement(ProtocolName.HTTP_1_1);
        return protocolNames;
    }

    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("TLS server raised alert: " + AlertLevel.getText(alertLevel) + ", " + AlertDescription.getText(alertDescription));
        if (message != null) {
            out.println("> " + message);
        }
        if (cause != null) {
            cause.printStackTrace(out);
        }
    }

    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("TLS server received alert: " + AlertLevel.getText(alertLevel) + ", " + AlertDescription.getText(alertDescription));
    }

    public ProtocolVersion getServerVersion() throws IOException {
        ProtocolVersion serverVersion = super.getServerVersion();
        System.out.println("TLS server negotiated " + serverVersion);
        return serverVersion;
    }

    public CertificateRequest getCertificateRequest() throws IOException {
        short[] certificateTypes = new short[]{1, 2, 64};
        Vector serverSigAlgs = null;
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.context.getServerVersion())) {
            serverSigAlgs = TlsUtils.getDefaultSupportedSignatureAlgorithms(this.context);
        }
        Vector<X500Name> certificateAuthorities = new Vector<X500Name>();
        certificateAuthorities.addElement(new X500Name("CN=BouncyCastle TLS Test CA"));
        return new CertificateRequest(certificateTypes, serverSigAlgs, certificateAuthorities);
    }

    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        boolean isEmpty;
        TlsCertificate[] chain = clientCertificate.getCertificateList();
        System.out.println("TLS server received client certificate chain of length " + chain.length);
        for (int i = 0; i != chain.length; ++i) {
            org.bouncycastle.asn1.x509.Certificate entry = org.bouncycastle.asn1.x509.Certificate.getInstance((Object)chain[i].getEncoded());
            System.out.println("    fingerprint:SHA-256 " + TlsTestUtils.fingerprint(entry) + " (" + entry.getSubject() + ")");
        }
        boolean bl = isEmpty = clientCertificate == null || clientCertificate.isEmpty();
        if (isEmpty) {
            return;
        }
        String[] trustedCertResources = new String[]{"x509-client-dsa.pem", "x509-client-ecdh.pem", "x509-client-ecdsa.pem", "x509-client-ed25519.pem", "x509-client-ed448.pem", "x509-client-rsa_pss_256.pem", "x509-client-rsa_pss_384.pem", "x509-client-rsa_pss_512.pem", "x509-client-rsa.pem"};
        TlsCertificate[] certPath = TlsTestUtils.getTrustedCertPath(this.context.getCrypto(), chain[0], trustedCertResources);
        if (null == certPath) {
            throw new TlsFatalAlert(42);
        }
        TlsUtils.checkPeerSigAlgs(this.context, certPath);
    }

    public void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        ProtocolName protocolName = this.context.getSecurityParametersConnection().getApplicationProtocol();
        if (protocolName != null) {
            System.out.println("Server ALPN: " + protocolName.getUtf8Decoding());
        }
        byte[] tlsServerEndPoint = this.context.exportChannelBinding(0);
        System.out.println("Server 'tls-server-end-point': " + this.hex(tlsServerEndPoint));
        byte[] tlsUnique = this.context.exportChannelBinding(1);
        System.out.println("Server 'tls-unique': " + this.hex(tlsUnique));
    }

    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() throws IOException {
        return TlsTestUtils.loadEncryptionCredentials(this.context, new String[]{"x509-server-rsa-enc.pem", "x509-ca-rsa.pem"}, "x509-server-key-rsa-enc.pem");
    }

    protected TlsCredentialedSigner getRSASignerCredentials() throws IOException {
        Vector clientSigAlgs = this.context.getSecurityParametersHandshake().getClientSigAlgs();
        return TlsTestUtils.loadSignerCredentialsServer(this.context, clientSigAlgs, (short)1);
    }

    protected String hex(byte[] data) {
        return data == null ? "(null)" : Hex.toHexString((byte[])data);
    }
}

