/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.test;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.SecureRandom;
import junit.framework.TestCase;
import org.bouncycastle.tls.TlsClientProtocol;
import org.bouncycastle.tls.TlsServerProtocol;
import org.bouncycastle.tls.test.MockPSKTlsClient;
import org.bouncycastle.tls.test.MockPSKTlsServer;
import org.bouncycastle.tls.test.TlsTestUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

public class TlsPSKProtocolTest
extends TestCase {
    public void testClientServer() throws Exception {
        SecureRandom secureRandom = new SecureRandom();
        PipedInputStream clientRead = TlsTestUtils.createPipedInputStream();
        PipedInputStream serverRead = TlsTestUtils.createPipedInputStream();
        PipedOutputStream clientWrite = new PipedOutputStream(serverRead);
        PipedOutputStream serverWrite = new PipedOutputStream(clientRead);
        TlsClientProtocol clientProtocol = new TlsClientProtocol(clientRead, clientWrite);
        TlsServerProtocol serverProtocol = new TlsServerProtocol(serverRead, serverWrite);
        ServerThread serverThread = new ServerThread(serverProtocol);
        serverThread.start();
        MockPSKTlsClient client = new MockPSKTlsClient(null);
        clientProtocol.connect(client);
        int length = 1000;
        byte[] data = new byte[length];
        secureRandom.nextBytes(data);
        OutputStream output = clientProtocol.getOutputStream();
        output.write(data);
        byte[] echo = new byte[data.length];
        int count = Streams.readFully((InputStream)clientProtocol.getInputStream(), (byte[])echo);
        TlsPSKProtocolTest.assertEquals((int)count, (int)data.length);
        TlsPSKProtocolTest.assertTrue((boolean)Arrays.areEqual((byte[])data, (byte[])echo));
        output.close();
        serverThread.join();
    }

    static class ServerThread
    extends Thread {
        private final TlsServerProtocol serverProtocol;

        ServerThread(TlsServerProtocol serverProtocol) {
            this.serverProtocol = serverProtocol;
        }

        public void run() {
            try {
                MockPSKTlsServer server = new MockPSKTlsServer();
                this.serverProtocol.accept(server);
                Streams.pipeAll((InputStream)this.serverProtocol.getInputStream(), (OutputStream)this.serverProtocol.getOutputStream());
                this.serverProtocol.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

