/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.test;

import java.io.IOException;
import java.security.SecureRandom;
import junit.framework.TestCase;
import org.bouncycastle.tls.TlsClientProtocol;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsServerProtocol;
import org.bouncycastle.tls.test.MockTlsClient;
import org.bouncycastle.tls.test.MockTlsServer;
import org.bouncycastle.util.Arrays;

public class TlsProtocolNonBlockingTest
extends TestCase {
    public void testClientServerFragmented() throws IOException {
        TlsProtocolNonBlockingTest.testClientServer(true);
    }

    public void testClientServerNonFragmented() throws IOException {
        TlsProtocolNonBlockingTest.testClientServer(false);
    }

    private static void testClientServer(boolean fragment) throws IOException {
        SecureRandom secureRandom = new SecureRandom();
        TlsClientProtocol clientProtocol = new TlsClientProtocol();
        TlsServerProtocol serverProtocol = new TlsServerProtocol();
        clientProtocol.connect(new MockTlsClient(null));
        serverProtocol.accept(new MockTlsServer());
        boolean hadDataFromServer = true;
        boolean hadDataFromClient = true;
        while (hadDataFromServer || hadDataFromClient) {
            hadDataFromServer = TlsProtocolNonBlockingTest.pumpData(serverProtocol, clientProtocol, fragment);
            hadDataFromClient = TlsProtocolNonBlockingTest.pumpData(clientProtocol, serverProtocol, fragment);
        }
        byte[] data = new byte[1024];
        secureRandom.nextBytes(data);
        TlsProtocolNonBlockingTest.writeAndRead(clientProtocol, serverProtocol, data, fragment);
        TlsProtocolNonBlockingTest.writeAndRead(serverProtocol, clientProtocol, data, fragment);
        clientProtocol.close();
        TlsProtocolNonBlockingTest.pumpData(clientProtocol, serverProtocol, fragment);
        serverProtocol.closeInput();
        TlsProtocolNonBlockingTest.checkClosed(serverProtocol);
        TlsProtocolNonBlockingTest.checkClosed(clientProtocol);
    }

    private static void writeAndRead(TlsProtocol writer, TlsProtocol reader, byte[] data, boolean fragment) throws IOException {
        int dataSize = data.length;
        writer.writeApplicationData(data, 0, dataSize);
        TlsProtocolNonBlockingTest.pumpData(writer, reader, fragment);
        TlsProtocolNonBlockingTest.assertEquals((int)dataSize, (int)reader.getAvailableInputBytes());
        byte[] readData = new byte[dataSize];
        reader.readInput(readData, 0, dataSize);
        TlsProtocolNonBlockingTest.assertArrayEquals(data, readData);
    }

    private static boolean pumpData(TlsProtocol from, TlsProtocol to, boolean fragment) throws IOException {
        int byteCount = from.getAvailableOutputBytes();
        if (byteCount == 0) {
            return false;
        }
        if (fragment) {
            byte[] buffer = new byte[1];
            while (from.getAvailableOutputBytes() > 0) {
                from.readOutput(buffer, 0, 1);
                to.offerInput(buffer);
            }
        } else {
            byte[] buffer = new byte[byteCount];
            from.readOutput(buffer, 0, buffer.length);
            to.offerInput(buffer);
        }
        return true;
    }

    private static void checkClosed(TlsProtocol protocol) {
        TlsProtocolNonBlockingTest.assertTrue((boolean)protocol.isClosed());
        try {
            protocol.offerInput(new byte[10]);
            TlsProtocolNonBlockingTest.fail((String)"Input was accepted after close");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            protocol.writeApplicationData(new byte[10], 0, 10);
            TlsProtocolNonBlockingTest.fail((String)"Output was accepted after close");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void assertArrayEquals(byte[] a, byte[] b) {
        TlsProtocolNonBlockingTest.assertTrue((boolean)Arrays.areEqual((byte[])a, (byte[])b));
    }
}

