/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.test;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateEntry;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsClient;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsAuthentication;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsExtensionsUtils;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsServerCertificate;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsStreamSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.test.TlsTestConfig;
import org.bouncycastle.tls.test.TlsTestSuite;
import org.bouncycastle.tls.test.TlsTestUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

class TlsTestClientImpl
extends DefaultTlsClient {
    private static final int[] TEST_CIPHER_SUITES = new int[]{4867, 4865, 52393, 49195, 49187, 49161, 52392, 49199, 49191, 49171, 52394, 158, 103, 51, 156, 60, 47};
    protected final TlsTestConfig config;
    protected int firstFatalAlertConnectionEnd = -1;
    protected short firstFatalAlertDescription = (short)-1;
    byte[] tlsServerEndPoint = null;
    byte[] tlsUnique = null;

    TlsTestClientImpl(TlsTestConfig config) {
        super(new BcTlsCrypto(new SecureRandom()));
        this.config = config;
    }

    int getFirstFatalAlertConnectionEnd() {
        return this.firstFatalAlertConnectionEnd;
    }

    short getFirstFatalAlertDescription() {
        return this.firstFatalAlertDescription;
    }

    public TlsCrypto getCrypto() {
        switch (this.config.clientCrypto) {
            case 1: {
                return TlsTestSuite.JCA_CRYPTO;
            }
        }
        return TlsTestSuite.BC_CRYPTO;
    }

    public Hashtable getClientExtensions() throws IOException {
        Hashtable clientExtensions = super.getClientExtensions();
        if (clientExtensions != null) {
            if (!this.config.clientSendSignatureAlgorithms) {
                clientExtensions.remove(TlsExtensionsUtils.EXT_signature_algorithms);
                this.supportedSignatureAlgorithms = null;
            }
            if (!this.config.clientSendSignatureAlgorithmsCert) {
                clientExtensions.remove(TlsExtensionsUtils.EXT_signature_algorithms_cert);
                this.supportedSignatureAlgorithmsCert = null;
            }
        }
        return clientExtensions;
    }

    public Vector getEarlyKeyShareGroups() {
        if (this.config.clientEmptyKeyShare) {
            return null;
        }
        return super.getEarlyKeyShareGroups();
    }

    public boolean isFallback() {
        return this.config.clientFallback;
    }

    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        if (alertLevel == 2 && this.firstFatalAlertConnectionEnd == -1) {
            this.firstFatalAlertConnectionEnd = 1;
            this.firstFatalAlertDescription = alertDescription;
        }
    }

    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        if (alertLevel == 2 && this.firstFatalAlertConnectionEnd == -1) {
            this.firstFatalAlertConnectionEnd = 0;
            this.firstFatalAlertDescription = alertDescription;
        }
    }

    public void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        this.tlsServerEndPoint = this.context.exportChannelBinding(0);
        this.tlsUnique = this.context.exportChannelBinding(1);
    }

    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        super.notifyServerVersion(serverVersion);
    }

    public TlsAuthentication getAuthentication() throws IOException {
        return new TlsAuthentication(){

            public void notifyServerCertificate(TlsServerCertificate serverCertificate) throws IOException {
                boolean isEmpty;
                TlsCertificate[] chain = serverCertificate.getCertificate().getCertificateList();
                boolean bl = isEmpty = serverCertificate == null || serverCertificate.getCertificate() == null || serverCertificate.getCertificate().isEmpty();
                if (isEmpty) {
                    throw new TlsFatalAlert(42);
                }
                String[] trustedCertResources = new String[]{"x509-server-dsa.pem", "x509-server-ecdh.pem", "x509-server-ecdsa.pem", "x509-server-ed25519.pem", "x509-server-ed448.pem", "x509-server-rsa_pss_256.pem", "x509-server-rsa_pss_384.pem", "x509-server-rsa_pss_512.pem", "x509-server-rsa-enc.pem", "x509-server-rsa-sign.pem"};
                TlsCertificate[] certPath = TlsTestUtils.getTrustedCertPath(TlsTestClientImpl.this.context.getCrypto(), chain[0], trustedCertResources);
                if (null == certPath) {
                    throw new TlsFatalAlert(42);
                }
                if (TlsTestClientImpl.this.config.clientCheckSigAlgOfServerCerts) {
                    TlsUtils.checkPeerSigAlgs(TlsTestClientImpl.this.context, certPath);
                }
            }

            public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
                short[] certificateTypes;
                if (TlsTestClientImpl.this.config.serverCertReq == 0) {
                    throw new IllegalStateException();
                }
                if (TlsTestClientImpl.this.config.clientAuth == 0) {
                    return null;
                }
                boolean isTLSv13 = TlsUtils.isTLSv13(TlsTestClientImpl.this.context);
                if (!(isTLSv13 || (certificateTypes = certificateRequest.getCertificateTypes()) != null && Arrays.contains((short[])certificateTypes, (short)1))) {
                    return null;
                }
                Vector<SignatureAndHashAlgorithm> supportedSigAlgs = certificateRequest.getSupportedSignatureAlgorithms();
                if (supportedSigAlgs != null && TlsTestClientImpl.this.config.clientAuthSigAlg != null) {
                    supportedSigAlgs = new Vector<SignatureAndHashAlgorithm>(1);
                    supportedSigAlgs.addElement(TlsTestClientImpl.this.config.clientAuthSigAlg);
                }
                final TlsCredentialedSigner signerCredentials = TlsTestUtils.loadSignerCredentials(TlsTestClientImpl.this.context, supportedSigAlgs, (short)1, "x509-client-rsa.pem", "x509-client-key-rsa.pem");
                if (TlsTestClientImpl.this.config.clientAuth == 1) {
                    return signerCredentials;
                }
                return new TlsCredentialedSigner(){

                    public byte[] generateRawSignature(byte[] hash) throws IOException {
                        byte[] sig = signerCredentials.generateRawSignature(hash);
                        if (TlsTestClientImpl.this.config.clientAuth == 3) {
                            sig = TlsTestClientImpl.this.corruptBit(sig);
                        }
                        return sig;
                    }

                    public Certificate getCertificate() {
                        Certificate cert = signerCredentials.getCertificate();
                        if (TlsTestClientImpl.this.config.clientAuth == 2) {
                            cert = TlsTestClientImpl.this.corruptCertificate(TlsTestClientImpl.this.context.getCrypto(), cert);
                        }
                        return cert;
                    }

                    public SignatureAndHashAlgorithm getSignatureAndHashAlgorithm() {
                        return signerCredentials.getSignatureAndHashAlgorithm();
                    }

                    public TlsStreamSigner getStreamSigner() throws IOException {
                        return null;
                    }
                };
            }
        };
    }

    protected Certificate corruptCertificate(TlsCrypto crypto, Certificate cert) {
        CertificateEntry[] certEntryList = cert.getCertificateEntryList();
        try {
            CertificateEntry ee = certEntryList[0];
            TlsCertificate corruptCert = this.corruptCertificateSignature(crypto, ee.getCertificate());
            certEntryList[0] = new CertificateEntry(corruptCert, ee.getExtensions());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new Certificate(cert.getCertificateRequestContext(), certEntryList);
    }

    protected TlsCertificate corruptCertificateSignature(TlsCrypto crypto, TlsCertificate tlsCertificate) throws IOException {
        org.bouncycastle.asn1.x509.Certificate cert = org.bouncycastle.asn1.x509.Certificate.getInstance((Object)tlsCertificate.getEncoded());
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)cert.getTBSCertificate());
        v.add((ASN1Encodable)cert.getSignatureAlgorithm());
        v.add((ASN1Encodable)this.corruptSignature(cert.getSignature()));
        return crypto.createCertificate(org.bouncycastle.asn1.x509.Certificate.getInstance((Object)new DERSequence(v)).getEncoded("DER"));
    }

    protected DERBitString corruptSignature(DERBitString bs) {
        return new DERBitString(this.corruptBit(bs.getOctets()));
    }

    protected byte[] corruptBit(byte[] bs) {
        bs = Arrays.clone((byte[])bs);
        int bit = this.context.getCrypto().getSecureRandom().nextInt(bs.length << 3);
        int n = bit >>> 3;
        bs[n] = (byte)(bs[n] ^ 1 << (bit & 7));
        return bs;
    }

    protected int[] getSupportedCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.getCrypto(), TEST_CIPHER_SUITES);
    }

    protected ProtocolVersion[] getSupportedVersions() {
        if (null != this.config.clientSupportedVersions) {
            return this.config.clientSupportedVersions;
        }
        return super.getSupportedVersions();
    }

    protected String hex(byte[] data) {
        return data == null ? "(null)" : Hex.toHexString((byte[])data);
    }
}

