/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.test;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Vector;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateRequest;
import org.bouncycastle.tls.DefaultTlsServer;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.test.TlsTestConfig;
import org.bouncycastle.tls.test.TlsTestSuite;
import org.bouncycastle.tls.test.TlsTestUtils;
import org.bouncycastle.util.encoders.Hex;

class TlsTestServerImpl
extends DefaultTlsServer {
    private static final int[] TEST_CIPHER_SUITES = new int[]{4867, 4866, 4865, 52392, 49200, 49199, 49192, 49191, 49172, 49171, 52394, 159, 158, 107, 103, 57, 51, 157, 156, 61, 60, 53, 47};
    protected final TlsTestConfig config;
    protected int firstFatalAlertConnectionEnd = -1;
    protected short firstFatalAlertDescription = (short)-1;
    byte[] tlsServerEndPoint = null;
    byte[] tlsUnique = null;

    TlsTestServerImpl(TlsTestConfig config) {
        super(new BcTlsCrypto(new SecureRandom()));
        this.config = config;
    }

    int getFirstFatalAlertConnectionEnd() {
        return this.firstFatalAlertConnectionEnd;
    }

    short getFirstFatalAlertDescription() {
        return this.firstFatalAlertDescription;
    }

    public TlsCredentials getCredentials() throws IOException {
        if (TlsUtils.isTLSv13(this.context)) {
            return this.getRSASignerCredentials();
        }
        return super.getCredentials();
    }

    public TlsCrypto getCrypto() {
        switch (this.config.serverCrypto) {
            case 1: {
                return TlsTestSuite.JCA_CRYPTO;
            }
        }
        return TlsTestSuite.BC_CRYPTO;
    }

    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        if (alertLevel == 2 && this.firstFatalAlertConnectionEnd == -1) {
            this.firstFatalAlertConnectionEnd = 0;
            this.firstFatalAlertDescription = alertDescription;
        }
    }

    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        if (alertLevel == 2 && this.firstFatalAlertConnectionEnd == -1) {
            this.firstFatalAlertConnectionEnd = 1;
            this.firstFatalAlertDescription = alertDescription;
        }
    }

    public void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        this.tlsServerEndPoint = this.context.exportChannelBinding(0);
        this.tlsUnique = this.context.exportChannelBinding(1);
    }

    public ProtocolVersion getServerVersion() throws IOException {
        ProtocolVersion serverVersion = null != this.config.serverNegotiateVersion ? this.config.serverNegotiateVersion : super.getServerVersion();
        return serverVersion;
    }

    public CertificateRequest getCertificateRequest() throws IOException {
        if (this.config.serverCertReq == 0) {
            return null;
        }
        Vector serverSigAlgs = null;
        if (TlsUtils.isSignatureAlgorithmsExtensionAllowed(this.context.getServerVersion()) && (serverSigAlgs = this.config.serverCertReqSigAlgs) == null) {
            serverSigAlgs = TlsUtils.getDefaultSupportedSignatureAlgorithms(this.context);
        }
        Vector<X500Name> certificateAuthorities = new Vector<X500Name>();
        certificateAuthorities.addElement(new X500Name("CN=BouncyCastle TLS Test CA"));
        if (TlsUtils.isTLSv13(this.context)) {
            byte[] certificateRequestContext = TlsUtils.EMPTY_BYTES;
            Vector serverSigAlgsCert = null;
            return new CertificateRequest(certificateRequestContext, serverSigAlgs, serverSigAlgsCert, certificateAuthorities);
        }
        short[] certificateTypes = new short[]{1, 2, 64};
        return new CertificateRequest(certificateTypes, serverSigAlgs, certificateAuthorities);
    }

    public void notifyClientCertificate(Certificate clientCertificate) throws IOException {
        boolean isEmpty = clientCertificate == null || clientCertificate.isEmpty();
        if (isEmpty != (this.config.clientAuth == 0)) {
            throw new IllegalStateException();
        }
        if (isEmpty && this.config.serverCertReq == 2) {
            short alertDescription = TlsUtils.isTLSv13(this.context) ? (short)116 : 40;
            throw new TlsFatalAlert(alertDescription);
        }
        TlsCertificate[] chain = clientCertificate.getCertificateList();
        if (isEmpty) {
            return;
        }
        String[] trustedCertResources = new String[]{"x509-client-dsa.pem", "x509-client-ecdh.pem", "x509-client-ecdsa.pem", "x509-client-ed25519.pem", "x509-client-ed448.pem", "x509-client-rsa_pss_256.pem", "x509-client-rsa_pss_384.pem", "x509-client-rsa_pss_512.pem", "x509-client-rsa.pem"};
        TlsCertificate[] certPath = TlsTestUtils.getTrustedCertPath(this.context.getCrypto(), chain[0], trustedCertResources);
        if (null == certPath) {
            throw new TlsFatalAlert(42);
        }
        if (this.config.serverCheckSigAlgOfClientCerts) {
            TlsUtils.checkPeerSigAlgs(this.context, certPath);
        }
    }

    protected Vector getSupportedSignatureAlgorithms() {
        if (TlsUtils.isTLSv12(this.context) && this.config.serverAuthSigAlg != null) {
            Vector<SignatureAndHashAlgorithm> signatureAlgorithms = new Vector<SignatureAndHashAlgorithm>(1);
            signatureAlgorithms.addElement(this.config.serverAuthSigAlg);
            return signatureAlgorithms;
        }
        return this.context.getSecurityParametersHandshake().getClientSigAlgs();
    }

    protected TlsCredentialedSigner getDSASignerCredentials() throws IOException {
        return this.loadSignerCredentials((short)2);
    }

    protected TlsCredentialedSigner getECDSASignerCredentials() throws IOException {
        return this.loadSignerCredentials((short)3);
    }

    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() throws IOException {
        return TlsTestUtils.loadEncryptionCredentials(this.context, new String[]{"x509-server-rsa-enc.pem", "x509-ca-rsa.pem"}, "x509-server-key-rsa-enc.pem");
    }

    protected TlsCredentialedSigner getRSASignerCredentials() throws IOException {
        return this.loadSignerCredentials((short)1);
    }

    protected int[] getSupportedCipherSuites() {
        return TlsUtils.getSupportedCipherSuites(this.getCrypto(), TEST_CIPHER_SUITES);
    }

    protected ProtocolVersion[] getSupportedVersions() {
        if (this.config.serverSupportedVersions != null) {
            return this.config.serverSupportedVersions;
        }
        return super.getSupportedVersions();
    }

    protected String hex(byte[] data) {
        return data == null ? "(null)" : Hex.toHexString((byte[])data);
    }

    private TlsCredentialedSigner loadSignerCredentials(short signatureAlgorithm) throws IOException {
        return TlsTestUtils.loadSignerCredentialsServer(this.context, this.getSupportedSignatureAlgorithms(), signatureAlgorithm);
    }
}

