/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.test;

import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCryptoProvider;
import org.bouncycastle.tls.test.TlsTestCase;
import org.bouncycastle.tls.test.TlsTestConfig;

public class TlsTestSuite
extends TestSuite {
    static TlsCrypto BC_CRYPTO = new BcTlsCrypto(new SecureRandom());
    static TlsCrypto JCA_CRYPTO = new JcaTlsCryptoProvider().setProvider((Provider)new BouncyCastleProvider()).create(new SecureRandom());

    public TlsTestSuite() {
        super("TLS");
    }

    public static Test suite() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        TlsTestSuite testSuite = new TlsTestSuite();
        TlsTestSuite.addAllTests(testSuite, 0, 0);
        TlsTestSuite.addAllTests(testSuite, 1, 0);
        TlsTestSuite.addAllTests(testSuite, 0, 1);
        TlsTestSuite.addAllTests(testSuite, 1, 1);
        return testSuite;
    }

    private static void addAllTests(TestSuite testSuite, int clientCrypto, int serverCrypto) {
        TlsTestSuite.addFallbackTests(testSuite, clientCrypto, serverCrypto);
        TlsTestSuite.addVersionTests(testSuite, ProtocolVersion.SSLv3, clientCrypto, serverCrypto);
        TlsTestSuite.addVersionTests(testSuite, ProtocolVersion.TLSv10, clientCrypto, serverCrypto);
        TlsTestSuite.addVersionTests(testSuite, ProtocolVersion.TLSv11, clientCrypto, serverCrypto);
        TlsTestSuite.addVersionTests(testSuite, ProtocolVersion.TLSv12, clientCrypto, serverCrypto);
    }

    private static void addFallbackTests(TestSuite testSuite, int clientCrypto, int serverCrypto) {
        String prefix = TlsTestSuite.getCryptoName(clientCrypto) + "_" + TlsTestSuite.getCryptoName(serverCrypto) + "_";
        TlsTestConfig c = TlsTestSuite.createTlsTestConfig(ProtocolVersion.TLSv12, clientCrypto, serverCrypto);
        c.clientFallback = true;
        TlsTestSuite.addTestCase(testSuite, c, prefix + "FallbackGood");
        c = TlsTestSuite.createTlsTestConfig(ProtocolVersion.TLSv12, clientCrypto, serverCrypto);
        c.clientFallback = true;
        c.clientSupportedVersions = ProtocolVersion.TLSv11.downTo(ProtocolVersion.TLSv10);
        c.expectServerFatalAlert((short)86);
        TlsTestSuite.addTestCase(testSuite, c, prefix + "FallbackBad");
        c = TlsTestSuite.createTlsTestConfig(ProtocolVersion.TLSv12, clientCrypto, serverCrypto);
        c.clientSupportedVersions = ProtocolVersion.TLSv11.downTo(ProtocolVersion.TLSv10);
        TlsTestSuite.addTestCase(testSuite, c, prefix + "FallbackNone");
    }

    private static void addVersionTests(TestSuite testSuite, ProtocolVersion version, int clientCrypto, int serverCrypto) {
        String prefix = TlsTestSuite.getCryptoName(clientCrypto) + "_" + TlsTestSuite.getCryptoName(serverCrypto) + "_" + version.toString().replaceAll("[ \\.]", "") + "_";
        boolean isTLSv12 = TlsUtils.isTLSv12(version);
        boolean isTLSv13 = TlsUtils.isTLSv13(version);
        boolean isTLSv12Exactly = isTLSv12 && !isTLSv13;
        short certReqDeclinedAlert = TlsUtils.isTLSv13(version) ? (short)116 : 40;
        TlsTestConfig c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
        TlsTestSuite.addTestCase(testSuite, c, prefix + "GoodDefault");
        if (isTLSv13) {
            c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
            c.clientEmptyKeyShare = true;
            TlsTestSuite.addTestCase(testSuite, c, prefix + "GoodEmptyKeyShare");
        }
        if (isTLSv12Exactly) {
            c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
            c.clientAuth = 1;
            c.clientAuthSigAlg = new SignatureAndHashAlgorithm(1, 1);
            c.serverCertReqSigAlgs = TlsUtils.getDefaultRSASignatureAlgorithms();
            c.serverCheckSigAlgOfClientCerts = false;
            c.expectClientFatalAlert((short)80);
            TlsTestSuite.addTestCase(testSuite, c, prefix + "BadCertificateVerifyHashAlg");
        }
        if (isTLSv12) {
            c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
            c.clientAuth = 1;
            c.clientAuthSigAlg = new SignatureAndHashAlgorithm(2, 1);
            c.serverCertReqSigAlgs = TlsUtils.getDefaultECDSASignatureAlgorithms();
            c.serverCheckSigAlgOfClientCerts = false;
            c.expectServerFatalAlert((short)47);
            TlsTestSuite.addTestCase(testSuite, c, prefix + "BadCertificateVerifySigAlg");
        }
        if (isTLSv12) {
            c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
            c.clientAuth = 1;
            c.clientAuthSigAlg = new SignatureAndHashAlgorithm(2, 1);
            c.clientAuthSigAlgClaimed = new SignatureAndHashAlgorithm(2, 3);
            c.serverCertReqSigAlgs = TlsUtils.getDefaultECDSASignatureAlgorithms();
            c.expectServerFatalAlert((short)42);
            TlsTestSuite.addTestCase(testSuite, c, prefix + "BadCertificateVerifySigAlgMismatch");
        }
        c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
        c.clientAuth = 3;
        c.expectServerFatalAlert((short)51);
        TlsTestSuite.addTestCase(testSuite, c, prefix + "BadCertificateVerifySignature");
        c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
        c.clientAuth = 2;
        c.expectServerFatalAlert((short)42);
        TlsTestSuite.addTestCase(testSuite, c, prefix + "BadClientCertificate");
        if (isTLSv13) {
            c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
            c.clientSendSignatureAlgorithms = false;
            c.clientSendSignatureAlgorithmsCert = false;
            c.expectServerFatalAlert((short)109);
            TlsTestSuite.addTestCase(testSuite, c, prefix + "BadClientSigAlgs");
        }
        c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
        c.clientAuth = 0;
        c.serverCertReq = 2;
        c.expectServerFatalAlert(certReqDeclinedAlert);
        TlsTestSuite.addTestCase(testSuite, c, prefix + "BadMandatoryCertReqDeclined");
        if (isTLSv12Exactly) {
            c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
            c.clientSendSignatureAlgorithms = false;
            c.clientSendSignatureAlgorithmsCert = false;
            c.serverAuthSigAlg = new SignatureAndHashAlgorithm(4, 1);
            c.expectClientFatalAlert((short)42);
            TlsTestSuite.addTestCase(testSuite, c, prefix + "BadServerCertSigAlg");
        }
        if (TlsUtils.isTLSv12(version)) {
            c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
            c.serverAuthSigAlg = new SignatureAndHashAlgorithm(1, 1);
            c.expectClientFatalAlert((short)47);
            TlsTestSuite.addTestCase(testSuite, c, prefix + "BadServerKeyExchangeSigAlg");
        }
        if (isTLSv12Exactly) {
            c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
            c.clientCheckSigAlgOfServerCerts = false;
            c.clientSendSignatureAlgorithms = false;
            c.clientSendSignatureAlgorithmsCert = false;
            c.serverAuthSigAlg = new SignatureAndHashAlgorithm(1, 1);
            c.expectClientFatalAlert((short)47);
            TlsTestSuite.addTestCase(testSuite, c, prefix + "BadServerKeyExchangeSigAlg2");
        }
        c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
        c.serverCertReq = 0;
        TlsTestSuite.addTestCase(testSuite, c, prefix + "GoodNoCertReq");
        c = TlsTestSuite.createTlsTestConfig(version, clientCrypto, serverCrypto);
        c.clientAuth = 0;
        TlsTestSuite.addTestCase(testSuite, c, prefix + "GoodOptionalCertReqDeclined");
    }

    private static void addTestCase(TestSuite testSuite, TlsTestConfig config, String name) {
        testSuite.addTest((Test)new TlsTestCase(config, name));
    }

    private static TlsTestConfig createTlsTestConfig(ProtocolVersion serverMaxVersion, int clientCrypto, int serverCrypto) {
        TlsTestConfig c = new TlsTestConfig();
        c.clientCrypto = clientCrypto;
        c.clientSupportedVersions = ProtocolVersion.TLSv12.downTo(ProtocolVersion.SSLv3);
        c.serverCrypto = serverCrypto;
        c.serverSupportedVersions = serverMaxVersion.downTo(ProtocolVersion.SSLv3);
        return c;
    }

    private static String getCryptoName(int crypto) {
        switch (crypto) {
            case 1: {
                return "JCA";
            }
        }
        return "BC";
    }

    static abstract class C
    extends TlsTestConfig {
        C() {
        }
    }
}

