/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.test;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.Reader;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Hashtable;
import java.util.Vector;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.CertificateEntry;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsCredentialedAgreement;
import org.bouncycastle.tls.TlsCredentialedDecryptor;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedAgreement;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedDecryptor;
import org.bouncycastle.tls.crypto.impl.bc.BcDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaDefaultTlsCredentialedSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JceDefaultTlsCredentialedAgreement;
import org.bouncycastle.tls.crypto.impl.jcajce.JceDefaultTlsCredentialedDecryptor;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;

public class TlsTestUtils {
    static final byte[] rsaCertData = Base64.decode((String)"MIICUzCCAf2gAwIBAgIBATANBgkqhkiG9w0BAQQFADCBjzELMAkGA1UEBhMCQVUxKDAmBgNVBAoMH1RoZSBMZWdpb24gb2YgdGhlIEJvdW5jeSBDYXN0bGUxEjAQBgNVBAcMCU1lbGJvdXJuZTERMA8GA1UECAwIVmljdG9yaWExLzAtBgkqhkiG9w0BCQEWIGZlZWRiYWNrLWNyeXB0b0Bib3VuY3ljYXN0bGUub3JnMB4XDTEzMDIyNTA2MDIwNVoXDTEzMDIyNTA2MDM0NVowgY8xCzAJBgNVBAYTAkFVMSgwJgYDVQQKDB9UaGUgTGVnaW9uIG9mIHRoZSBCb3VuY3kgQ2FzdGxlMRIwEAYDVQQHDAlNZWxib3VybmUxETAPBgNVBAgMCFZpY3RvcmlhMS8wLQYJKoZIhvcNAQkBFiBmZWVkYmFjay1jcnlwdG9AYm91bmN5Y2FzdGxlLm9yZzBaMA0GCSqGSIb3DQEBAQUAA0kAMEYCQQC0p+RhcFdPFqlwgrIr5YtqKmKXmEGb4ShypL26Ymz66ZAPdqv7EhOdzl3lZWT6srZUMWWgQMYGiHQg4z2R7X7XAgERo0QwQjAOBgNVHQ8BAf8EBAMCBSAwEgYDVR0lAQH/BAgwBgYEVR0lADAcBgNVHREBAf8EEjAQgQ50ZXN0QHRlc3QudGVzdDANBgkqhkiG9w0BAQQFAANBAHU55NczeglREcTg54YLUlGWu2WOYWhit/iM1eeq8Kivro7q98eW52jTuMI3CI5ulqd0hYzshQKQaZ5GDzErMyM=");
    static final byte[] dudRsaCertData = Base64.decode((String)"MIICUzCCAf2gAwIBAgIBATANBgkqhkiG9w0BAQQFADCBjzELMAkGA1UEBhMCQVUxKDAmBgNVBAoMH1RoZSBMZWdpb24gb2YgdGhlIEJvdW5jeSBDYXN0bGUxEjAQBgNVBAcMCU1lbGJvdXJuZTERMA8GA1UECAwIVmljdG9yaWExLzAtBgkqhkiG9w0BCQEWIGZlZWRiYWNrLWNyeXB0b0Bib3VuY3ljYXN0bGUub3JnMB4XDTEzMDIyNTA1NDcyOFoXDTEzMDIyNTA1NDkwOFowgY8xCzAJBgNVBAYTAkFVMSgwJgYDVQQKDB9UaGUgTGVnaW9uIG9mIHRoZSBCb3VuY3kgQ2FzdGxlMRIwEAYDVQQHDAlNZWxib3VybmUxETAPBgNVBAgMCFZpY3RvcmlhMS8wLQYJKoZIhvcNAQkBFiBmZWVkYmFjay1jcnlwdG9AYm91bmN5Y2FzdGxlLm9yZzBaMA0GCSqGSIb3DQEBAQUAA0kAMEYCQQC0p+RhcFdPFqlwgrIr5YtqKmKXmEGb4ShypL26Ymz66ZAPdqv7EhOdzl3lZWT6srZUMWWgQMYGiHQg4z2R7X7XAgERo0QwQjAOBgNVHQ8BAf8EBAMCAAEwEgYDVR0lAQH/BAgwBgYEVR0lADAcBgNVHREBAf8EEjAQgQ50ZXN0QHRlc3QudGVzdDANBgkqhkiG9w0BAQQFAANBAJg55PBSweg6obRUKF4FF6fCrWFi6oCYSQ99LWcAeupc5BofW5MstFMhCOaEucuGVqunwT5G7/DweazzCIrSzB0=");

    static String fingerprint(org.bouncycastle.asn1.x509.Certificate c) throws IOException {
        byte[] der = c.getEncoded();
        byte[] sha1 = TlsTestUtils.sha256DigestOf(der);
        byte[] hexBytes = Hex.encode((byte[])sha1);
        String hex = new String(hexBytes, "ASCII").toUpperCase();
        StringBuffer fp = new StringBuffer();
        int i = 0;
        fp.append(hex.substring(i, i + 2));
        while ((i += 2) < hex.length()) {
            fp.append(':');
            fp.append(hex.substring(i, i + 2));
        }
        return fp.toString();
    }

    static byte[] sha256DigestOf(byte[] input) {
        SHA256Digest d = new SHA256Digest();
        d.update(input, 0, input.length);
        byte[] result = new byte[d.getDigestSize()];
        d.doFinal(result, 0);
        return result;
    }

    static String getCACertResource(short signatureAlgorithm) throws IOException {
        return "x509-ca-" + TlsTestUtils.getResourceName(signatureAlgorithm) + ".pem";
    }

    static String getCACertResource(String eeCertResource) throws IOException {
        if (eeCertResource.startsWith("x509-client-")) {
            eeCertResource = eeCertResource.substring("x509-client-".length());
        }
        if (eeCertResource.startsWith("x509-server-")) {
            eeCertResource = eeCertResource.substring("x509-server-".length());
        }
        if (eeCertResource.endsWith(".pem")) {
            eeCertResource = eeCertResource.substring(0, eeCertResource.length() - ".pem".length());
        }
        if ("dsa".equalsIgnoreCase(eeCertResource)) {
            return TlsTestUtils.getCACertResource((short)2);
        }
        if ("ecdh".equalsIgnoreCase(eeCertResource) || "ecdsa".equalsIgnoreCase(eeCertResource)) {
            return TlsTestUtils.getCACertResource((short)3);
        }
        if ("ed25519".equalsIgnoreCase(eeCertResource)) {
            return TlsTestUtils.getCACertResource((short)7);
        }
        if ("ed448".equalsIgnoreCase(eeCertResource)) {
            return TlsTestUtils.getCACertResource((short)8);
        }
        if ("rsa".equalsIgnoreCase(eeCertResource) || "rsa-enc".equalsIgnoreCase(eeCertResource) || "rsa-sign".equalsIgnoreCase(eeCertResource)) {
            return TlsTestUtils.getCACertResource((short)1);
        }
        if ("rsa_pss_256".equalsIgnoreCase(eeCertResource)) {
            return TlsTestUtils.getCACertResource((short)9);
        }
        if ("rsa_pss_384".equalsIgnoreCase(eeCertResource)) {
            return TlsTestUtils.getCACertResource((short)10);
        }
        if ("rsa_pss_512".equalsIgnoreCase(eeCertResource)) {
            return TlsTestUtils.getCACertResource((short)11);
        }
        throw new TlsFatalAlert(80);
    }

    static String getResourceName(short signatureAlgorithm) throws IOException {
        switch (signatureAlgorithm) {
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                return "rsa";
            }
            case 2: {
                return "dsa";
            }
            case 3: {
                return "ecdsa";
            }
            case 7: {
                return "ed25519";
            }
            case 8: {
                return "ed448";
            }
            case 9: {
                return "rsa_pss_256";
            }
            case 10: {
                return "rsa_pss_384";
            }
            case 11: {
                return "rsa_pss_512";
            }
        }
        throw new TlsFatalAlert(80);
    }

    static TlsCredentialedAgreement loadAgreementCredentials(TlsContext context, String[] certResources, String keyResource) throws IOException {
        TlsCrypto crypto = context.getCrypto();
        Certificate certificate = TlsTestUtils.loadCertificateChain(context, certResources);
        if (crypto instanceof BcTlsCrypto) {
            AsymmetricKeyParameter privateKey = TlsTestUtils.loadBcPrivateKeyResource(keyResource);
            return new BcDefaultTlsCredentialedAgreement((BcTlsCrypto)crypto, certificate, privateKey);
        }
        JcaTlsCrypto jcaCrypto = (JcaTlsCrypto)crypto;
        PrivateKey privateKey = TlsTestUtils.loadJcaPrivateKeyResource(jcaCrypto, keyResource);
        return new JceDefaultTlsCredentialedAgreement(jcaCrypto, certificate, privateKey);
    }

    static TlsCredentialedDecryptor loadEncryptionCredentials(TlsContext context, String[] certResources, String keyResource) throws IOException {
        TlsCrypto crypto = context.getCrypto();
        Certificate certificate = TlsTestUtils.loadCertificateChain(context, certResources);
        if (crypto instanceof BcTlsCrypto) {
            AsymmetricKeyParameter privateKey = TlsTestUtils.loadBcPrivateKeyResource(keyResource);
            return new BcDefaultTlsCredentialedDecryptor((BcTlsCrypto)crypto, certificate, privateKey);
        }
        JcaTlsCrypto jcaCrypto = (JcaTlsCrypto)crypto;
        PrivateKey privateKey = TlsTestUtils.loadJcaPrivateKeyResource(jcaCrypto, keyResource);
        return new JceDefaultTlsCredentialedDecryptor(jcaCrypto, certificate, privateKey);
    }

    static TlsCredentialedSigner loadSignerCredentials(TlsContext context, String[] certResources, String keyResource, SignatureAndHashAlgorithm signatureAndHashAlgorithm) throws IOException {
        TlsCrypto crypto = context.getCrypto();
        Certificate certificate = TlsTestUtils.loadCertificateChain(context, certResources);
        TlsCryptoParameters cryptoParams = new TlsCryptoParameters(context);
        if (crypto instanceof BcTlsCrypto) {
            AsymmetricKeyParameter privateKey = TlsTestUtils.loadBcPrivateKeyResource(keyResource);
            return new BcDefaultTlsCredentialedSigner(cryptoParams, (BcTlsCrypto)crypto, privateKey, certificate, signatureAndHashAlgorithm);
        }
        JcaTlsCrypto jcaCrypto = (JcaTlsCrypto)crypto;
        PrivateKey privateKey = TlsTestUtils.loadJcaPrivateKeyResource(jcaCrypto, keyResource);
        return new JcaDefaultTlsCredentialedSigner(cryptoParams, jcaCrypto, privateKey, certificate, signatureAndHashAlgorithm);
    }

    static TlsCredentialedSigner loadSignerCredentials(TlsContext context, Vector supportedSignatureAlgorithms, short signatureAlgorithm, String certResource, String keyResource) throws IOException {
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = null;
        if (supportedSignatureAlgorithms == null) {
            supportedSignatureAlgorithms = TlsUtils.getDefaultSignatureAlgorithms(signatureAlgorithm);
        }
        for (int i = 0; i < supportedSignatureAlgorithms.size(); ++i) {
            SignatureAndHashAlgorithm alg = (SignatureAndHashAlgorithm)supportedSignatureAlgorithms.elementAt(i);
            if (alg.getSignature() != signatureAlgorithm) continue;
            signatureAndHashAlgorithm = alg;
            break;
        }
        if (signatureAndHashAlgorithm == null) {
            return null;
        }
        return TlsTestUtils.loadSignerCredentials(context, new String[]{certResource}, keyResource, signatureAndHashAlgorithm);
    }

    static TlsCredentialedSigner loadSignerCredentialsServer(TlsContext context, Vector supportedSignatureAlgorithms, short signatureAlgorithm) throws IOException {
        String sigName = TlsTestUtils.getResourceName(signatureAlgorithm);
        switch (signatureAlgorithm) {
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                sigName = sigName + "-sign";
            }
        }
        String certResource = "x509-server-" + sigName + ".pem";
        String keyResource = "x509-server-key-" + sigName + ".pem";
        return TlsTestUtils.loadSignerCredentials(context, supportedSignatureAlgorithms, signatureAlgorithm, certResource, keyResource);
    }

    static Certificate loadCertificateChain(TlsContext context, String[] resources) throws IOException {
        TlsCrypto crypto = context.getCrypto();
        if (TlsUtils.isTLSv13(context)) {
            CertificateEntry[] certificateEntryList = new CertificateEntry[resources.length];
            for (int i = 0; i < resources.length; ++i) {
                TlsCertificate certificate = TlsTestUtils.loadCertificateResource(crypto, resources[i]);
                Hashtable extensions = null;
                certificateEntryList[i] = new CertificateEntry(certificate, extensions);
            }
            byte[] certificateRequestContext = TlsUtils.EMPTY_BYTES;
            return new Certificate(certificateRequestContext, certificateEntryList);
        }
        TlsCertificate[] chain = new TlsCertificate[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            chain[i] = TlsTestUtils.loadCertificateResource(crypto, resources[i]);
        }
        return new Certificate(chain);
    }

    static org.bouncycastle.asn1.x509.Certificate loadBcCertificateResource(String resource) throws IOException {
        PemObject pem = TlsTestUtils.loadPemResource(resource);
        if (pem.getType().endsWith("CERTIFICATE")) {
            return org.bouncycastle.asn1.x509.Certificate.getInstance((Object)pem.getContent());
        }
        throw new IllegalArgumentException("'resource' doesn't specify a valid certificate");
    }

    static TlsCertificate loadCertificateResource(TlsCrypto crypto, String resource) throws IOException {
        PemObject pem = TlsTestUtils.loadPemResource(resource);
        if (pem.getType().endsWith("CERTIFICATE")) {
            return crypto.createCertificate(pem.getContent());
        }
        throw new IllegalArgumentException("'resource' doesn't specify a valid certificate");
    }

    static AsymmetricKeyParameter loadBcPrivateKeyResource(String resource) throws IOException {
        PemObject pem = TlsTestUtils.loadPemResource(resource);
        if (pem.getType().equals("PRIVATE KEY")) {
            return PrivateKeyFactory.createKey((byte[])pem.getContent());
        }
        if (pem.getType().equals("ENCRYPTED PRIVATE KEY")) {
            throw new UnsupportedOperationException("Encrypted PKCS#8 keys not supported");
        }
        if (pem.getType().equals("RSA PRIVATE KEY")) {
            RSAPrivateKey rsa = RSAPrivateKey.getInstance((Object)pem.getContent());
            return new RSAPrivateCrtKeyParameters(rsa.getModulus(), rsa.getPublicExponent(), rsa.getPrivateExponent(), rsa.getPrime1(), rsa.getPrime2(), rsa.getExponent1(), rsa.getExponent2(), rsa.getCoefficient());
        }
        if (pem.getType().equals("EC PRIVATE KEY")) {
            ECPrivateKey pKey = ECPrivateKey.getInstance((Object)pem.getContent());
            AlgorithmIdentifier algId = new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)pKey.getParameters());
            PrivateKeyInfo privInfo = new PrivateKeyInfo(algId, (ASN1Encodable)pKey);
            return PrivateKeyFactory.createKey((PrivateKeyInfo)privInfo);
        }
        throw new IllegalArgumentException("'resource' doesn't specify a valid private key");
    }

    static PrivateKey loadJcaPrivateKeyResource(JcaTlsCrypto crypto, String resource) throws IOException {
        GeneralSecurityException cause = null;
        try {
            PemObject pem = TlsTestUtils.loadPemResource(resource);
            if (pem.getType().equals("PRIVATE KEY")) {
                return TlsTestUtils.loadJcaPkcs8PrivateKey(crypto, pem.getContent());
            }
            if (pem.getType().equals("ENCRYPTED PRIVATE KEY")) {
                throw new UnsupportedOperationException("Encrypted PKCS#8 keys not supported");
            }
            if (pem.getType().equals("RSA PRIVATE KEY")) {
                RSAPrivateKey rsa = RSAPrivateKey.getInstance((Object)pem.getContent());
                KeyFactory keyFact = crypto.getHelper().createKeyFactory("RSA");
                return keyFact.generatePrivate(new RSAPrivateCrtKeySpec(rsa.getModulus(), rsa.getPublicExponent(), rsa.getPrivateExponent(), rsa.getPrime1(), rsa.getPrime2(), rsa.getExponent1(), rsa.getExponent2(), rsa.getCoefficient()));
            }
        }
        catch (GeneralSecurityException e) {
            cause = e;
        }
        throw new IllegalArgumentException("'resource' doesn't specify a valid private key", cause);
    }

    static PrivateKey loadJcaPkcs8PrivateKey(JcaTlsCrypto crypto, byte[] encoded) throws GeneralSecurityException {
        PrivateKeyInfo pki = PrivateKeyInfo.getInstance((Object)encoded);
        AlgorithmIdentifier algID = pki.getPrivateKeyAlgorithm();
        ASN1ObjectIdentifier oid = algID.getAlgorithm();
        String name = X9ObjectIdentifiers.id_dsa.equals((ASN1Primitive)oid) ? "DSA" : (X9ObjectIdentifiers.id_ecPublicKey.equals((ASN1Primitive)oid) ? "EC" : (PKCSObjectIdentifiers.rsaEncryption.equals((ASN1Primitive)oid) || PKCSObjectIdentifiers.id_RSASSA_PSS.equals((ASN1Primitive)oid) ? "RSA" : (EdECObjectIdentifiers.id_Ed25519.equals((ASN1Primitive)oid) ? "Ed25519" : (EdECObjectIdentifiers.id_Ed448.equals((ASN1Primitive)oid) ? "Ed448" : oid.getId()))));
        KeyFactory kf = crypto.getHelper().createKeyFactory(name);
        return kf.generatePrivate(new PKCS8EncodedKeySpec(encoded));
    }

    static PemObject loadPemResource(String resource) throws IOException {
        InputStream s = TlsTestUtils.class.getResourceAsStream(resource);
        PemReader p = new PemReader((Reader)new InputStreamReader(s));
        PemObject o = p.readPemObject();
        p.close();
        return o;
    }

    static boolean areSameCertificate(TlsCrypto crypto, TlsCertificate cert, String resource) throws IOException {
        return TlsTestUtils.areSameCertificate(cert, TlsTestUtils.loadCertificateResource(crypto, resource));
    }

    static boolean areSameCertificate(TlsCertificate a, TlsCertificate b) throws IOException {
        return Arrays.areEqual((byte[])a.getEncoded(), (byte[])b.getEncoded());
    }

    static TlsCertificate[] getTrustedCertPath(TlsCrypto crypto, TlsCertificate cert, String[] resources) throws IOException {
        for (int i = 0; i < resources.length; ++i) {
            String caCertResource;
            TlsCertificate caCert;
            String eeCertResource = resources[i];
            TlsCertificate eeCert = TlsTestUtils.loadCertificateResource(crypto, eeCertResource);
            if (!TlsTestUtils.areSameCertificate(cert, eeCert) || null == (caCert = TlsTestUtils.loadCertificateResource(crypto, caCertResource = TlsTestUtils.getCACertResource(eeCertResource)))) continue;
            return new TlsCertificate[]{eeCert, caCert};
        }
        return null;
    }

    static TrustManagerFactory getSunX509TrustManagerFactory() throws NoSuchAlgorithmException {
        if (Security.getProvider("IBMJSSE2") != null) {
            return TrustManagerFactory.getInstance("IBMX509");
        }
        return TrustManagerFactory.getInstance("SunX509");
    }

    static KeyManagerFactory getSunX509KeyManagerFactory() throws NoSuchAlgorithmException {
        if (Security.getProvider("IBMJSSE2") != null) {
            return KeyManagerFactory.getInstance("IBMX509");
        }
        return KeyManagerFactory.getInstance("SunX509");
    }

    static PipedInputStream createPipedInputStream() {
        return new BigPipedInputStream(16384);
    }

    private static class BigPipedInputStream
    extends PipedInputStream {
        BigPipedInputStream(int size) {
            this.buffer = new byte[size];
        }
    }
}

