/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.test;

import java.util.Random;
import java.util.Vector;
import junit.framework.TestCase;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SecurityParameters;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsServerContext;
import org.bouncycastle.tls.TlsSession;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCrypto;
import org.bouncycastle.tls.crypto.TlsNonceGenerator;

public class TlsUtilsTest
extends TestCase {
    public void testChooseSignatureAndHash() throws Exception {
        int keyExchangeAlgorithm = 19;
        TlsServerContext context = new TlsServerContext(){

            public TlsCrypto getCrypto() {
                return null;
            }

            public TlsNonceGenerator getNonceGenerator() {
                return null;
            }

            public SecurityParameters getSecurityParameters() {
                return null;
            }

            public SecurityParameters getSecurityParametersConnection() {
                return null;
            }

            public SecurityParameters getSecurityParametersHandshake() {
                return null;
            }

            public boolean isServer() {
                return false;
            }

            public ProtocolVersion[] getClientSupportedVersions() {
                return null;
            }

            public ProtocolVersion getClientVersion() {
                return null;
            }

            public ProtocolVersion getRSAPreMasterSecretVersion() {
                return null;
            }

            public ProtocolVersion getServerVersion() {
                return ProtocolVersion.TLSv12;
            }

            public TlsSession getResumableSession() {
                return null;
            }

            public TlsSession getSession() {
                return null;
            }

            public Object getUserObject() {
                throw new UnsupportedOperationException();
            }

            public void setUserObject(Object userObject) {
                throw new UnsupportedOperationException();
            }

            public byte[] exportChannelBinding(int channelBinding) {
                throw new UnsupportedOperationException();
            }

            public byte[] exportEarlyKeyingMaterial(String asciiLabel, byte[] context_value, int length) {
                throw new UnsupportedOperationException();
            }

            public byte[] exportKeyingMaterial(String asciiLabel, byte[] context_value, int length) {
                throw new UnsupportedOperationException();
            }
        };
        short signatureAlgorithm = TlsUtils.getLegacySignatureAlgorithmServer(keyExchangeAlgorithm);
        Vector supportedSignatureAlgorithms = TlsUtilsTest.getSignatureAlgorithms(false);
        SignatureAndHashAlgorithm sigAlg = TlsUtils.chooseSignatureAndHashAlgorithm(context, supportedSignatureAlgorithms, signatureAlgorithm);
        TlsUtilsTest.assertEquals((short)4, (short)sigAlg.getHash());
        for (int count = 0; count < 10; ++count) {
            supportedSignatureAlgorithms = TlsUtilsTest.getSignatureAlgorithms(true);
            sigAlg = TlsUtils.chooseSignatureAndHashAlgorithm(context, supportedSignatureAlgorithms, signatureAlgorithm);
            TlsUtilsTest.assertEquals((short)4, (short)sigAlg.getHash());
        }
    }

    private static Vector getSignatureAlgorithms(boolean randomise) {
        short[] hashAlgorithms = new short[]{2, 3, 4, 5, 6, 1};
        short[] signatureAlgorithms = new short[]{1, 2, 3};
        Vector<SignatureAndHashAlgorithm> result = new Vector<SignatureAndHashAlgorithm>();
        for (int i = 0; i < signatureAlgorithms.length; ++i) {
            for (int j = 0; j < hashAlgorithms.length; ++j) {
                result.addElement(new SignatureAndHashAlgorithm(hashAlgorithms[j], signatureAlgorithms[i]));
            }
        }
        Random r = new Random();
        int count = result.size();
        for (int src = 0; src < count; ++src) {
            int dst = r.nextInt(count);
            if (src == dst) continue;
            Object a = result.elementAt(src);
            Object b = result.elementAt(dst);
            result.setElementAt((SignatureAndHashAlgorithm)a, dst);
            result.setElementAt((SignatureAndHashAlgorithm)b, src);
        }
        return result;
    }
}

