/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.tls.CertificateEntry;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsProtocol;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;

public class Certificate {
    private static final TlsCertificate[] EMPTY_CERTS = new TlsCertificate[0];
    private static final CertificateEntry[] EMPTY_CERT_ENTRIES = new CertificateEntry[0];
    public static final Certificate EMPTY_CHAIN = new Certificate(EMPTY_CERTS);
    public static final Certificate EMPTY_CHAIN_TLS13 = new Certificate(TlsUtils.EMPTY_BYTES, EMPTY_CERT_ENTRIES);
    protected final byte[] certificateRequestContext;
    protected final CertificateEntry[] certificateEntryList;

    private static CertificateEntry[] convert(TlsCertificate[] tlsCertificateArray) {
        if (TlsUtils.isNullOrContainsNull(tlsCertificateArray)) {
            throw new NullPointerException("'certificateList' cannot be null or contain any nulls");
        }
        int n = tlsCertificateArray.length;
        CertificateEntry[] certificateEntryArray = new CertificateEntry[n];
        for (int i = 0; i < n; ++i) {
            certificateEntryArray[i] = new CertificateEntry(tlsCertificateArray[i], null);
        }
        return certificateEntryArray;
    }

    public Certificate(TlsCertificate[] tlsCertificateArray) {
        this(null, Certificate.convert(tlsCertificateArray));
    }

    public Certificate(byte[] byArray, CertificateEntry[] certificateEntryArray) {
        if (null != byArray && !TlsUtils.isValidUint8(byArray.length)) {
            throw new IllegalArgumentException("'certificateRequestContext' cannot be longer than 255");
        }
        if (TlsUtils.isNullOrContainsNull(certificateEntryArray)) {
            throw new NullPointerException("'certificateEntryList' cannot be null or contain any nulls");
        }
        this.certificateRequestContext = TlsUtils.clone(byArray);
        this.certificateEntryList = certificateEntryArray;
    }

    public byte[] getCertificateRequestContext() {
        return TlsUtils.clone(this.certificateRequestContext);
    }

    public TlsCertificate[] getCertificateList() {
        return this.cloneCertificateList();
    }

    public TlsCertificate getCertificateAt(int n) {
        return this.certificateEntryList[n].getCertificate();
    }

    public CertificateEntry getCertificateEntryAt(int n) {
        return this.certificateEntryList[n];
    }

    public CertificateEntry[] getCertificateEntryList() {
        return this.cloneCertificateEntryList();
    }

    public short getCertificateType() {
        return 0;
    }

    public int getLength() {
        return this.certificateEntryList.length;
    }

    public boolean isEmpty() {
        return this.certificateEntryList.length == 0;
    }

    public void encode(TlsContext tlsContext, OutputStream outputStream, OutputStream outputStream2) throws IOException {
        Object object;
        Object object2;
        int n;
        boolean bl;
        if (null != this.certificateRequestContext != (bl = TlsUtils.isTLSv13(tlsContext))) {
            throw new IllegalStateException();
        }
        if (bl) {
            TlsUtils.writeOpaque8(this.certificateRequestContext, outputStream);
        }
        int n2 = this.certificateEntryList.length;
        Vector<byte[]> vector = new Vector<byte[]>(n2);
        Vector<byte[]> vector2 = bl ? new Vector<byte[]>(n2) : null;
        long l = 0L;
        for (n = 0; n < n2; ++n) {
            object2 = this.certificateEntryList[n];
            object = ((CertificateEntry)object2).getCertificate();
            byte[] byArray = object.getEncoded();
            if (n == 0 && outputStream2 != null) {
                Certificate.calculateEndPointHash(tlsContext, (TlsCertificate)object, byArray, outputStream2);
            }
            vector.addElement(byArray);
            l += (long)byArray.length;
            l += 3L;
            if (!bl) continue;
            Hashtable hashtable = ((CertificateEntry)object2).getExtensions();
            byte[] byArray2 = null == hashtable ? TlsUtils.EMPTY_BYTES : TlsProtocol.writeExtensionsData(hashtable);
            vector2.addElement(byArray2);
            l += (long)byArray2.length;
            l += 2L;
        }
        TlsUtils.checkUint24(l);
        TlsUtils.writeUint24((int)l, outputStream);
        for (n = 0; n < n2; ++n) {
            object2 = (byte[])vector.elementAt(n);
            TlsUtils.writeOpaque24((byte[])object2, outputStream);
            if (!bl) continue;
            object = (byte[])vector2.elementAt(n);
            TlsUtils.writeOpaque16((byte[])object, outputStream);
        }
    }

    public static Certificate parse(TlsContext tlsContext, InputStream inputStream, OutputStream outputStream) throws IOException {
        Object[] objectArray;
        int n;
        boolean bl = TlsUtils.isTLSv13(tlsContext);
        byte[] byArray = null;
        if (bl) {
            byArray = TlsUtils.readOpaque8(inputStream);
        }
        if ((n = TlsUtils.readUint24(inputStream)) == 0) {
            return !bl ? EMPTY_CHAIN : (byArray.length < 1 ? EMPTY_CHAIN_TLS13 : new Certificate(byArray, EMPTY_CERT_ENTRIES));
        }
        byte[] byArray2 = TlsUtils.readFully(n, inputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        Vector<CertificateEntry> vector = new Vector<CertificateEntry>();
        while (byteArrayInputStream.available() > 0) {
            objectArray = TlsUtils.readOpaque24(byteArrayInputStream, 1);
            TlsCertificate tlsCertificate = tlsContext.getCrypto().createCertificate((byte[])objectArray);
            if (vector.isEmpty() && outputStream != null) {
                Certificate.calculateEndPointHash(tlsContext, tlsCertificate, objectArray, outputStream);
            }
            Hashtable hashtable = null;
            if (bl) {
                byte[] byArray3 = TlsUtils.readOpaque16(byteArrayInputStream);
                hashtable = TlsProtocol.readExtensionsData13(11, byArray3);
            }
            vector.addElement(new CertificateEntry(tlsCertificate, hashtable));
        }
        objectArray = new CertificateEntry[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            objectArray[i] = (byte)((CertificateEntry)vector.elementAt(i));
        }
        return new Certificate(byArray, (CertificateEntry[])objectArray);
    }

    protected static void calculateEndPointHash(TlsContext tlsContext, TlsCertificate tlsCertificate, byte[] byArray, OutputStream outputStream) throws IOException {
        byte[] byArray2 = TlsUtils.calculateEndPointHash(tlsContext, tlsCertificate, byArray);
        if (byArray2 != null && byArray2.length > 0) {
            outputStream.write(byArray2);
        }
    }

    protected TlsCertificate[] cloneCertificateList() {
        int n = this.certificateEntryList.length;
        if (0 == n) {
            return EMPTY_CERTS;
        }
        TlsCertificate[] tlsCertificateArray = new TlsCertificate[n];
        for (int i = 0; i < n; ++i) {
            tlsCertificateArray[i] = this.certificateEntryList[i].getCertificate();
        }
        return tlsCertificateArray;
    }

    protected CertificateEntry[] cloneCertificateEntryList() {
        int n = this.certificateEntryList.length;
        if (0 == n) {
            return EMPTY_CERT_ENTRIES;
        }
        CertificateEntry[] certificateEntryArray = new CertificateEntry[n];
        System.arraycopy(this.certificateEntryList, 0, certificateEntryArray, 0, n);
        return certificateEntryArray;
    }
}

