/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import org.bouncycastle.tls.AbstractTlsKeyExchange;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DigestInputBuffer;
import org.bouncycastle.tls.ServerSRPParams;
import org.bouncycastle.tls.TlsCredentialedSigner;
import org.bouncycastle.tls.TlsCredentials;
import org.bouncycastle.tls.TlsFatalAlert;
import org.bouncycastle.tls.TlsSRPConfigVerifier;
import org.bouncycastle.tls.TlsSRPIdentity;
import org.bouncycastle.tls.TlsSRPLoginParameters;
import org.bouncycastle.tls.TlsSRPUtils;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCertificate;
import org.bouncycastle.tls.crypto.TlsSRP6Client;
import org.bouncycastle.tls.crypto.TlsSRP6Server;
import org.bouncycastle.tls.crypto.TlsSRPConfig;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.io.TeeInputStream;

public class TlsSRPKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsSRPIdentity srpIdentity;
    protected TlsSRPConfigVerifier srpConfigVerifier;
    protected TlsCertificate serverCertificate = null;
    protected byte[] srpSalt = null;
    protected TlsSRP6Client srpClient = null;
    protected TlsSRPLoginParameters srpLoginParameters;
    protected TlsCredentialedSigner serverCredentials = null;
    protected TlsSRP6Server srpServer = null;
    protected BigInteger srpPeerCredentials = null;

    private static int checkKeyExchange(int n) {
        switch (n) {
            case 21: 
            case 22: 
            case 23: {
                return n;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsSRPKeyExchange(int n, TlsSRPIdentity tlsSRPIdentity, TlsSRPConfigVerifier tlsSRPConfigVerifier) {
        super(TlsSRPKeyExchange.checkKeyExchange(n));
        this.srpIdentity = tlsSRPIdentity;
        this.srpConfigVerifier = tlsSRPConfigVerifier;
    }

    public TlsSRPKeyExchange(int n, TlsSRPLoginParameters tlsSRPLoginParameters) {
        super(TlsSRPKeyExchange.checkKeyExchange(n));
        this.srpLoginParameters = tlsSRPLoginParameters;
    }

    public void skipServerCredentials() throws IOException {
        if (this.keyExchange != 21) {
            throw new TlsFatalAlert(80);
        }
    }

    public void processServerCredentials(TlsCredentials tlsCredentials) throws IOException {
        if (this.keyExchange == 21) {
            throw new TlsFatalAlert(80);
        }
        this.serverCredentials = TlsUtils.requireSignerCredentials(tlsCredentials);
    }

    public void processServerCertificate(Certificate certificate) throws IOException {
        if (this.keyExchange == 21) {
            throw new TlsFatalAlert(80);
        }
        this.serverCertificate = certificate.getCertificateAt(0);
    }

    public boolean requiresServerKeyExchange() {
        return true;
    }

    public byte[] generateServerKeyExchange() throws IOException {
        TlsSRPConfig tlsSRPConfig = this.srpLoginParameters.getConfig();
        this.srpServer = this.context.getCrypto().createSRP6Server(tlsSRPConfig, this.srpLoginParameters.getVerifier());
        BigInteger bigInteger = this.srpServer.generateServerCredentials();
        BigInteger[] bigIntegerArray = tlsSRPConfig.getExplicitNG();
        ServerSRPParams serverSRPParams = new ServerSRPParams(bigIntegerArray[0], bigIntegerArray[1], this.srpLoginParameters.getSalt(), bigInteger);
        DigestInputBuffer digestInputBuffer = new DigestInputBuffer();
        serverSRPParams.encode(digestInputBuffer);
        if (this.serverCredentials != null) {
            TlsUtils.generateServerKeyExchangeSignature(this.context, this.serverCredentials, null, digestInputBuffer);
        }
        return digestInputBuffer.toByteArray();
    }

    public void processServerKeyExchange(InputStream inputStream) throws IOException {
        DigestInputBuffer digestInputBuffer = null;
        InputStream inputStream2 = inputStream;
        if (this.keyExchange != 21) {
            digestInputBuffer = new DigestInputBuffer();
            inputStream2 = new TeeInputStream(inputStream, (OutputStream)digestInputBuffer);
        }
        ServerSRPParams serverSRPParams = ServerSRPParams.parse(inputStream2);
        if (digestInputBuffer != null) {
            TlsUtils.verifyServerKeyExchangeSignature(this.context, inputStream, this.serverCertificate, null, digestInputBuffer);
        }
        TlsSRPConfig tlsSRPConfig = new TlsSRPConfig();
        tlsSRPConfig.setExplicitNG(new BigInteger[]{serverSRPParams.getN(), serverSRPParams.getG()});
        if (!this.srpConfigVerifier.accept(tlsSRPConfig)) {
            throw new TlsFatalAlert(71);
        }
        this.srpSalt = serverSRPParams.getS();
        this.srpPeerCredentials = TlsSRPKeyExchange.validatePublicValue(serverSRPParams.getN(), serverSRPParams.getB());
        this.srpClient = this.context.getCrypto().createSRP6Client(tlsSRPConfig);
    }

    public void processClientCredentials(TlsCredentials tlsCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void generateClientKeyExchange(OutputStream outputStream) throws IOException {
        byte[] byArray = this.srpIdentity.getSRPIdentity();
        byte[] byArray2 = this.srpIdentity.getSRPPassword();
        BigInteger bigInteger = this.srpClient.generateClientCredentials(this.srpSalt, byArray, byArray2);
        TlsSRPUtils.writeSRPParameter(bigInteger, outputStream);
        this.context.getSecurityParametersHandshake().srpIdentity = Arrays.clone((byte[])byArray);
    }

    public void processClientKeyExchange(InputStream inputStream) throws IOException {
        this.srpPeerCredentials = TlsSRPKeyExchange.validatePublicValue(this.srpLoginParameters.getConfig().getExplicitNG()[0], TlsSRPUtils.readSRPParameter(inputStream));
        this.context.getSecurityParametersHandshake().srpIdentity = Arrays.clone((byte[])this.srpLoginParameters.getIdentity());
    }

    public TlsSecret generatePreMasterSecret() throws IOException {
        BigInteger bigInteger = this.srpServer != null ? this.srpServer.calculateSecret(this.srpPeerCredentials) : this.srpClient.calculateSecret(this.srpPeerCredentials);
        return this.context.getCrypto().createSecret(BigIntegers.asUnsignedByteArray((BigInteger)bigInteger));
    }

    protected static BigInteger validatePublicValue(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
        if ((bigInteger2 = bigInteger2.mod(bigInteger)).equals(BigInteger.ZERO)) {
            throw new TlsFatalAlert(47);
        }
        return bigInteger2;
    }
}

