/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.tls.TlsContext;
import org.bouncycastle.tls.TlsUtils;

public final class CertificateVerify {
    private final int algorithm;
    private final byte[] signature;

    public CertificateVerify(int n, byte[] byArray) {
        if (!TlsUtils.isValidUint16(n)) {
            throw new IllegalArgumentException("'algorithm'");
        }
        if (byArray == null) {
            throw new NullPointerException("'signature' cannot be null");
        }
        this.algorithm = n;
        this.signature = byArray;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public void encode(OutputStream outputStream) throws IOException {
        TlsUtils.writeUint16(this.algorithm, outputStream);
        TlsUtils.writeOpaque16(this.signature, outputStream);
    }

    public static CertificateVerify parse(TlsContext tlsContext, InputStream inputStream) throws IOException {
        if (!TlsUtils.isTLSv13(tlsContext)) {
            throw new IllegalStateException();
        }
        int n = TlsUtils.readUint16(inputStream);
        byte[] byArray = TlsUtils.readOpaque16(inputStream);
        return new CertificateVerify(n, byArray);
    }
}

