/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.TlsCryptoUtils;
import org.bouncycastle.tls.crypto.TlsSecret;
import org.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import org.bouncycastle.tls.crypto.impl.AbstractTlsSecret;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class JceTlsSecret
extends AbstractTlsSecret {
    private static final byte[] SSL3_CONST = JceTlsSecret.generateSSL3Constants();
    protected final JcaTlsCrypto crypto;

    public static JceTlsSecret convert(JcaTlsCrypto jcaTlsCrypto, TlsSecret tlsSecret) {
        if (tlsSecret instanceof JceTlsSecret) {
            return (JceTlsSecret)tlsSecret;
        }
        if (tlsSecret instanceof AbstractTlsSecret) {
            AbstractTlsSecret abstractTlsSecret = (AbstractTlsSecret)tlsSecret;
            return jcaTlsCrypto.adoptLocalSecret(JceTlsSecret.copyData(abstractTlsSecret));
        }
        throw new IllegalArgumentException("unrecognized TlsSecret - cannot copy data: " + tlsSecret.getClass().getName());
    }

    private static byte[] generateSSL3Constants() {
        int n = 15;
        byte[] byArray = new byte[n * (n + 1) / 2];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte by = (byte)(65 + i);
            for (int j = 0; j <= i; ++j) {
                byArray[n2++] = by;
            }
        }
        return byArray;
    }

    public JceTlsSecret(JcaTlsCrypto jcaTlsCrypto, byte[] byArray) {
        super(byArray);
        this.crypto = jcaTlsCrypto;
    }

    public synchronized TlsSecret deriveUsingPRF(int n, String string, byte[] byArray, int n2) {
        this.checkAlive();
        try {
            switch (n) {
                case 4: {
                    return TlsCryptoUtils.hkdfExpandLabel(this, 4, string, byArray, n2);
                }
                case 5: {
                    return TlsCryptoUtils.hkdfExpandLabel(this, 5, string, byArray, n2);
                }
                case 7: {
                    return TlsCryptoUtils.hkdfExpandLabel(this, 7, string, byArray, n2);
                }
            }
            return this.crypto.adoptLocalSecret(this.prf(n, string, byArray, n2));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public synchronized TlsSecret hkdfExpand(int n, byte[] byArray, int n2) {
        if (n2 < 1) {
            return this.crypto.adoptLocalSecret(TlsUtils.EMPTY_BYTES);
        }
        int n3 = TlsCryptoUtils.getHashOutputSize(n);
        if (n2 > 255 * n3) {
            throw new IllegalArgumentException("'length' must be <= 255 * (output size of 'hashAlgorithm')");
        }
        this.checkAlive();
        byte[] byArray2 = this.data;
        try {
            int n4;
            String string = this.crypto.getHMACAlgorithmName(n);
            Mac mac = this.crypto.getHelper().createMac(string);
            mac.init(new SecretKeySpec(byArray2, 0, byArray2.length, string));
            byte[] byArray3 = new byte[n2];
            byte[] byArray4 = new byte[n3];
            byte by = 0;
            int n5 = 0;
            while (true) {
                mac.update(byArray, 0, byArray.length);
                by = (byte)(by + 1);
                mac.update(by);
                mac.doFinal(byArray4, 0);
                n4 = n2 - n5;
                if (n4 <= n3) break;
                System.arraycopy(byArray4, 0, byArray3, n5, n3);
                n5 += n3;
                mac.update(byArray4, 0, byArray4.length);
            }
            System.arraycopy(byArray4, 0, byArray3, n5, n4);
            return this.crypto.adoptLocalSecret(byArray3);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException(generalSecurityException);
        }
    }

    public synchronized TlsSecret hkdfExtract(int n, TlsSecret tlsSecret) {
        this.checkAlive();
        byte[] byArray = this.data;
        this.data = null;
        try {
            String string = this.crypto.getHMACAlgorithmName(n);
            Mac mac = this.crypto.getHelper().createMac(string);
            mac.init(new SecretKeySpec(byArray, 0, byArray.length, string));
            JceTlsSecret.convert(this.crypto, tlsSecret).updateMac(mac);
            byte[] byArray2 = mac.doFinal();
            return this.crypto.adoptLocalSecret(byArray2);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException(generalSecurityException);
        }
    }

    protected AbstractTlsCrypto getCrypto() {
        return this.crypto;
    }

    protected void hmacHash(int n, byte[] byArray, int n2, int n3, byte[] byArray2, byte[] byArray3) throws GeneralSecurityException {
        String string = this.crypto.getDigestName(n).replaceAll("-", "");
        String string2 = "Hmac" + string;
        Mac mac = this.crypto.getHelper().createMac(string2);
        mac.init(new SecretKeySpec(byArray, n2, n3, string2));
        byte[] byArray4 = byArray2;
        int n4 = mac.getMacLength();
        byte[] byArray5 = new byte[n4];
        byte[] byArray6 = new byte[n4];
        for (int i = 0; i < byArray3.length; i += n4) {
            mac.update(byArray4, 0, byArray4.length);
            mac.doFinal(byArray5, 0);
            byArray4 = byArray5;
            mac.update(byArray4, 0, byArray4.length);
            mac.update(byArray2, 0, byArray2.length);
            mac.doFinal(byArray6, 0);
            System.arraycopy(byArray6, 0, byArray3, i, Math.min(n4, byArray3.length - i));
        }
    }

    protected byte[] prf(int n, String string, byte[] byArray, int n2) throws GeneralSecurityException {
        if (0 == n) {
            return this.prf_SSL(byArray, n2);
        }
        byte[] byArray2 = Arrays.concatenate((byte[])Strings.toByteArray((String)string), (byte[])byArray);
        if (1 == n) {
            return this.prf_1_0(byArray2, n2);
        }
        return this.prf_1_2(n, byArray2, n2);
    }

    protected byte[] prf_SSL(byte[] byArray, int n) throws GeneralSecurityException {
        MessageDigest messageDigest = this.crypto.getHelper().createMessageDigest("MD5");
        MessageDigest messageDigest2 = this.crypto.getHelper().createMessageDigest("SHA-1");
        int n2 = messageDigest.getDigestLength();
        int n3 = messageDigest2.getDigestLength();
        byte[] byArray2 = new byte[Math.max(n2, n3)];
        byte[] byArray3 = new byte[n];
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n) {
            messageDigest2.update(SSL3_CONST, n5, n4);
            n5 += n4++;
            messageDigest2.update(this.data, 0, this.data.length);
            messageDigest2.update(byArray, 0, byArray.length);
            messageDigest2.digest(byArray2, 0, n3);
            messageDigest.update(this.data, 0, this.data.length);
            messageDigest.update(byArray2, 0, n3);
            int n7 = n - n6;
            if (n7 < n2) {
                messageDigest.digest(byArray2, 0, n2);
                System.arraycopy(byArray2, 0, byArray3, n6, n7);
                n6 += n7;
                continue;
            }
            messageDigest.digest(byArray3, n6, n2);
            n6 += n2;
        }
        return byArray3;
    }

    protected byte[] prf_1_0(byte[] byArray, int n) throws GeneralSecurityException {
        int n2 = (this.data.length + 1) / 2;
        byte[] byArray2 = new byte[n];
        this.hmacHash(1, this.data, 0, n2, byArray, byArray2);
        byte[] byArray3 = new byte[n];
        this.hmacHash(2, this.data, this.data.length - n2, n2, byArray, byArray3);
        for (int i = 0; i < n; ++i) {
            int n3 = i;
            byArray2[n3] = (byte)(byArray2[n3] ^ byArray3[i]);
        }
        return byArray2;
    }

    protected byte[] prf_1_2(int n, byte[] byArray, int n2) throws GeneralSecurityException {
        int n3 = TlsCryptoUtils.getHashForPRF(n);
        byte[] byArray2 = new byte[n2];
        this.hmacHash(n3, this.data, 0, this.data.length, byArray, byArray2);
        return byArray2;
    }

    protected synchronized void updateMac(Mac mac) {
        this.checkAlive();
        mac.update(this.data, 0, this.data.length);
    }
}

