/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.security.AlgorithmParameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import org.bouncycastle.jsse.provider.FipsUtils;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.PropertyUtils;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.tls.NamedGroup;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Integers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NamedGroupInfo {
    private static final Logger LOG = Logger.getLogger(NamedGroupInfo.class.getName());
    private static final String PROPERTY_NAMED_GROUPS = "jdk.tls.namedGroups";
    private static final int[] CANDIDATES_DEFAULT = new int[]{29, 30, 23, 24, 25, 31, 32, 33, 256, 257, 258};
    private final All all;
    private final AlgorithmParameters algorithmParameters;
    private final boolean enabled;

    static PerConnection createPerConnectionClient(PerContext perContext, ProvSSLParameters provSSLParameters, ProtocolVersion[] protocolVersionArray) {
        ProtocolVersion protocolVersion = ProtocolVersion.getLatestTLS(protocolVersionArray);
        ProtocolVersion protocolVersion2 = ProtocolVersion.getEarliestTLS(protocolVersionArray);
        return NamedGroupInfo.createPerConnection(perContext, provSSLParameters, protocolVersion2, protocolVersion);
    }

    static PerConnection createPerConnectionServer(PerContext perContext, ProvSSLParameters provSSLParameters, ProtocolVersion protocolVersion) {
        return NamedGroupInfo.createPerConnection(perContext, provSSLParameters, protocolVersion, protocolVersion);
    }

    private static PerConnection createPerConnection(PerContext perContext, ProvSSLParameters provSSLParameters, ProtocolVersion protocolVersion, ProtocolVersion protocolVersion2) {
        int n;
        String[] stringArray = provSSLParameters.getNamedGroups();
        int[] nArray = stringArray == null ? perContext.candidates : NamedGroupInfo.createCandidates(perContext.index, stringArray, "SSLParameters.namedGroups");
        BCAlgorithmConstraints bCAlgorithmConstraints = provSSLParameters.getAlgorithmConstraints();
        boolean bl = TlsUtils.isTLSv13(protocolVersion2);
        boolean bl2 = !TlsUtils.isTLSv13(protocolVersion);
        int n2 = nArray.length;
        LinkedHashMap<Integer, NamedGroupInfo> linkedHashMap = new LinkedHashMap<Integer, NamedGroupInfo>(n2);
        for (n = 0; n < n2; ++n) {
            Integer n3 = Integers.valueOf((int)nArray[n]);
            NamedGroupInfo namedGroupInfo = (NamedGroupInfo)perContext.index.get(n3);
            if (null == namedGroupInfo || !namedGroupInfo.isActive(bCAlgorithmConstraints, bl, bl2)) continue;
            linkedHashMap.put(n3, namedGroupInfo);
        }
        n = NamedGroupInfo.hasAnyECDSA(linkedHashMap) ? 1 : 0;
        return new PerConnection(linkedHashMap, n != 0);
    }

    static PerContext createPerContext(boolean bl, JcaTlsCrypto jcaTlsCrypto) {
        Map<Integer, NamedGroupInfo> map = NamedGroupInfo.createIndex(bl, jcaTlsCrypto);
        int[] nArray = NamedGroupInfo.createCandidatesFromProperty(map, PROPERTY_NAMED_GROUPS);
        return new PerContext(map, nArray);
    }

    static int getMaximumBitsServerECDH(PerConnection perConnection) {
        int n = 0;
        List<NamedGroupInfo> list = perConnection.getPeer();
        if (list != null) {
            for (NamedGroupInfo namedGroupInfo : list) {
                int n2 = namedGroupInfo.getBitsECDH();
                if (n2 <= n || !perConnection.local.containsKey(namedGroupInfo.getNamedGroup())) continue;
                n = n2;
            }
        } else {
            for (NamedGroupInfo namedGroupInfo : perConnection.local.values()) {
                n = Math.max(n, namedGroupInfo.getBitsECDH());
            }
        }
        return n;
    }

    static int getMaximumBitsServerFFDHE(PerConnection perConnection) {
        int n = 0;
        boolean bl = false;
        List<NamedGroupInfo> list = perConnection.getPeer();
        if (list != null) {
            for (NamedGroupInfo namedGroupInfo : list) {
                int n2 = namedGroupInfo.getNamedGroup();
                bl |= NamedGroup.isFiniteField(n2);
                int n3 = namedGroupInfo.getBitsFFDHE();
                if (n3 <= n || !perConnection.local.containsKey(n2)) continue;
                n = n3;
            }
        }
        if (!bl) {
            for (NamedGroupInfo namedGroupInfo : perConnection.local.values()) {
                n = Math.max(n, namedGroupInfo.getBitsFFDHE());
            }
        }
        return n;
    }

    static NamedGroupInfo getNamedGroup(PerContext perContext, int n) {
        return (NamedGroupInfo)perContext.index.get(n);
    }

    static Vector<Integer> getSupportedGroupsLocalClient(PerConnection perConnection) {
        return new Vector<Integer>(perConnection.local.keySet());
    }

    static int[] getSupportedGroupsLocalServer(PerConnection perConnection) {
        Set set = perConnection.local.keySet();
        int n = set.size();
        int n2 = 0;
        int[] nArray = new int[n];
        for (Integer n3 : set) {
            nArray[n2++] = n3;
        }
        return nArray;
    }

    static boolean hasAnyECDSALocal(PerConnection perConnection) {
        return perConnection.localECDSA;
    }

    static boolean hasLocal(PerConnection perConnection, int n) {
        return perConnection.local.containsKey(n);
    }

    static int selectServerECDH(PerConnection perConnection, int n) {
        List<NamedGroupInfo> list = perConnection.getPeer();
        if (list != null) {
            for (NamedGroupInfo namedGroupInfo : list) {
                if (namedGroupInfo.getBitsECDH() < n) continue;
                int n2 = namedGroupInfo.getNamedGroup();
                if (!perConnection.local.containsKey(n2)) continue;
                return n2;
            }
        } else {
            for (NamedGroupInfo namedGroupInfo : perConnection.local.values()) {
                if (namedGroupInfo.getBitsECDH() < n) continue;
                return namedGroupInfo.getNamedGroup();
            }
        }
        return -1;
    }

    static int selectServerFFDHE(PerConnection perConnection, int n) {
        boolean bl = false;
        List<NamedGroupInfo> list = perConnection.getPeer();
        if (list != null) {
            for (NamedGroupInfo namedGroupInfo : list) {
                int n2 = namedGroupInfo.getNamedGroup();
                bl |= NamedGroup.isFiniteField(n2);
                if (namedGroupInfo.getBitsFFDHE() < n || !perConnection.local.containsKey(n2)) continue;
                return n2;
            }
        }
        if (!bl) {
            for (NamedGroupInfo namedGroupInfo : perConnection.local.values()) {
                if (namedGroupInfo.getBitsFFDHE() < n) continue;
                return namedGroupInfo.getNamedGroup();
            }
        }
        return -1;
    }

    private static void addNamedGroup(boolean bl, JcaTlsCrypto jcaTlsCrypto, boolean bl2, boolean bl3, Map<Integer, NamedGroupInfo> map, All all) {
        int n = all.namedGroup;
        if (bl && !FipsUtils.isFipsNamedGroup(n)) {
            return;
        }
        boolean bl4 = bl2 && all.char2 || bl3 && all.bitsFFDHE > 0;
        boolean bl5 = !bl4 && null != all.jcaGroup && jcaTlsCrypto.hasNamedGroup(n);
        AlgorithmParameters algorithmParameters = null;
        if (bl5) {
            try {
                algorithmParameters = jcaTlsCrypto.getNamedGroupAlgorithmParameters(n);
            }
            catch (Exception exception) {
                bl5 = false;
            }
        }
        NamedGroupInfo namedGroupInfo = new NamedGroupInfo(all, algorithmParameters, bl5);
        if (null != map.put(n, namedGroupInfo)) {
            throw new IllegalStateException("Duplicate entries for NamedGroupInfo");
        }
    }

    private static int[] createCandidatesFromProperty(Map<Integer, NamedGroupInfo> map, String string) {
        String[] stringArray = PropertyUtils.getStringArraySystemProperty(string);
        if (null == stringArray) {
            return CANDIDATES_DEFAULT;
        }
        return NamedGroupInfo.createCandidates(map, stringArray, string);
    }

    private static int[] createCandidates(Map<Integer, NamedGroupInfo> map, String[] stringArray, String string) {
        int[] nArray = new int[stringArray.length];
        int n = 0;
        for (String string2 : stringArray) {
            int n2 = NamedGroupInfo.getNamedGroupByName(string2);
            if (n2 < 0) {
                LOG.warning("'" + string + "' contains unrecognised NamedGroup: " + string2);
                continue;
            }
            NamedGroupInfo namedGroupInfo = map.get(n2);
            if (null == namedGroupInfo) {
                LOG.warning("'" + string + "' contains unsupported NamedGroup: " + string2);
                continue;
            }
            if (!namedGroupInfo.isEnabled()) {
                LOG.warning("'" + string + "' contains disabled NamedGroup: " + string2);
                continue;
            }
            nArray[n++] = n2;
        }
        if (n < nArray.length) {
            nArray = Arrays.copyOf((int[])nArray, (int)n);
        }
        if (nArray.length < 1) {
            LOG.severe("'" + string + "' contained no usable NamedGroup values");
        }
        return nArray;
    }

    private static Map<Integer, NamedGroupInfo> createIndex(boolean bl, JcaTlsCrypto jcaTlsCrypto) {
        TreeMap<Integer, NamedGroupInfo> treeMap = new TreeMap<Integer, NamedGroupInfo>();
        boolean bl2 = PropertyUtils.getBooleanSystemProperty("org.bouncycastle.jsse.ec.disableChar2", false) || PropertyUtils.getBooleanSystemProperty("org.bouncycastle.ec.disable_f2m", false);
        boolean bl3 = !PropertyUtils.getBooleanSystemProperty("jsse.enableFFDHE", true);
        for (All all : All.values()) {
            NamedGroupInfo.addNamedGroup(bl, jcaTlsCrypto, bl2, bl3, treeMap, all);
        }
        return treeMap;
    }

    private static int getNamedGroupByName(String string) {
        for (All all : All.values()) {
            if (!all.name.equalsIgnoreCase(string)) continue;
            return all.namedGroup;
        }
        return -1;
    }

    private static List<NamedGroupInfo> getNamedGroupInfos(Map<Integer, NamedGroupInfo> map, int[] nArray) {
        if (nArray == null) {
            return null;
        }
        if (nArray.length < 1) {
            return Collections.emptyList();
        }
        int n = nArray.length;
        ArrayList<NamedGroupInfo> arrayList = new ArrayList<NamedGroupInfo>(n);
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            NamedGroupInfo namedGroupInfo = map.get(n2);
            if (null == namedGroupInfo) continue;
            arrayList.add(namedGroupInfo);
        }
        if (arrayList.isEmpty()) {
            return Collections.emptyList();
        }
        arrayList.trimToSize();
        return arrayList;
    }

    private static boolean hasAnyECDSA(Map<Integer, NamedGroupInfo> map) {
        for (NamedGroupInfo namedGroupInfo : map.values()) {
            if (!NamedGroup.refersToAnECDSACurve(namedGroupInfo.getNamedGroup())) continue;
            return true;
        }
        return false;
    }

    NamedGroupInfo(All all, AlgorithmParameters algorithmParameters, boolean bl) {
        this.all = all;
        this.algorithmParameters = algorithmParameters;
        this.enabled = bl;
    }

    int getBitsECDH() {
        return this.all.bitsECDH;
    }

    int getBitsFFDHE() {
        return this.all.bitsFFDHE;
    }

    String getJcaAlgorithm() {
        return this.all.jcaAlgorithm;
    }

    String getJcaGroup() {
        return this.all.jcaGroup;
    }

    int getNamedGroup() {
        return this.all.namedGroup;
    }

    boolean isActive(BCAlgorithmConstraints bCAlgorithmConstraints, boolean bl, boolean bl2) {
        return this.enabled && (bl && this.isSupportedPost13() || bl2 && this.isSupportedPre13()) && this.isPermittedBy(bCAlgorithmConstraints);
    }

    boolean isEnabled() {
        return this.enabled;
    }

    boolean isSupportedPost13() {
        return this.all.supportedPost13;
    }

    boolean isSupportedPre13() {
        return this.all.supportedPre13;
    }

    public String toString() {
        return this.all.text;
    }

    private boolean isPermittedBy(BCAlgorithmConstraints bCAlgorithmConstraints) {
        Set<BCCryptoPrimitive> set = JsseUtils.KEY_AGREEMENT_CRYPTO_PRIMITIVES_BC;
        return bCAlgorithmConstraints.permits(set, this.getJcaGroup(), null) && bCAlgorithmConstraints.permits(set, this.getJcaAlgorithm(), this.algorithmParameters);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum All {
        sect163k1(1, "EC"),
        sect163r1(2, "EC"),
        sect163r2(3, "EC"),
        sect193r1(4, "EC"),
        sect193r2(5, "EC"),
        sect233k1(6, "EC"),
        sect233r1(7, "EC"),
        sect239k1(8, "EC"),
        sect283k1(9, "EC"),
        sect283r1(10, "EC"),
        sect409k1(11, "EC"),
        sect409r1(12, "EC"),
        sect571k1(13, "EC"),
        sect571r1(14, "EC"),
        secp160k1(15, "EC"),
        secp160r1(16, "EC"),
        secp160r2(17, "EC"),
        secp192k1(18, "EC"),
        secp192r1(19, "EC"),
        secp224k1(20, "EC"),
        secp224r1(21, "EC"),
        secp256k1(22, "EC"),
        secp256r1(23, "EC"),
        secp384r1(24, "EC"),
        secp521r1(25, "EC"),
        brainpoolP256r1(26, "EC"),
        brainpoolP384r1(27, "EC"),
        brainpoolP512r1(28, "EC"),
        x25519(29, "XDH"),
        x448(30, "XDH"),
        brainpoolP256r1tls13(31, "EC"),
        brainpoolP384r1tls13(32, "EC"),
        brainpoolP512r1tls13(33, "EC"),
        curveSM2(41, "EC"),
        ffdhe2048(256, "DiffieHellman"),
        ffdhe3072(257, "DiffieHellman"),
        ffdhe4096(258, "DiffieHellman"),
        ffdhe6144(259, "DiffieHellman"),
        ffdhe8192(260, "DiffieHellman"),
        OQS_mlkem512(583, "ML-KEM"),
        OQS_mlkem768(584, "ML-KEM"),
        OQS_mlkem1024(585, "ML-KEM"),
        DRAFT_mlkem768(1896, "ML-KEM"),
        DRAFT_mlkem1024(4132, "ML-KEM");

        private final int namedGroup;
        private final String name;
        private final String text;
        private final String jcaAlgorithm;
        private final String jcaGroup;
        private final boolean char2;
        private final boolean supportedPost13;
        private final boolean supportedPre13;
        private final int bitsECDH;
        private final int bitsFFDHE;

        private All(int n2, String string2) {
            this.namedGroup = n2;
            this.name = NamedGroup.getName(n2);
            this.text = NamedGroup.getText(n2);
            this.jcaAlgorithm = string2;
            this.jcaGroup = NamedGroup.getStandardName(n2);
            this.supportedPost13 = NamedGroup.canBeNegotiated(n2, ProtocolVersion.TLSv13);
            this.supportedPre13 = NamedGroup.canBeNegotiated(n2, ProtocolVersion.TLSv12);
            this.char2 = NamedGroup.isChar2Curve(n2);
            this.bitsECDH = NamedGroup.getCurveBits(n2);
            this.bitsFFDHE = NamedGroup.getFiniteFieldBits(n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PerConnection {
        private final LinkedHashMap<Integer, NamedGroupInfo> local;
        private final boolean localECDSA;
        private final AtomicReference<List<NamedGroupInfo>> peer;

        PerConnection(LinkedHashMap<Integer, NamedGroupInfo> linkedHashMap, boolean bl) {
            if (linkedHashMap == null) {
                throw new NullPointerException("local");
            }
            this.local = linkedHashMap;
            this.localECDSA = bl;
            this.peer = new AtomicReference();
        }

        List<NamedGroupInfo> getPeer() {
            return this.peer.get();
        }

        void notifyPeerData(int[] nArray) {
            List list = NamedGroupInfo.getNamedGroupInfos(this.local, nArray);
            this.peer.set(list);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PerContext {
        private final Map<Integer, NamedGroupInfo> index;
        private final int[] candidates;

        PerContext(Map<Integer, NamedGroupInfo> map, int[] nArray) {
            this.index = map;
            this.candidates = nArray;
        }
    }
}

