/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.cdi.impl.annotation;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.camunda.bpm.engine.cdi.BusinessProcess;
import org.camunda.bpm.engine.cdi.ProcessEngineCdiException;
import org.camunda.bpm.engine.cdi.annotation.CompleteTask;

@Interceptor
@CompleteTask
public class CompleteTaskInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    BusinessProcess businessProcess;

    @AroundInvoke
    public Object invoke(InvocationContext ctx) throws Exception {
        try {
            Object result = ctx.proceed();
            CompleteTask completeTaskAnnotation = ctx.getMethod().getAnnotation(CompleteTask.class);
            boolean endConversation = completeTaskAnnotation.endConversation();
            this.businessProcess.completeTask(endConversation);
            return result;
        }
        catch (InvocationTargetException e) {
            throw new ProcessEngineCdiException("Error while completing task: " + e.getCause().getMessage(), e.getCause());
        }
    }
}

