/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.application;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import org.camunda.bpm.application.ProcessApplication;
import org.camunda.bpm.application.ProcessApplicationExecutionException;
import org.camunda.bpm.application.ProcessApplicationInterface;
import org.camunda.bpm.application.impl.DefaultElResolverLookup;
import org.camunda.bpm.container.RuntimeContainerDelegate;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.javax.el.ELResolver;
import org.camunda.bpm.engine.impl.util.ClassLoaderUtil;
import org.camunda.bpm.engine.repository.DeploymentBuilder;

public abstract class AbstractProcessApplication
implements ProcessApplicationInterface {
    private static final Logger LOGGER = Logger.getLogger(AbstractProcessApplication.class.getName());
    protected ELResolver processApplicationElResolver;
    protected boolean isDeployed = false;

    @Override
    public void deploy() {
        if (this.isDeployed) {
            LOGGER.warning("Calling deploy() on process application that is already deployed.");
        } else {
            RuntimeContainerDelegate.INSTANCE.get().deployProcessApplication(this);
            this.isDeployed = true;
        }
    }

    @Override
    public void undeploy() {
        if (!this.isDeployed) {
            LOGGER.fine("Calling undeploy() on process application that is already undeployed.");
        } else {
            RuntimeContainerDelegate.INSTANCE.get().undeployProcessApplication(this);
            this.isDeployed = false;
        }
    }

    @Override
    public void createDeployment(String processArchiveName, DeploymentBuilder deploymentBuilder) {
    }

    @Override
    public String getName() {
        Class<?> processApplicationClass = this.getClass();
        String name = null;
        ProcessApplication annotation = processApplicationClass.getAnnotation(ProcessApplication.class);
        if (annotation != null) {
            name = annotation.value();
        }
        if (name == null || name.length() == 0) {
            name = this.autodetectProcessApplicationName();
        }
        return name;
    }

    protected abstract String autodetectProcessApplicationName();

    @Override
    public <T> T execute(Callable<T> callable) throws ProcessApplicationExecutionException {
        ClassLoader originalClassloader = ClassLoaderUtil.getContextClassloader();
        ClassLoader processApplicationClassloader = this.getProcessApplicationClassloader();
        try {
            ClassLoaderUtil.setContextClassloader(processApplicationClassloader);
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new ProcessApplicationExecutionException(e);
        }
        finally {
            ClassLoaderUtil.setContextClassloader(originalClassloader);
        }
    }

    @Override
    public ClassLoader getProcessApplicationClassloader() {
        return ClassLoaderUtil.getClassloader(this.getClass());
    }

    @Override
    public ProcessApplicationInterface getRawObject() {
        return this;
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ELResolver getElResolver() {
        if (this.processApplicationElResolver == null) {
            AbstractProcessApplication abstractProcessApplication = this;
            synchronized (abstractProcessApplication) {
                if (this.processApplicationElResolver == null) {
                    this.processApplicationElResolver = this.initProcessApplicationElResolver();
                }
            }
        }
        return this.processApplicationElResolver;
    }

    protected ELResolver initProcessApplicationElResolver() {
        return DefaultElResolverLookup.lookupResolver(this);
    }

    @Override
    public ExecutionListener getExecutionListener() {
        return null;
    }

    @Override
    public TaskListener getTaskListener() {
        return null;
    }
}

