/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.container.impl.jmx.deployment.scanning;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.container.impl.jmx.deployment.scanning.ProcessApplicationScanningUtil;
import org.camunda.bpm.container.impl.jmx.deployment.scanning.spi.ProcessApplicationScanner;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.util.IoUtil;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;

public class VfsProcessApplicationScanner
implements ProcessApplicationScanner {
    private static Logger log = Logger.getLogger(VfsProcessApplicationScanner.class.getName());

    @Override
    public Map<String, byte[]> findResources(ClassLoader classLoader, String resourceRootPath, URL processesXml) {
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        if (resourceRootPath != null && !resourceRootPath.startsWith("pa:")) {
            String strippedPath = resourceRootPath.replace("classpath:", "");
            Enumeration<URL> resourceRoots = this.loadClasspathResourceRoots(classLoader, strippedPath);
            if (!resourceRoots.hasMoreElements()) {
                log.warning("Could not find any resources for process archive resource root path '" + resourceRootPath + "' using classloader '" + classLoader + "'");
            }
            while (resourceRoots.hasMoreElements()) {
                URL resourceRoot = resourceRoots.nextElement();
                VirtualFile virtualRoot = this.getVirtualFileForUrl(resourceRoot);
                this.scanRoot(virtualRoot, resources);
            }
        } else if (processesXml != null) {
            VirtualFile virtualFile = this.getVirtualFileForUrl(processesXml);
            VirtualFile resourceRoot = virtualFile.getParent().getParent();
            if (resourceRootPath != null) {
                String strippedPath = resourceRootPath.replace("pa:", "");
                resourceRoot = resourceRoot.getChild(strippedPath);
            }
            this.scanRoot(resourceRoot, resources);
        }
        return resources;
    }

    protected VirtualFile getVirtualFileForUrl(URL url) {
        try {
            return VFS.getChild((URI)url.toURI());
        }
        catch (URISyntaxException e) {
            throw new ProcessEngineException("Could not load virtual filefor url " + url, e);
        }
    }

    protected void scanRoot(VirtualFile processArchiveRoot, Map<String, byte[]> resources) {
        try {
            List processes = processArchiveRoot.getChildrenRecursively(new VirtualFileFilter(){

                public boolean accepts(VirtualFile file) {
                    return file.isFile() && ProcessApplicationScanningUtil.isDeployable(file.getName());
                }
            });
            for (final VirtualFile process : processes) {
                this.addResource(process, processArchiveRoot, resources);
                List diagrams = process.getParent().getChildren(new VirtualFileFilter(){

                    public boolean accepts(VirtualFile file) {
                        return ProcessApplicationScanningUtil.isDiagramForProcess(file.getName(), process.getName());
                    }
                });
                for (VirtualFile diagram : diagrams) {
                    this.addResource(diagram, processArchiveRoot, resources);
                }
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Could not scan VFS root: " + processArchiveRoot, e);
        }
    }

    private void addResource(VirtualFile virtualFile, VirtualFile processArchiveRoot, Map<String, byte[]> resources) {
        String resourceName = virtualFile.getPathNameRelativeTo(processArchiveRoot);
        try {
            InputStream inputStream = virtualFile.openStream();
            byte[] bytes = IoUtil.readInputStream(inputStream, resourceName);
            IoUtil.closeSilently(inputStream);
            resources.put(resourceName, bytes);
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Could not read input stream of file '" + resourceName + "' from process archive '" + processArchiveRoot + "'.", e);
        }
    }

    protected Enumeration<URL> loadClasspathResourceRoots(ClassLoader classLoader, String strippedPaResourceRootPath) {
        Enumeration<URL> resourceRoots;
        try {
            resourceRoots = classLoader.getResources(strippedPaResourceRootPath);
        }
        catch (IOException e) {
            throw new ProcessEngineException("Could not load resources at '" + strippedPaResourceRootPath + "' using classloaded '" + classLoader + "'", e);
        }
        return resourceRoots;
    }
}

