/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.helper;

import java.util.List;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.impl.bpmn.behavior.EventSubProcessStartEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.parser.ErrorEventDefinition;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmActivity;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.PvmScope;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;

public class ErrorPropagation {
    private static final Logger LOG = Logger.getLogger(ErrorPropagation.class.getName());

    public static void propagateException(Exception ex, ActivityExecution execution) throws Exception {
        if (ex instanceof ProcessEngineException && ex.getCause() == null) {
            throw ex;
        }
        ErrorPropagation.propagateError(null, ex, execution);
    }

    public static void propagateError(BpmnError error, ActivityExecution execution) throws Exception {
        ErrorPropagation.propagateError(error.getErrorCode(), null, execution);
    }

    public static void propagateError(String errorCode, Exception origException, ActivityExecution execution) throws Exception {
        String eventHandlerId = ErrorPropagation.findLocalErrorEventHandler(execution, errorCode, origException);
        if (eventHandlerId != null) {
            ErrorPropagation.executeCatch(eventHandlerId, execution);
        } else {
            ActivityExecution superExecution = ErrorPropagation.getSuperExecution(execution);
            if (superExecution != null) {
                ErrorPropagation.executeCatchInSuperProcess(errorCode, origException, superExecution);
            } else if (origException == null) {
                LOG.info(execution.getActivity().getId() + " throws error event with errorCode '" + errorCode + "', but no catching boundary event was defined. " + "Execution will simply be ended (none end event semantics).");
                execution.end(true);
            } else {
                throw origException;
            }
        }
    }

    private static String findLocalErrorEventHandler(ActivityExecution execution, String errorCode, Exception origException) {
        PvmScope scope = execution.getActivity();
        while (scope != null) {
            List definitions = (List)scope.getProperty("errorEventDefinitions");
            if (definitions != null) {
                for (ErrorEventDefinition errorEventDefinition : definitions) {
                    if (!(origException != null ? errorEventDefinition.catchesException(origException) : errorEventDefinition.catchesError(errorCode))) continue;
                    return errorEventDefinition.getHandlerActivityId();
                }
            }
            if (scope instanceof PvmActivity) {
                scope = scope.getParent();
                continue;
            }
            scope = null;
        }
        return null;
    }

    private static void executeCatchInSuperProcess(String errorCode, Exception origException, ActivityExecution superExecution) throws Exception {
        String errorHandlerId = ErrorPropagation.findLocalErrorEventHandler(superExecution, errorCode, origException);
        if (errorHandlerId != null) {
            ErrorPropagation.executeCatch(errorHandlerId, superExecution);
        } else {
            ActivityExecution superSuperExecution = ErrorPropagation.getSuperExecution(superExecution);
            if (superSuperExecution != null) {
                ErrorPropagation.executeCatchInSuperProcess(errorCode, origException, superSuperExecution);
            } else {
                if (origException == null) {
                    throw new BpmnError(errorCode, "No catching boundary event found for error with errorCode '" + errorCode + "', neither in same process nor in parent process");
                }
                throw origException;
            }
        }
    }

    private static ActivityExecution getSuperExecution(ActivityExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        ExecutionEntity superExecution = executionEntity.getProcessInstance().getSuperExecution();
        if (superExecution != null && !superExecution.isScope()) {
            return superExecution.getParent();
        }
        return superExecution;
    }

    private static void executeCatch(String errorHandlerId, ActivityExecution execution) {
        ActivityImpl catchingScopeActivity;
        ProcessDefinitionImpl processDefinition = ((ExecutionEntity)execution).getProcessDefinition();
        ActivityImpl errorHandler = processDefinition.findActivity(errorHandlerId);
        if (errorHandler == null) {
            throw new ProcessEngineException(errorHandlerId + " not found in process definition");
        }
        boolean matchingParentFound = false;
        ActivityExecution leavingExecution = execution;
        ActivityImpl currentActivity = (ActivityImpl)execution.getActivity();
        ScopeImpl catchingScope = errorHandler.getParent();
        if (catchingScope instanceof ActivityImpl && !(catchingScopeActivity = (ActivityImpl)catchingScope).isScope()) {
            catchingScope = catchingScopeActivity.getParent();
        }
        if (catchingScope instanceof PvmProcessDefinition) {
            ErrorPropagation.executeEventHandler(errorHandler, ((ExecutionEntity)execution).getProcessInstance());
        } else {
            if (currentActivity.getId().equals(catchingScope.getId())) {
                matchingParentFound = true;
            } else {
                currentActivity = (ActivityImpl)currentActivity.getParent();
                while (!matchingParentFound && leavingExecution != null && currentActivity != null) {
                    if (!leavingExecution.isConcurrent() && currentActivity.getId().equals(catchingScope.getId())) {
                        matchingParentFound = true;
                        continue;
                    }
                    if (leavingExecution.isConcurrent()) {
                        leavingExecution = leavingExecution.getParent();
                        continue;
                    }
                    currentActivity = currentActivity.getParentActivity();
                    leavingExecution = leavingExecution.getParent();
                }
                while (leavingExecution != null && leavingExecution.getParent() != null && leavingExecution.getParent().getActivity() != null && leavingExecution.getParent().getActivity().getId().equals(catchingScope.getId())) {
                    leavingExecution = leavingExecution.getParent();
                }
            }
            if (matchingParentFound && leavingExecution != null) {
                ErrorPropagation.executeEventHandler(errorHandler, leavingExecution);
            } else {
                throw new ProcessEngineException("No matching parent execution for activity " + errorHandlerId + " found");
            }
        }
    }

    private static void executeEventHandler(ActivityImpl borderEventActivity, ActivityExecution leavingExecution) {
        if (borderEventActivity.getActivityBehavior() instanceof EventSubProcessStartEventActivityBehavior) {
            leavingExecution.executeActivity(borderEventActivity.getParentActivity());
        } else {
            leavingExecution.executeActivity(borderEventActivity);
        }
    }
}

