/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;

public abstract class AddIdentityLinkCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String userId;
    protected String groupId;
    protected String type;
    protected String taskId;
    protected TaskEntity task;

    public AddIdentityLinkCmd(String taskId, String userId, String groupId, String type) {
        this.validateParams(userId, groupId, type, taskId);
        this.taskId = taskId;
        this.userId = userId;
        this.groupId = groupId;
        this.type = type;
    }

    protected void validateParams(String userId, String groupId, String type, String taskId) {
        if (taskId == null) {
            throw new ProcessEngineException("taskId is null");
        }
        if (type == null) {
            throw new ProcessEngineException("type is required when adding a new task identity link");
        }
        if ("assignee".equals(type)) {
            if (groupId != null) {
                throw new ProcessEngineException("Incompatible usage: cannot use ASSIGNEE together with a groupId");
            }
        } else if (userId == null && groupId == null) {
            throw new ProcessEngineException("userId and groupId cannot both be null");
        }
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.taskId == null) {
            throw new ProcessEngineException("taskId is null");
        }
        this.task = commandContext.getTaskManager().findTaskById(this.taskId);
        if (this.task == null) {
            throw new ProcessEngineException("Cannot find task with id " + this.taskId);
        }
        if ("assignee".equals(this.type)) {
            this.task.setAssignee(this.userId);
        } else if ("owner".equals(this.type)) {
            this.task.setOwner(this.userId);
        } else {
            this.task.addIdentityLink(this.userId, this.groupId, this.type);
        }
        return null;
    }
}

