/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityInfoEntity;

public class DeleteUserPictureCmd
implements Command<Void> {
    protected String userId;

    public DeleteUserPictureCmd(String userId) {
        this.userId = userId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.userId == null) {
            throw new ProcessEngineException("UserId cannot be null.");
        }
        IdentityInfoEntity infoEntity = commandContext.getIdentityInfoManager().findUserInfoByUserIdAndKey(this.userId, "picture");
        if (infoEntity != null) {
            String byteArrayId = infoEntity.getValue();
            if (byteArrayId != null) {
                commandContext.getByteArrayManager().deleteByteArrayById(byteArrayId);
            }
            commandContext.getIdentityInfoManager().delete(infoEntity);
        }
        return null;
    }
}

