/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.List;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityLinkEntity;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.task.IdentityLink;

public class GetIdentityLinksForTaskCmd
implements Command<List<IdentityLink>>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;

    public GetIdentityLinksForTaskCmd(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public List<IdentityLink> execute(CommandContext commandContext) {
        IdentityLinkEntity identityLink;
        TaskEntity task = Context.getCommandContext().getTaskManager().findTaskById(this.taskId);
        List<IdentityLinkEntity> identityLinks = task.getIdentityLinks();
        if (task.getAssignee() != null) {
            identityLink = new IdentityLinkEntity();
            identityLink.setUserId(task.getAssignee());
            identityLink.setType("assignee");
            identityLinks.add(identityLink);
        }
        if (task.getOwner() != null) {
            identityLink = new IdentityLinkEntity();
            identityLink.setUserId(task.getOwner());
            identityLink.setType("owner");
            identityLinks.add(identityLink);
        }
        return task.getIdentityLinks();
    }
}

