/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.form.TaskFormData;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.form.handler.TaskFormHandler;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;

public class GetTaskFormCmd
implements Command<TaskFormData>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String taskId;

    public GetTaskFormCmd(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public TaskFormData execute(CommandContext commandContext) {
        TaskEntity task = Context.getCommandContext().getTaskManager().findTaskById(this.taskId);
        if (task == null) {
            throw new ProcessEngineException("No task found for taskId '" + this.taskId + "'");
        }
        if (task.getTaskDefinition() != null) {
            TaskFormHandler taskFormHandler = task.getTaskDefinition().getTaskFormHandler();
            if (taskFormHandler == null) {
                throw new ProcessEngineException("No taskFormHandler specified for task '" + this.taskId + "'");
            }
            return taskFormHandler.createTaskForm(task);
        }
        return null;
    }
}

