/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationEntity;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;

public class SaveAuthorizationCmd
implements Command<Authorization> {
    protected AuthorizationEntity authorization;

    public SaveAuthorizationCmd(Authorization authorization) {
        this.authorization = (AuthorizationEntity)authorization;
        this.validate();
    }

    protected void validate() {
        if (this.authorization.getUserId() == null && this.authorization.getGroupId() == null) {
            throw new ProcessEngineException("Authorization must either have a 'userId' or a 'groupId'.");
        }
        if (this.authorization.getUserId() != null && this.authorization.getGroupId() != null) {
            throw new ProcessEngineException("Authorization cannot define 'userId' or a 'groupId' at the same time.");
        }
        if (this.authorization.getResource() == null) {
            throw new ProcessEngineException("Authorization 'resourceType' cannot be null.");
        }
    }

    @Override
    public Authorization execute(CommandContext commandContext) {
        AuthorizationManager authorizationManager = commandContext.getAuthorizationManager();
        if (this.authorization.getId() == null) {
            authorizationManager.insert(this.authorization);
        } else {
            authorizationManager.update(this.authorization);
        }
        return this.authorization;
    }
}

