/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.form.type;

import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.form.type.AbstractFormFieldType;

public class DateFormType
extends AbstractFormFieldType {
    protected String datePattern;
    protected Format dateFormat;

    public DateFormType(String datePattern) {
        this.datePattern = datePattern;
        this.dateFormat = new SimpleDateFormat(datePattern);
    }

    @Override
    public String getName() {
        return "date";
    }

    @Override
    public Object getInformation(String key) {
        if ("datePattern".equals(key)) {
            return this.datePattern;
        }
        return null;
    }

    @Override
    public Object convertFormValueToModelValue(Object propertyValue) {
        if (propertyValue == null || "".equals(propertyValue)) {
            return null;
        }
        try {
            return this.dateFormat.parseObject(propertyValue.toString());
        }
        catch (ParseException e) {
            throw new ProcessEngineException("invalid date value " + propertyValue);
        }
    }

    @Override
    public String convertModelValueToFormValue(Object modelValue) {
        if (modelValue == null) {
            return null;
        }
        return this.dateFormat.format(modelValue);
    }
}

