/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.form.validator;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParse;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.impl.form.validator.DelegateFormFieldValidator;
import org.camunda.bpm.engine.impl.form.validator.FormFieldValidator;
import org.camunda.bpm.engine.impl.util.xml.Element;

public class FormValidators {
    protected Map<String, Class<? extends FormFieldValidator>> validators = new HashMap<String, Class<? extends FormFieldValidator>>();

    /*
     * Enabled aggressive block sorting
     */
    public FormFieldValidator createValidator(Element constraint, BpmnParse bpmnParse, ExpressionManager expressionManager) {
        String name = constraint.attribute("name");
        String config = constraint.attribute("config");
        if ("validator".equals(name)) {
            if (config == null || config.isEmpty()) {
                bpmnParse.addError("validator configuration needs to provide either a fully qualified classname or an expression resolving to a custom FormFieldValidator implementation.", constraint);
                return null;
            }
            if (!config.startsWith("$")) {
                if (!config.startsWith("#")) return new DelegateFormFieldValidator(config);
            }
            Expression validatorExpression = expressionManager.createExpression(config);
            return new DelegateFormFieldValidator(validatorExpression);
        }
        Class<? extends FormFieldValidator> validator = this.validators.get(name);
        if (validator != null) {
            return this.createValidatorInstance(validator);
        }
        bpmnParse.addError("Cannot find validator implementation for name '" + name + "'.", constraint);
        return null;
    }

    protected FormFieldValidator createValidatorInstance(Class<? extends FormFieldValidator> validator) {
        try {
            return validator.newInstance();
        }
        catch (InstantiationException e) {
            throw new ProcessEngineException("Could not instantiate validator", e);
        }
        catch (IllegalAccessException e) {
            throw new ProcessEngineException("Could not instantiate validator", e);
        }
    }

    public void addValidator(String name, Class<? extends FormFieldValidator> validatorType) {
        this.validators.put(name, validatorType);
    }

    public Map<String, Class<? extends FormFieldValidator>> getValidators() {
        return this.validators;
    }
}

