/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.history.producer;

import java.util.ArrayList;
import java.util.List;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.history.IncidentState;
import org.camunda.bpm.engine.history.UserOperationLogContext;
import org.camunda.bpm.engine.impl.cfg.IdGenerator;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.history.event.HistoricActivityInstanceEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricFormPropertyEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricIncidentEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricTaskInstanceEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricVariableUpdateEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.UserOperationLogEntryEventEntity;
import org.camunda.bpm.engine.impl.history.producer.HistoryEventProducer;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyChange;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.persistence.entity.VariableInstanceEntity;
import org.camunda.bpm.engine.impl.pvm.PvmScope;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Incident;

public class DefaultHistoryEventProducer
implements HistoryEventProducer {
    protected void initActivityInstanceEvent(HistoricActivityInstanceEventEntity evt, ExecutionEntity execution, String eventType) {
        String activityId = execution.getActivityId();
        String activityInstanceId = execution.getActivityInstanceId();
        String parentActivityInstanceId = execution.getParentActivityInstanceId();
        evt.setId(activityInstanceId);
        evt.setEventType(eventType);
        evt.setActivityInstanceId(activityInstanceId);
        evt.setParentActivityInstanceId(parentActivityInstanceId);
        evt.setProcessDefinitionId(execution.getProcessDefinitionId());
        evt.setProcessInstanceId(execution.getProcessInstanceId());
        evt.setExecutionId(execution.getId());
        PvmScope eventSource = null;
        eventSource = activityId != null ? execution.getActivity() : (PvmScope)execution.getEventSource();
        evt.setActivityId(eventSource.getId());
        evt.setActivityName((String)eventSource.getProperty("name"));
        evt.setActivityType((String)eventSource.getProperty("type"));
    }

    protected void initProcessInstanceEvent(HistoricProcessInstanceEventEntity evt, ExecutionEntity execution, String eventType) {
        String processDefinitionId = execution.getProcessDefinitionId();
        String processInstanceId = execution.getProcessInstanceId();
        String executionId = execution.getId();
        evt.setId(processInstanceId);
        evt.setEventType(eventType);
        evt.setProcessDefinitionId(processDefinitionId);
        evt.setProcessInstanceId(processInstanceId);
        evt.setExecutionId(executionId);
        evt.setBusinessKey(execution.getProcessBusinessKey());
    }

    protected void initTaskInstanceEvent(HistoricTaskInstanceEventEntity evt, TaskEntity taskEntity, String eventType) {
        String processDefinitionId = taskEntity.getProcessDefinitionId();
        String processInstanceId = taskEntity.getProcessInstanceId();
        String executionId = taskEntity.getExecutionId();
        evt.setId(taskEntity.getId());
        evt.setEventType(eventType);
        evt.setTaskId(taskEntity.getId());
        evt.setProcessDefinitionId(processDefinitionId);
        evt.setProcessInstanceId(processInstanceId);
        evt.setExecutionId(executionId);
        evt.setAssignee(taskEntity.getAssignee());
        evt.setDescription(taskEntity.getDescription());
        evt.setDueDate(taskEntity.getDueDate());
        evt.setFollowUpDate(taskEntity.getFollowUpDate());
        evt.setName(taskEntity.getName());
        evt.setOwner(taskEntity.getOwner());
        evt.setParentTaskId(taskEntity.getParentTaskId());
        evt.setPriority(taskEntity.getPriority());
        evt.setTaskDefinitionKey(taskEntity.getTaskDefinitionKey());
        ExecutionEntity execution = taskEntity.getExecution();
        if (execution != null) {
            evt.setActivityInstanceId(execution.getActivityInstanceId());
        }
    }

    protected void initHistoricVariableUpdateEvt(HistoricVariableUpdateEventEntity evt, VariableInstanceEntity variableInstance, String eventType) {
        evt.setEventType(eventType);
        evt.setTimestamp(ClockUtil.getCurrentTime());
        evt.setVariableInstanceId(variableInstance.getId());
        evt.setProcessInstanceId(variableInstance.getProcessInstanceId());
        evt.setExecutionId(variableInstance.getExecutionId());
        evt.setTaskId(variableInstance.getTaskId());
        evt.setRevision(variableInstance.getRevision());
        evt.setVariableName(variableInstance.getName());
        evt.setVariableTypeName(variableInstance.getType().getTypeName());
        evt.setTextValue(variableInstance.getTextValue());
        evt.setTextValue2(variableInstance.getTextValue2());
        evt.setDoubleValue(variableInstance.getDoubleValue());
        evt.setLongValue(variableInstance.getLongValue());
        if (variableInstance.getByteArrayValueId() != null) {
            ByteArrayEntity byteArrayValue = variableInstance.getByteArrayValue();
            evt.setByteValue(byteArrayValue.getBytes());
        }
    }

    protected void initUserOperationLogEvent(UserOperationLogEntryEventEntity evt, UserOperationLogContext context, PropertyChange propertyChange) {
        evt.setEntityType(context.getEntityType());
        evt.setOperationType(context.getOperationType());
        evt.setOperationId(context.getOperationId());
        evt.setUserId(context.getUserId());
        evt.setProcessDefinitionId(context.getProcessDefinitionId());
        evt.setProcessInstanceId(context.getProcessInstanceId());
        evt.setExecutionId(context.getExecutionId());
        evt.setTaskId(context.getTaskId());
        evt.setTimestamp(ClockUtil.getCurrentTime());
        evt.setProperty(propertyChange.getPropertyName());
        evt.setOrgValue(propertyChange.getOrgValueString());
        evt.setNewValue(propertyChange.getNewValueString());
    }

    protected void initHistoricIncidentEvent(HistoricIncidentEventEntity evt, Incident incident, String eventType) {
        evt.setId(incident.getId());
        evt.setProcessDefinitionId(incident.getProcessDefinitionId());
        evt.setProcessInstanceId(incident.getProcessInstanceId());
        evt.setExecutionId(incident.getExecutionId());
        evt.setCreateTime(incident.getIncidentTimestamp());
        evt.setIncidentType(incident.getIncidentType());
        evt.setActivityId(incident.getActivityId());
        evt.setCauseIncidentId(incident.getCauseIncidentId());
        evt.setRootCauseIncidentId(incident.getRootCauseIncidentId());
        evt.setConfiguration(incident.getConfiguration());
        evt.setIncidentMessage(incident.getIncidentMessage());
        evt.setEventType(eventType);
        IncidentState incidentState = IncidentState.DEFAULT;
        if ("delete".equals(eventType)) {
            incidentState = IncidentState.DELETED;
        } else if ("resolve".equals(eventType)) {
            incidentState = IncidentState.RESOLVED;
        }
        evt.setIncidentState(incidentState.getStateCode());
    }

    protected HistoryEvent createHistoricVariableEvent(VariableInstanceEntity variableInstance, VariableScope sourceVariableScope, String eventType) {
        String scopeActivityInstanceId = null;
        String sourceActivityInstanceId = null;
        if (variableInstance.getExecutionId() != null) {
            ExecutionEntity scopeExecution = Context.getCommandContext().getDbSqlSession().selectById(ExecutionEntity.class, variableInstance.getExecutionId());
            scopeActivityInstanceId = variableInstance.getTaskId() == null && scopeExecution.isScope() && (scopeExecution.isActive() || !scopeExecution.isActive() && scopeExecution.getActivityId() == null) ? scopeExecution.getParentActivityInstanceId() : scopeExecution.getActivityInstanceId();
        }
        ExecutionEntity sourceExecution = null;
        if (sourceVariableScope instanceof ExecutionEntity) {
            sourceExecution = (ExecutionEntity)sourceVariableScope;
            sourceActivityInstanceId = sourceExecution.getActivityInstanceId();
        } else if (sourceVariableScope instanceof TaskEntity && (sourceExecution = ((TaskEntity)sourceVariableScope).getExecution()) != null) {
            sourceActivityInstanceId = sourceExecution.getActivityInstanceId();
        }
        HistoricVariableUpdateEventEntity evt = this.newVariableUpdateEventEntity(sourceExecution);
        this.initHistoricVariableUpdateEvt(evt, variableInstance, eventType);
        evt.setScopeActivityInstanceId(scopeActivityInstanceId);
        evt.setActivityInstanceId(sourceActivityInstanceId);
        return evt;
    }

    protected HistoricProcessInstanceEventEntity newProcessInstanceEventEntity(ExecutionEntity execution) {
        return new HistoricProcessInstanceEventEntity();
    }

    protected HistoricActivityInstanceEventEntity newActivityInstanceEventEntity(ExecutionEntity execution) {
        return new HistoricActivityInstanceEventEntity();
    }

    protected HistoricTaskInstanceEventEntity newTaskInstanceEventEntity(DelegateTask task) {
        return new HistoricTaskInstanceEventEntity();
    }

    protected HistoricVariableUpdateEventEntity newVariableUpdateEventEntity(ExecutionEntity execution) {
        return new HistoricVariableUpdateEventEntity();
    }

    protected HistoricFormPropertyEventEntity newHistoricFormPropertyEvent() {
        return new HistoricFormPropertyEventEntity();
    }

    protected HistoricIncidentEventEntity newIncidentEventEntity(Incident incident) {
        return new HistoricIncidentEventEntity();
    }

    protected HistoricProcessInstanceEventEntity loadProcessInstanceEventEntity(ExecutionEntity execution) {
        return this.newProcessInstanceEventEntity(execution);
    }

    protected HistoricActivityInstanceEventEntity loadActivityInstanceEventEntity(ExecutionEntity execution) {
        return this.newActivityInstanceEventEntity(execution);
    }

    protected HistoricTaskInstanceEventEntity loadTaskInstanceEvent(DelegateTask task) {
        return this.newTaskInstanceEventEntity(task);
    }

    protected HistoricIncidentEventEntity loadIncidentEvent(Incident incident) {
        return this.newIncidentEventEntity(incident);
    }

    @Override
    public HistoryEvent createProcessInstanceStartEvt(DelegateExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        HistoricProcessInstanceEventEntity evt = this.newProcessInstanceEventEntity(executionEntity);
        this.initProcessInstanceEvent(evt, executionEntity, "start");
        evt.setStartActivityId(executionEntity.getActivityId());
        evt.setStartTime(ClockUtil.getCurrentTime());
        ExecutionEntity superExecution = executionEntity.getSuperExecution();
        if (superExecution != null) {
            evt.setSuperProcessInstanceId(superExecution.getProcessInstanceId());
        }
        evt.setStartUserId(Context.getCommandContext().getAuthenticatedUserId());
        return evt;
    }

    @Override
    public HistoryEvent createProcessInstanceEndEvt(DelegateExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        HistoricProcessInstanceEventEntity evt = this.loadProcessInstanceEventEntity(executionEntity);
        this.initProcessInstanceEvent(evt, executionEntity, "end");
        evt.setEndActivityId(executionEntity.getActivityId());
        evt.setEndTime(ClockUtil.getCurrentTime());
        if (evt.getStartTime() != null) {
            evt.setDurationInMillis(evt.getEndTime().getTime() - evt.getStartTime().getTime());
        }
        if (executionEntity.getDeleteReason() != null) {
            evt.setDeleteReason(executionEntity.getDeleteReason());
        }
        return evt;
    }

    @Override
    public HistoryEvent createActivityInstanceStartEvt(DelegateExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        HistoricActivityInstanceEventEntity evt = this.newActivityInstanceEventEntity(executionEntity);
        this.initActivityInstanceEvent(evt, (ExecutionEntity)execution, "start");
        evt.setStartTime(ClockUtil.getCurrentTime());
        return evt;
    }

    @Override
    public HistoryEvent createActivityInstanceUpdateEvt(DelegateExecution execution, DelegateTask task) {
        ExecutionEntity subProcessInstance;
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        HistoricActivityInstanceEventEntity evt = this.loadActivityInstanceEventEntity(executionEntity);
        this.initActivityInstanceEvent(evt, executionEntity, "update");
        if (task != null) {
            evt.setTaskId(task.getId());
            evt.setTaskAssignee(task.getAssignee());
        }
        if ((subProcessInstance = executionEntity.getSubProcessInstance()) != null) {
            evt.setCalledProcessInstanceId(subProcessInstance.getId());
        }
        return evt;
    }

    @Override
    public HistoryEvent createActivityInstanceEndEvt(DelegateExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        HistoricActivityInstanceEventEntity evt = this.loadActivityInstanceEventEntity(executionEntity);
        evt.setActivityInstanceState(executionEntity.getActivityInstanceState());
        this.initActivityInstanceEvent(evt, (ExecutionEntity)execution, "end");
        evt.setEndTime(ClockUtil.getCurrentTime());
        if (evt.getStartTime() != null) {
            evt.setDurationInMillis(evt.getEndTime().getTime() - evt.getStartTime().getTime());
        }
        return evt;
    }

    @Override
    public HistoryEvent createTaskInstanceCreateEvt(DelegateTask task) {
        HistoricTaskInstanceEventEntity evt = this.newTaskInstanceEventEntity(task);
        this.initTaskInstanceEvent(evt, (TaskEntity)task, "create");
        evt.setStartTime(ClockUtil.getCurrentTime());
        return evt;
    }

    @Override
    public HistoryEvent createTaskInstanceUpdateEvt(DelegateTask task) {
        HistoricTaskInstanceEventEntity evt = this.loadTaskInstanceEvent(task);
        this.initTaskInstanceEvent(evt, (TaskEntity)task, "update");
        return evt;
    }

    @Override
    public HistoryEvent createTaskInstanceCompleteEvt(DelegateTask task, String deleteReason) {
        HistoricTaskInstanceEventEntity evt = this.loadTaskInstanceEvent(task);
        this.initTaskInstanceEvent(evt, (TaskEntity)task, "delete");
        evt.setEndTime(ClockUtil.getCurrentTime());
        if (evt.getStartTime() != null) {
            evt.setDurationInMillis(evt.getEndTime().getTime() - evt.getStartTime().getTime());
        }
        evt.setDeleteReason(deleteReason);
        return evt;
    }

    @Override
    public List<HistoryEvent> createUserOperationLogEvents(UserOperationLogContext context) {
        ArrayList<HistoryEvent> historyEvents = new ArrayList<HistoryEvent>();
        String userId = null;
        CommandContext commandContext = Context.getCommandContext();
        if (commandContext != null) {
            userId = commandContext.getAuthenticatedUserId();
        }
        context.setUserId(userId);
        String operationId = Context.getProcessEngineConfiguration().getIdGenerator().getNextId();
        context.setOperationId(operationId);
        for (PropertyChange propertyChange : context.getPropertyChanges()) {
            UserOperationLogEntryEventEntity evt = new UserOperationLogEntryEventEntity();
            this.initUserOperationLogEvent(evt, context, propertyChange);
            historyEvents.add(evt);
        }
        return historyEvents;
    }

    @Override
    public HistoryEvent createHistoricVariableCreateEvt(VariableInstanceEntity variableInstance, VariableScope sourceVariableScope) {
        return this.createHistoricVariableEvent(variableInstance, sourceVariableScope, "create");
    }

    @Override
    public HistoryEvent createHistoricVariableDeleteEvt(VariableInstanceEntity variableInstance, VariableScope sourceVariableScope) {
        return this.createHistoricVariableEvent(variableInstance, sourceVariableScope, "delete");
    }

    @Override
    public HistoryEvent createHistoricVariableUpdateEvt(VariableInstanceEntity variableInstance, VariableScope sourceVariableScope) {
        return this.createHistoricVariableEvent(variableInstance, sourceVariableScope, "update");
    }

    @Override
    public HistoryEvent createFormPropertyUpdateEvt(ExecutionEntity execution, String propertyId, Object propertyValue, String taskId) {
        IdGenerator idGenerator = Context.getProcessEngineConfiguration().getIdGenerator();
        HistoricFormPropertyEventEntity historicFormPropertyEntity = this.newHistoricFormPropertyEvent();
        historicFormPropertyEntity.setId(idGenerator.getNextId());
        historicFormPropertyEntity.setEventType("form-property-update");
        historicFormPropertyEntity.setTimestamp(ClockUtil.getCurrentTime());
        historicFormPropertyEntity.setActivityInstanceId(execution.getActivityInstanceId());
        historicFormPropertyEntity.setExecutionId(execution.getId());
        historicFormPropertyEntity.setProcessDefinitionId(execution.getProcessDefinitionId());
        historicFormPropertyEntity.setProcessInstanceId(execution.getProcessInstanceId());
        historicFormPropertyEntity.setPropertyId(propertyId);
        historicFormPropertyEntity.setPropertyValue(propertyValue);
        historicFormPropertyEntity.setTaskId(taskId);
        return historicFormPropertyEntity;
    }

    @Override
    public HistoryEvent createHistoricIncidentCreateEvt(Incident incident) {
        return this.createHistoricIncidentEvt(incident, "create");
    }

    @Override
    public HistoryEvent createHistoricIncidentResolveEvt(Incident incident) {
        return this.createHistoricIncidentEvt(incident, "resolve");
    }

    @Override
    public HistoryEvent createHistoricIncidentDeleteEvt(Incident incident) {
        return this.createHistoricIncidentEvt(incident, "delete");
    }

    protected HistoryEvent createHistoricIncidentEvt(Incident incident, String eventType) {
        HistoricIncidentEventEntity evt = this.loadIncidentEvent(incident);
        this.initHistoricIncidentEvent(evt, incident, eventType);
        if (!"create".equals(eventType)) {
            evt.setEndTime(ClockUtil.getCurrentTime());
        }
        return evt;
    }
}

