/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.json;

import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.json.JsonObjectConverter;
import org.camunda.bpm.engine.impl.util.json.JSONArray;

public class JsonListConverter<T> {
    JsonObjectConverter<T> jsonObjectConverter;

    public JsonListConverter(JsonObjectConverter<T> jsonObjectConverter) {
        this.jsonObjectConverter = jsonObjectConverter;
    }

    public void toJson(List<T> list, Writer writer) {
        this.toJsonArray(list).write(writer);
    }

    public String toJson(List<T> list) {
        return this.toJsonArray(list).toString();
    }

    public String toJson(List<T> list, int indentFactor) {
        return this.toJsonArray(list).toString(indentFactor);
    }

    private JSONArray toJsonArray(List<T> objects) {
        JSONArray jsonArray = new JSONArray();
        for (T object : objects) {
            jsonArray.put(this.jsonObjectConverter.toJsonObject(object));
        }
        return jsonArray;
    }

    public List<T> toObject(Reader reader) {
        throw new ProcessEngineException("not yet implemented");
    }

    public JsonObjectConverter<T> getJsonObjectConverter() {
        return this.jsonObjectConverter;
    }

    public void setJsonObjectConverter(JsonObjectConverter<T> jsonObjectConverter) {
        this.jsonObjectConverter = jsonObjectConverter;
    }
}

