/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.Date;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbSqlSession;
import org.camunda.bpm.engine.impl.history.event.HistoricVariableUpdateEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.variable.ValueFields;
import org.camunda.bpm.engine.impl.variable.VariableType;

public class HistoricDetailVariableInstanceUpdateEntity
extends HistoricVariableUpdateEventEntity
implements ValueFields,
HistoricVariableUpdate {
    private static final long serialVersionUID = 1L;
    protected VariableType variableType;
    protected ByteArrayEntity byteArrayValue;
    protected Object cachedValue;
    protected String errorMessage;

    @Override
    public Object getValue() {
        if (!(this.errorMessage != null || this.variableType.isCachable() && this.cachedValue != null)) {
            try {
                this.cachedValue = this.variableType.getValue(this);
            }
            catch (RuntimeException e) {
                this.errorMessage = e.getMessage();
                throw e;
            }
        }
        return this.cachedValue;
    }

    public void delete() {
        DbSqlSession dbSqlSession = Context.getCommandContext().getDbSqlSession();
        dbSqlSession.delete(this);
        if (this.byteArrayId != null) {
            this.getByteArrayValue();
            Context.getCommandContext().getByteArrayManager().deleteByteArrayById(this.byteArrayId);
        }
    }

    @Override
    public String getVariableTypeName() {
        return this.variableType != null ? this.variableType.getTypeName() : null;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getByteArrayValueId() {
        return this.byteArrayId;
    }

    @Override
    public ByteArrayEntity getByteArrayValue() {
        if (this.byteArrayValue == null && this.byteArrayId != null && Context.getCommandContext() != null) {
            this.byteArrayValue = Context.getCommandContext().getDbSqlSession().selectById(ByteArrayEntity.class, this.byteArrayId);
        }
        return this.byteArrayValue;
    }

    @Override
    public void setByteArrayValue(byte[] bytes) {
        ByteArrayEntity byteArrayValue = null;
        if (this.byteArrayId != null) {
            this.getByteArrayValue();
            Context.getCommandContext().getByteArrayManager().deleteByteArrayById(this.byteArrayId);
        }
        if (bytes != null) {
            byteArrayValue = new ByteArrayEntity(bytes);
            Context.getCommandContext().getDbSqlSession().insert(byteArrayValue);
        }
        this.byteArrayValue = byteArrayValue;
        this.byteArrayId = byteArrayValue != null ? byteArrayValue.getId() : null;
    }

    protected void deleteByteArrayValue() {
        if (this.byteArrayId != null) {
            this.getByteArrayValue();
            Context.getCommandContext().getByteArrayManager().deleteByteArrayById(this.byteArrayId);
        }
    }

    @Override
    public String getName() {
        return this.getVariableName();
    }

    @Override
    public Date getTime() {
        return this.timestamp;
    }

    public VariableType getVariableType() {
        return this.variableType;
    }

    @Override
    public Object getCachedValue() {
        return this.cachedValue;
    }

    @Override
    public void setCachedValue(Object cachedValue) {
        this.cachedValue = cachedValue;
    }

    public void setVariableType(VariableType variableType) {
        this.variableType = variableType;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[byteArrayValue=" + this.byteArrayValue + ", variableName=" + this.variableName + ", variableInstanceId=" + this.variableInstanceId + ", revision=" + this.revision + ", variableTypeName=" + this.variableTypeName + ", longValue=" + this.longValue + ", doubleValue=" + this.doubleValue + ", textValue=" + this.textValue + ", textValue2=" + this.textValue2 + ", byteArrayId=" + this.byteArrayId + ", activityInstanceId=" + this.activityInstanceId + ", eventType=" + this.eventType + ", executionId=" + this.executionId + ", id=" + this.id + ", processDefinitionId=" + this.processInstanceId + ", processInstanceId=" + this.processInstanceId + ", taskId=" + this.taskId + ", timestamp=" + this.timestamp + "]";
    }
}

