/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.impl.persistence.AbstractManager;
import org.camunda.bpm.engine.impl.persistence.entity.IdentityLinkEntity;

public class IdentityLinkManager
extends AbstractManager {
    public void deleteIdentityLink(IdentityLinkEntity identityLink) {
        this.getDbSqlSession().delete(identityLink);
    }

    public List<IdentityLinkEntity> findIdentityLinksByTaskId(String taskId) {
        return this.getDbSqlSession().selectList("selectIdentityLinksByTask", taskId);
    }

    public List<IdentityLinkEntity> findIdentityLinksByProcessDefinitionId(String processDefinitionId) {
        return this.getDbSqlSession().selectList("selectIdentityLinksByProcessDefinition", processDefinitionId);
    }

    public List<IdentityLinkEntity> findIdentityLinkByTaskUserGroupAndType(String taskId, String userId, String groupId, String type) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("taskId", taskId);
        parameters.put("userId", userId);
        parameters.put("groupId", groupId);
        parameters.put("type", type);
        return this.getDbSqlSession().selectList("selectIdentityLinkByTaskUserGroupAndType", parameters);
    }

    public List<IdentityLinkEntity> findIdentityLinkByProcessDefinitionUserAndGroup(String processDefinitionId, String userId, String groupId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("processDefinitionId", processDefinitionId);
        parameters.put("userId", userId);
        parameters.put("groupId", groupId);
        return this.getDbSqlSession().selectList("selectIdentityLinkByProcessDefinitionUserAndGroup", parameters);
    }

    public void deleteIdentityLinksByTaskId(String taskId) {
        List<IdentityLinkEntity> identityLinks = this.findIdentityLinksByTaskId(taskId);
        for (IdentityLinkEntity identityLink : identityLinks) {
            this.deleteIdentityLink(identityLink);
        }
    }

    public void deleteIdentityLinksByProcDef(String processDefId) {
        this.getDbSqlSession().delete("deleteIdentityLinkByProcDef", processDefId);
    }
}

