/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.HashMap;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.HasRevision;
import org.camunda.bpm.engine.impl.db.PersistentObject;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.variable.ValueFields;
import org.camunda.bpm.engine.impl.variable.VariableType;
import org.camunda.bpm.engine.runtime.VariableInstance;

public class VariableInstanceEntity
implements VariableInstance,
ValueFields,
PersistentObject,
HasRevision,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected int revision;
    protected String name;
    protected String processInstanceId;
    protected String executionId;
    protected String taskId;
    protected String activityInstanceId;
    protected Long longValue;
    protected Double doubleValue;
    protected String textValue;
    protected String textValue2;
    protected ByteArrayEntity byteArrayValue;
    protected String byteArrayValueId;
    protected Object cachedValue;
    protected VariableType type;
    boolean forcedUpdate;
    protected String errorMessage;

    protected VariableInstanceEntity() {
    }

    public static VariableInstanceEntity createAndInsert(String name, VariableType type, Object value) {
        VariableInstanceEntity variableInstance = VariableInstanceEntity.create(name, type, value);
        Context.getCommandContext().getDbSqlSession().insert(variableInstance);
        return variableInstance;
    }

    public static VariableInstanceEntity create(String name, VariableType type, Object value) {
        VariableInstanceEntity variableInstance = new VariableInstanceEntity();
        variableInstance.name = name;
        variableInstance.type = type;
        variableInstance.setValue(value);
        return variableInstance;
    }

    public void setExecution(ExecutionEntity execution) {
        this.executionId = execution.getId();
        this.processInstanceId = execution.getProcessInstanceId();
        this.forcedUpdate = true;
    }

    public void delete() {
        Context.getCommandContext().getDbSqlSession().delete(this);
        this.deleteByteArrayValue();
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        if (this.type != null) {
            persistentState.put("type", this.type);
        }
        if (this.longValue != null) {
            persistentState.put("longValue", this.longValue);
        }
        if (this.doubleValue != null) {
            persistentState.put("doubleValue", this.doubleValue);
        }
        if (this.textValue != null) {
            persistentState.put("textValue", this.textValue);
        }
        if (this.byteArrayValueId != null) {
            persistentState.put("byteArrayValueId", this.byteArrayValueId);
        }
        if (this.forcedUpdate) {
            persistentState.put("forcedUpdate", Boolean.TRUE);
        }
        return persistentState;
    }

    @Override
    public int getRevisionNext() {
        return this.revision + 1;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public String getByteArrayValueId() {
        return this.byteArrayValueId;
    }

    public void setByteArrayValueId(String byteArrayValueId) {
        this.byteArrayValueId = byteArrayValueId;
        this.byteArrayValue = null;
    }

    @Override
    public ByteArrayEntity getByteArrayValue() {
        if (this.byteArrayValue == null && this.byteArrayValueId != null && Context.getCommandContext() != null) {
            this.byteArrayValue = Context.getCommandContext().getDbSqlSession().selectById(ByteArrayEntity.class, this.byteArrayValueId);
        }
        return this.byteArrayValue;
    }

    @Override
    public void setByteArrayValue(byte[] bytes) {
        ByteArrayEntity byteArrayValue = null;
        if (this.byteArrayValueId != null) {
            this.getByteArrayValue();
            Context.getCommandContext().getByteArrayManager().deleteByteArrayById(this.byteArrayValueId);
        }
        if (bytes != null) {
            byteArrayValue = new ByteArrayEntity(bytes);
            Context.getCommandContext().getDbSqlSession().insertBefore(byteArrayValue, this);
        }
        this.byteArrayValue = byteArrayValue;
        this.byteArrayValueId = byteArrayValue != null ? byteArrayValue.getId() : null;
    }

    protected void deleteByteArrayValue() {
        if (this.byteArrayValueId != null) {
            this.getByteArrayValue();
            Context.getCommandContext().getByteArrayManager().deleteByteArrayById(this.byteArrayValueId);
        }
    }

    @Override
    public Object getValue() {
        if (!(this.errorMessage != null || this.type.isCachable() && this.cachedValue != null)) {
            try {
                this.cachedValue = this.type.getValue(this);
            }
            catch (RuntimeException e) {
                this.errorMessage = e.getMessage();
                throw e;
            }
        }
        return this.cachedValue;
    }

    public void setValue(Object value) {
        this.type.setValue(value, this);
        this.cachedValue = value;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getTextValue() {
        return this.textValue;
    }

    @Override
    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    public Long getLongValue() {
        return this.longValue;
    }

    @Override
    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    @Override
    public Double getDoubleValue() {
        return this.doubleValue;
    }

    @Override
    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getRevision() {
        return this.revision;
    }

    @Override
    public void setRevision(int revision) {
        this.revision = revision;
    }

    public void setType(VariableType type) {
        this.type = type;
    }

    public VariableType getType() {
        return this.type;
    }

    @Override
    public Object getCachedValue() {
        return this.cachedValue;
    }

    @Override
    public void setCachedValue(Object cachedValue) {
        this.cachedValue = cachedValue;
    }

    @Override
    public String getTextValue2() {
        return this.textValue2;
    }

    @Override
    public void setTextValue2(String textValue2) {
        this.textValue2 = textValue2;
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Override
    public String getActivityInstanceId() {
        return this.activityInstanceId;
    }

    public void setActivityInstanceId(String acitivtyInstanceId) {
        this.activityInstanceId = acitivtyInstanceId;
    }

    @Override
    public String getTypeName() {
        return this.type != null ? this.type.getTypeName() : null;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getVariableScope() {
        if (this.taskId != null) {
            return this.taskId;
        }
        return this.executionId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.id + ", revision=" + this.revision + ", name=" + this.name + ", processInstanceId=" + this.processInstanceId + ", executionId=" + this.executionId + ", taskId=" + this.taskId + ", activityInstanceId=" + this.activityInstanceId + ", longValue=" + this.longValue + ", doubleValue=" + this.doubleValue + ", textValue=" + this.textValue + ", textValue2=" + this.textValue2 + ", byteArrayValue=" + this.byteArrayValue + ", byteArrayValueId=" + this.byteArrayValueId + ", forcedUpdate=" + this.forcedUpdate + "]";
    }
}

