/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.process;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.PvmProcessInstance;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.Lane;
import org.camunda.bpm.engine.impl.pvm.process.LaneSet;
import org.camunda.bpm.engine.impl.pvm.process.ParticipantProcess;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.ExecutionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.InterpretableExecution;

public class ProcessDefinitionImpl
extends ScopeImpl
implements PvmProcessDefinition {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String description;
    protected ActivityImpl initial;
    protected Map<ActivityImpl, List<ActivityImpl>> initialActivityStacks = new HashMap<ActivityImpl, List<ActivityImpl>>();
    protected List<LaneSet> laneSets;
    protected ParticipantProcess participantProcess;

    public ProcessDefinitionImpl(String id) {
        super(id, null);
        this.processDefinition = this;
    }

    @Override
    public PvmProcessInstance createProcessInstance() {
        if (this.initial == null) {
            throw new ProcessEngineException("Process '" + this.name + "' has no default start activity (e.g. none start event), hence you cannot use 'startProcessInstanceBy...' but have to start it using one of the modeled start events (e.g. message start events).");
        }
        return this.createProcessInstanceForInitial(this.initial);
    }

    public PvmProcessInstance createProcessInstanceForInitial(ActivityImpl initial) {
        if (initial == null) {
            throw new ProcessEngineException("Cannot start process instance, initial activity where the process instance should start is null.");
        }
        InterpretableExecution processInstance = this.newProcessInstance(initial);
        processInstance.setProcessDefinition(this);
        processInstance.setProcessInstance(processInstance);
        processInstance.initialize();
        InterpretableExecution scopeInstance = processInstance;
        List<ActivityImpl> initialActivityStack = this.getInitialActivityStack(initial);
        for (ActivityImpl initialActivity : initialActivityStack) {
            if (!initialActivity.isScope()) continue;
            scopeInstance = (InterpretableExecution)scopeInstance.createExecution();
            scopeInstance.setActivity(initialActivity);
            if (!initialActivity.isScope()) continue;
            scopeInstance.initialize();
        }
        scopeInstance.setActivity(initial);
        return processInstance;
    }

    public List<ActivityImpl> getInitialActivityStack() {
        return this.getInitialActivityStack(this.initial);
    }

    public synchronized List<ActivityImpl> getInitialActivityStack(ActivityImpl startActivity) {
        List<ActivityImpl> initialActivityStack = this.initialActivityStacks.get(startActivity);
        if (initialActivityStack == null) {
            initialActivityStack = new ArrayList<ActivityImpl>();
            for (ActivityImpl activity = startActivity; activity != null; activity = activity.getParentActivity()) {
                initialActivityStack.add(0, activity);
            }
            this.initialActivityStacks.put(startActivity, initialActivityStack);
        }
        return initialActivityStack;
    }

    protected InterpretableExecution newProcessInstance(ActivityImpl startActivity) {
        return new ExecutionImpl(startActivity);
    }

    @Override
    public String getDiagramResourceName() {
        return null;
    }

    @Override
    public String getDeploymentId() {
        return null;
    }

    public void addLaneSet(LaneSet newLaneSet) {
        this.getLaneSets().add(newLaneSet);
    }

    public Lane getLaneForId(String id) {
        if (this.laneSets != null && this.laneSets.size() > 0) {
            for (LaneSet set : this.laneSets) {
                Lane lane = set.getLaneForId(id);
                if (lane == null) continue;
                return lane;
            }
        }
        return null;
    }

    @Override
    public ActivityImpl getInitial() {
        return this.initial;
    }

    public void setInitial(ActivityImpl initial) {
        this.initial = initial;
    }

    public String toString() {
        return "ProcessDefinition(" + this.id + ")";
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return (String)this.getProperty("documentation");
    }

    public List<LaneSet> getLaneSets() {
        if (this.laneSets == null) {
            this.laneSets = new ArrayList<LaneSet>();
        }
        return this.laneSets;
    }

    public void setParticipantProcess(ParticipantProcess participantProcess) {
        this.participantProcess = participantProcess;
    }

    public ParticipantProcess getParticipantProcess() {
        return this.participantProcess;
    }

    @Override
    public ScopeImpl getParentScope() {
        return null;
    }
}

