/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime;

import java.util.List;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.impl.pvm.PvmException;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.AtomicOperation;
import org.camunda.bpm.engine.impl.pvm.runtime.InterpretableExecution;

public abstract class AbstractEventAtomicOperation
implements AtomicOperation {
    @Override
    public boolean isAsync(InterpretableExecution execution) {
        return false;
    }

    @Override
    public void execute(InterpretableExecution execution) {
        ScopeImpl scope = this.getScope(execution);
        List<ExecutionListener> exectionListeners = scope.getExecutionListeners(this.getEventName());
        int executionListenerIndex = execution.getExecutionListenerIndex();
        if (executionListenerIndex == 0) {
            execution = this.eventNotificationsStarted(execution);
        }
        if (!this.isSkipNotifyListeners(execution)) {
            if (exectionListeners.size() > executionListenerIndex) {
                execution.setEventName(this.getEventName());
                execution.setEventSource(scope);
                ExecutionListener listener = exectionListeners.get(executionListenerIndex);
                try {
                    listener.notify(execution);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new PvmException("couldn't execute event listener : " + e.getMessage(), e);
                }
                execution.setExecutionListenerIndex(executionListenerIndex + 1);
                execution.performOperationSync(this);
            } else {
                execution.setExecutionListenerIndex(0);
                execution.setEventName(null);
                execution.setEventSource(null);
                this.eventNotificationsCompleted(execution);
            }
        } else {
            this.eventNotificationsCompleted(execution);
        }
    }

    protected boolean isSkipNotifyListeners(InterpretableExecution execution) {
        return false;
    }

    protected InterpretableExecution eventNotificationsStarted(InterpretableExecution execution) {
        return execution;
    }

    protected abstract ScopeImpl getScope(InterpretableExecution var1);

    protected abstract String getEventName();

    protected abstract void eventNotificationsCompleted(InterpretableExecution var1);
}

