/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime;

import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.AtomicOperation;
import org.camunda.bpm.engine.impl.pvm.runtime.AtomicOperationActivityInstanceEnd;
import org.camunda.bpm.engine.impl.pvm.runtime.InterpretableExecution;

public class AtomicOperationDeleteCascadeFireActivityEnd
extends AtomicOperationActivityInstanceEnd {
    @Override
    protected boolean isSkipNotifyListeners(InterpretableExecution execution) {
        return false;
    }

    @Override
    protected InterpretableExecution eventNotificationsStarted(InterpretableExecution execution) {
        execution.setCanceled(true);
        return super.eventNotificationsStarted(execution);
    }

    @Override
    protected ScopeImpl getScope(InterpretableExecution execution) {
        ActivityImpl activity = (ActivityImpl)execution.getActivity();
        if (activity != null) {
            return activity;
        }
        InterpretableExecution parent = execution.getParent();
        if (parent != null) {
            return this.getScope(execution.getParent());
        }
        return execution.getProcessDefinition();
    }

    @Override
    protected String getEventName() {
        return "end";
    }

    @Override
    protected void eventNotificationsCompleted(InterpretableExecution execution) {
        super.eventNotificationsCompleted(execution);
        ActivityImpl activity = (ActivityImpl)execution.getActivity();
        if (execution.isScope() && activity != null && !activity.isScope()) {
            execution.setActivity(activity.getParentActivity());
            execution.performOperation(AtomicOperation.DELETE_CASCADE_FIRE_ACTIVITY_END);
        } else {
            InterpretableExecution parent;
            if (execution.isScope()) {
                execution.destroy();
            }
            execution.remove();
            if (!execution.isDeleteRoot() && (parent = execution.getParent()) != null) {
                parent.performOperation(AtomicOperation.DELETE_CASCADE);
            }
        }
    }

    @Override
    public String getCanonicalName() {
        return "delete-cascade-fire-activity-end";
    }
}

