/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime;

import java.util.List;
import java.util.logging.Logger;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.impl.pvm.PvmException;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.AtomicOperation;
import org.camunda.bpm.engine.impl.pvm.runtime.InterpretableExecution;

public class AtomicOperationTransitionNotifyListenerTake
implements AtomicOperation {
    private static Logger log = Logger.getLogger(AtomicOperationTransitionNotifyListenerTake.class.getName());

    @Override
    public boolean isAsync(InterpretableExecution execution) {
        return false;
    }

    @Override
    public void execute(InterpretableExecution execution) {
        TransitionImpl transition = execution.getTransition();
        execution.setActivityInstanceId(null);
        List<ExecutionListener> executionListeners = transition.getExecutionListeners();
        int executionListenerIndex = execution.getExecutionListenerIndex();
        if (executionListeners.size() > executionListenerIndex) {
            execution.setEventName("take");
            execution.setEventSource(transition);
            ExecutionListener listener = executionListeners.get(executionListenerIndex);
            try {
                listener.notify(execution);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PvmException("couldn't execute event listener : " + e.getMessage(), e);
            }
            execution.setExecutionListenerIndex(executionListenerIndex + 1);
            execution.performOperation(this);
        } else {
            log.fine(execution + " takes transition " + transition);
            execution.setExecutionListenerIndex(0);
            execution.setEventName(null);
            execution.setEventSource(null);
            ActivityImpl activity = (ActivityImpl)execution.getActivity();
            ActivityImpl nextScope = AtomicOperationTransitionNotifyListenerTake.findNextScope((ScopeImpl)activity.getFlowScope(), transition.getDestination());
            execution.setActivity(nextScope);
            if (nextScope.isCancelScope()) {
                execution.performOperation(TRANSITION_CANCEL_SCOPE);
            } else {
                execution.performOperation(TRANSITION_CREATE_SCOPE);
            }
        }
    }

    public static ActivityImpl findNextScope(ScopeImpl outerScopeElement, ActivityImpl destination) {
        ActivityImpl nextScope = destination;
        while (nextScope.getParent() instanceof ActivityImpl && nextScope.getParent() != outerScopeElement) {
            nextScope = (ActivityImpl)nextScope.getParent();
        }
        return nextScope;
    }

    @Override
    public String getCanonicalName() {
        return "transition-notify-listener-take";
    }
}

