/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.scripting;

import java.util.ArrayList;
import java.util.List;
import javax.script.Bindings;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.scripting.Resolver;
import org.camunda.bpm.engine.impl.scripting.ResolverFactory;
import org.camunda.bpm.engine.impl.scripting.ScriptBindings;

public class ScriptBindingsFactory {
    protected List<ResolverFactory> resolverFactories;

    public ScriptBindingsFactory(List<ResolverFactory> resolverFactories) {
        this.resolverFactories = resolverFactories;
    }

    public Bindings createBindings(VariableScope variableScope) {
        ArrayList<Resolver> scriptResolvers = new ArrayList<Resolver>();
        for (ResolverFactory scriptResolverFactory : this.resolverFactories) {
            Resolver resolver = scriptResolverFactory.createResolver(variableScope);
            if (resolver == null) continue;
            scriptResolvers.add(resolver);
        }
        return new ScriptBindings(scriptResolvers, variableScope);
    }

    public List<ResolverFactory> getResolverFactories() {
        return this.resolverFactories;
    }

    public void setResolverFactories(List<ResolverFactory> resolverFactories) {
        this.resolverFactories = resolverFactories;
    }
}

